/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.dsgf;

import ds.DateTime;
import ds.gun.VirtualBullet;
import ds.targeting.IVirtualBot;
import java.awt.geom.Point2D;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class SegmentationInfo {
    private Vector<Double> m_values = new Vector();
    private DateTime m_dateTime;
    private static Vector<String> m_names = new Vector();

    public SegmentationInfo(VirtualBullet vb) {
        double frontDistanceFromBottomWall;
        double frontDistanceFromTopWall;
        double frontDistanceFromLeftWall;
        DateTime dateTime = vb.getDateTime();
        double distance = vb.getInitialDistance() / (20.0 - 3.0 * vb.getBulletPower());
        double enemySpeed = vb.getInitialTargetVelocity();
        double relativeHeading = Utils.normalRelativeAngle((double)(vb.getInitialTargetHeadingRadians() - vb.getInitialAbsoluteBearingRadians()));
        double turnRate = vb.getTurnRate();
        double lateralVelocity = enemySpeed * Math.sin(vb.getInitialTargetHeadingRadians() - vb.getInitialAbsoluteBearingRadians());
        lateralVelocity = Math.abs(lateralVelocity);
        double lateralAccell = vb.getLateralAccell();
        double advancingVelocity = enemySpeed * -1.0 * Math.cos(vb.getInitialTargetHeadingRadians() - vb.getInitialAbsoluteBearingRadians());
        double distanceFromLeftWall = vb.getInitialTargetPosition().getX();
        double distanceFromRightWall = 800.0 - vb.getInitialTargetPosition().getX();
        double distanceFromTopWall = 600.0 - vb.getInitialTargetPosition().getY();
        double distanceFromBottomWall = vb.getInitialTargetPosition().getY();
        double distanceFromWall = Math.min(Math.min(Math.min(distanceFromLeftWall, distanceFromRightWall), distanceFromTopWall), distanceFromBottomWall);
        double enemyVerticalSpeed = enemySpeed * Math.cos(vb.getInitialTargetHeadingRadians());
        double enemyHorizontalSpeed = enemySpeed * Math.sin(vb.getInitialTargetHeadingRadians());
        double frontDistanceFromRightWall = (800.0 - vb.getInitialTargetPosition().getX()) / enemyHorizontalSpeed;
        if (frontDistanceFromRightWall < 0.0) {
            frontDistanceFromRightWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromLeftWall = -vb.getInitialTargetPosition().getX() / enemyHorizontalSpeed) < 0.0) {
            frontDistanceFromLeftWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromTopWall = (600.0 - vb.getInitialTargetPosition().getY()) / enemyVerticalSpeed) < 0.0) {
            frontDistanceFromTopWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromBottomWall = -vb.getInitialTargetPosition().getY() / enemyVerticalSpeed) < 0.0) {
            frontDistanceFromBottomWall = Double.POSITIVE_INFINITY;
        }
        double frontDistanceFromWall = Math.min(Math.min(Math.min(frontDistanceFromLeftWall, frontDistanceFromRightWall), frontDistanceFromTopWall), frontDistanceFromBottomWall);
        Point2D.Double targetPos = vb.getInitialTargetPosition();
        Point2D.Double brCorner = new Point2D.Double(800.0, 0.0);
        Point2D.Double blCorner = new Point2D.Double(0.0, 0.0);
        Point2D.Double trCorner = new Point2D.Double(800.0, 600.0);
        Point2D.Double tlCorner = new Point2D.Double(0.0, 600.0);
        double distanceFromCorners = Math.min(Math.min(Math.min(targetPos.distance(brCorner), targetPos.distance(blCorner)), targetPos.distance(trCorner)), targetPos.distance(tlCorner));
        double timeSinceLastVelocityChange = vb.getTimeSinceLastVelocityChange();
        double timeSinceLastAccel = vb.getTimeSinceLastAccel();
        double timeSinceLastDeccel = vb.getTimeSinceLastDeccel();
        double timeSinceLastVelocityInversion = vb.getTimeSinceLastVelocityInversion();
        double acceleration = vb.getAcceleration();
        double distanceLast10 = vb.getPositionLog().distanceSince(10);
        double distanceLast30 = vb.getPositionLog().distanceSince(30);
        this.Build(dateTime, distance, enemySpeed, relativeHeading, turnRate, lateralVelocity, lateralAccell, advancingVelocity, distanceFromWall, distanceFromCorners, timeSinceLastVelocityChange, timeSinceLastAccel, timeSinceLastDeccel, timeSinceLastVelocityInversion, acceleration, frontDistanceFromWall, distanceLast10, distanceLast30);
    }

    public SegmentationInfo(AdvancedRobot owner, IVirtualBot target, double power) {
        double frontDistanceFromBottomWall;
        double frontDistanceFromTopWall;
        double frontDistanceFromLeftWall;
        DateTime dateTime = target.getDateTime();
        double distance = target.getDistance() / (20.0 - 3.0 * power);
        double enemySpeed = target.getVelocity();
        double relativeHeading = Utils.normalRelativeAngle((double)(target.getHeadingRadians() - target.getAbsoluteBearingRadians()));
        double turnRate = target.getTurnRate();
        double lateralVelocity = enemySpeed * Math.sin(target.getHeadingRadians() - target.getAbsoluteBearingRadians());
        lateralVelocity = Math.abs(lateralVelocity);
        double lateralAccell = target.getLateralAccell();
        double advancingVelocity = enemySpeed * -1.0 * Math.cos(target.getHeadingRadians() - target.getAbsoluteBearingRadians());
        double distanceFromLeftWall = target.getPosition().getX();
        double distanceFromRightWall = 800.0 - target.getPosition().getX();
        double distanceFromTopWall = 600.0 - target.getPosition().getY();
        double distanceFromBottomWall = target.getPosition().getY();
        double distanceFromWall = Math.min(Math.min(Math.min(distanceFromLeftWall, distanceFromRightWall), distanceFromTopWall), distanceFromBottomWall);
        double enemyVerticalSpeed = enemySpeed * Math.cos(target.getHeadingRadians());
        double enemyHorizontalSpeed = enemySpeed * Math.sin(target.getHeadingRadians());
        double frontDistanceFromRightWall = (800.0 - target.getPosition().getX()) / enemyHorizontalSpeed;
        if (frontDistanceFromRightWall < 0.0) {
            frontDistanceFromRightWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromLeftWall = -target.getPosition().getX() / enemyHorizontalSpeed) < 0.0) {
            frontDistanceFromLeftWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromTopWall = (600.0 - target.getPosition().getY()) / enemyVerticalSpeed) < 0.0) {
            frontDistanceFromTopWall = Double.POSITIVE_INFINITY;
        }
        if ((frontDistanceFromBottomWall = -target.getPosition().getY() / enemyVerticalSpeed) < 0.0) {
            frontDistanceFromBottomWall = Double.POSITIVE_INFINITY;
        }
        double frontDistanceFromWall = Math.min(Math.min(Math.min(frontDistanceFromLeftWall, frontDistanceFromRightWall), frontDistanceFromTopWall), frontDistanceFromBottomWall);
        Point2D.Double targetPos = target.getPosition();
        Point2D.Double brCorner = new Point2D.Double(800.0, 0.0);
        Point2D.Double blCorner = new Point2D.Double(0.0, 0.0);
        Point2D.Double trCorner = new Point2D.Double(800.0, 600.0);
        Point2D.Double tlCorner = new Point2D.Double(0.0, 600.0);
        double distanceFromCorners = Math.min(Math.min(Math.min(targetPos.distance(brCorner), targetPos.distance(blCorner)), targetPos.distance(trCorner)), targetPos.distance(tlCorner));
        double timeSinceLastVelocityChange = target.getTimeSinceLastVelocityChange();
        double timeSinceLastAccel = target.getTimeSinceLastAccel();
        double timeSinceLastDeccel = target.getTimeSinceLastDeccel();
        double timeSinceLastVelocityInversion = target.getTimeSinceLastVelocityInversion();
        double acceleration = target.getAcceleration() * Math.signum(enemySpeed - 1.0E-12);
        double distanceLast10 = target.getPositionLog().distanceSince(10);
        double distanceLast30 = target.getPositionLog().distanceSince(30);
        this.Build(dateTime, distance, enemySpeed, relativeHeading, turnRate, lateralVelocity, lateralAccell, advancingVelocity, distanceFromWall, distanceFromCorners, timeSinceLastVelocityChange, timeSinceLastAccel, timeSinceLastDeccel, timeSinceLastVelocityInversion, acceleration, frontDistanceFromWall, distanceLast10, distanceLast30);
    }

    public void Build(DateTime dateTime, double distance, double enemySpeed, double relativeHeading, double turnRate, double lateralVelocity, double lateralAccell, double advancingVelocity, double distanceFromWall, double distanceFromCorners, double timeSinceLastVelocityChange, double timeSinceLastAccel, double timeSinceLastDeccel, double timeSinceLastVelocityInversion, double acceleration, double frontDistanceFromWall, double distanceLast10, double distanceLast30) {
        this.m_dateTime = dateTime;
        m_names.clear();
        m_names.add("distance");
        this.m_values.add(distance);
        m_names.add("enemySpeed");
        this.m_values.add(enemySpeed);
        m_names.add("relativeHeading");
        this.m_values.add(relativeHeading);
        m_names.add("turnRate");
        this.m_values.add(turnRate);
        m_names.add("lateralVelocity");
        this.m_values.add(lateralVelocity);
        m_names.add("lateralAccell");
        this.m_values.add(lateralAccell);
        m_names.add("advancingVelocity");
        this.m_values.add(advancingVelocity);
        m_names.add("distanceFromWall");
        this.m_values.add(distanceFromWall);
        m_names.add("distanceFromCorners");
        this.m_values.add(distanceFromCorners);
        m_names.add("timeSinceLastVelocityChange");
        this.m_values.add(timeSinceLastVelocityChange);
        m_names.add("timeSinceLastDeccel");
        this.m_values.add(timeSinceLastDeccel);
        m_names.add("timeSinceLastAccel");
        this.m_values.add(timeSinceLastAccel);
        m_names.add("timeSinceLastVelocityInversion");
        this.m_values.add(timeSinceLastVelocityInversion);
        m_names.add("acceleration");
        this.m_values.add(acceleration);
        m_names.add("frontDistanceFromWall");
        this.m_values.add(frontDistanceFromWall);
        m_names.add("distanceLast10");
        this.m_values.add(distanceLast10);
        m_names.add("distanceLast30");
        this.m_values.add(distanceLast30);
    }

    public final double getInfo(int segmentingInfoIndex) {
        if (segmentingInfoIndex >= 0) {
            return this.m_values.elementAt(segmentingInfoIndex);
        }
        return this.m_dateTime.toDouble();
    }

    public int getDImCount() {
        return this.m_values.size();
    }

    public static String getDimensionName(int segmentingInfoIndex) {
        return m_names.elementAt(segmentingInfoIndex);
    }
}

