/*
 * Decompiled with CFR 0.152.
 */
package inonit.script.engine;

import inonit.script.engine.Code;
import inonit.script.engine.Java;
import inonit.script.runtime.io.Streams;
import inonit.system.Logging;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Loader {
    private static final Logger LOGGER = Logger.getLogger(Loader.class.getName());
    private static final Logging LOG = Logging.get();

    public abstract String getLoaderCode(String var1) throws IOException;

    public abstract Classes.Interface getClasspath();

    public abstract String getCoffeeScript() throws IOException;

    public abstract Typescript getTypescript() throws IOException;

    public static abstract class Classes {
        abstract File getLocalClassCache();

        abstract ClassLoader getClassLoader();

        public abstract ClassLoader getApplicationClassLoader();

        public abstract Interface getInterface();

        public static Classes create(final Configuration configuration) {
            if (configuration.canCreateClassLoaders()) {
                final ClassLoaderImpl loaderClasses = ClassLoaderImpl.create(configuration.getApplicationClassLoader());
                return new Classes(){
                    private Interface api;

                    @Override
                    public ClassLoader getApplicationClassLoader() {
                        return loaderClasses;
                    }

                    @Override
                    File getLocalClassCache() {
                        LOG.log(Loader.class, Level.FINE, "Local class cache: " + configuration.getLocalClassCache(), null);
                        return configuration.getLocalClassCache();
                    }

                    @Override
                    ClassLoader getClassLoader() {
                        return loaderClasses;
                    }

                    @Override
                    public Interface getInterface() {
                        if (this.api == null) {
                            this.api = new Interface(loaderClasses);
                        }
                        return this.api;
                    }
                };
            }
            final ClassLoader loader = configuration.getApplicationClassLoader();
            return new Classes(){

                @Override
                public ClassLoader getApplicationClassLoader() {
                    return loader;
                }

                @Override
                File getLocalClassCache() {
                    LOG.log(Loader.class, Level.FINE, "Local class cache: null", null);
                    return null;
                }

                @Override
                ClassLoader getClassLoader() {
                    return null;
                }

                @Override
                public Interface getInterface() {
                    return null;
                }
            };
        }

        private static class ClassLoaderImpl
        extends ClassLoader {
            private Streams streams = new Streams();
            private ArrayList<Code.Loader> locations = new ArrayList();

            static ClassLoaderImpl create(ClassLoader parent) {
                LOGGER.log(Level.FINE, "Creating Loader.Classes: parent=%s", parent);
                return new ClassLoaderImpl(parent);
            }

            private ClassLoaderImpl(ClassLoader parent) {
                super(parent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                String rv = this.getClass().getName() + ": delegate=" + this.getParent() + " locations=[";
                ArrayList<Code.Loader> arrayList = this.locations;
                synchronized (arrayList) {
                    for (int i = 0; i < this.locations.size(); ++i) {
                        rv = rv + this.locations.get(i);
                        if (i + 1 == this.locations.size()) continue;
                        rv = rv + ",";
                    }
                }
                rv = rv + "]";
                return rv;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                String path = name.replace('.', '/') + ".class";
                String[] tokens = name.split("\\.");
                String packageName = tokens[0];
                for (int i = 1; i < tokens.length - 1; ++i) {
                    packageName = packageName + "." + tokens[i];
                }
                ArrayList<Code.Loader> arrayList = this.locations;
                synchronized (arrayList) {
                    for (Code.Loader source : this.locations) {
                        try {
                            Code.Loader.Resource in = source.getFile(path);
                            if (in == null) continue;
                            if (this.getPackage(packageName) == null) {
                                this.definePackage(packageName, null, null, null, null, null, null, null);
                            }
                            byte[] b = this.streams.readBytes(in.getInputStream());
                            return this.defineClass(name, b, 0, b.length);
                        }
                        catch (IOException iOException) {
                        }
                    }
                }
                throw new ClassNotFoundException(name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected URL findResource(String name) {
                ArrayList<Code.Loader> arrayList = this.locations;
                synchronized (arrayList) {
                    for (Code.Loader source : this.locations) {
                        URL url;
                        Code.Locator classes = source.getLocator();
                        if (classes == null || (url = classes.getResource(name)) == null) continue;
                        return url;
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Enumeration<URL> findResources(String name) {
                Vector<URL> rv = new Vector<URL>();
                ArrayList<Code.Loader> arrayList = this.locations;
                synchronized (arrayList) {
                    for (Code.Loader source : this.locations) {
                        URL url;
                        Code.Locator classes = source.getLocator();
                        if (classes == null || (url = classes.getResource(name)) == null) continue;
                        rv.add(url);
                    }
                }
                return rv.elements();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void append(Code.Loader code) {
                ArrayList<Code.Loader> arrayList = this.locations;
                synchronized (arrayList) {
                    this.locations.add(code);
                }
            }
        }

        public class Interface {
            private ClassLoaderImpl loader;
            private Java.Store store;

            Interface(ClassLoaderImpl loader) {
                this.loader = loader;
            }

            public void setAsThreadContextClassLoaderFor(Thread thread) {
                thread.setContextClassLoader(this.loader);
            }

            public final void add(Code.Loader code) {
                this.loader.append(code);
            }

            public final void addJar(File file) throws IOException {
                this.loader.append(Code.Loader.jar(file));
            }

            public final Class<?> getClass(String name) {
                try {
                    return Classes.this.getClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }

            private Java.Store getCompileDestination() {
                LOG.log(Loader.class, Level.FINE, "getCompileDestination", null);
                if (this.store == null) {
                    if (Classes.this.getLocalClassCache() == null) {
                        return Java.Store.memory();
                    }
                    return Java.Store.file(Classes.this.getLocalClassCache());
                }
                return this.store;
            }

            public final Code.Loader compiling(Code.Loader base) {
                return Java.compiling(base, this.getCompileDestination(), Classes.this.getClassLoader());
            }
        }

        public static abstract class Configuration {
            public abstract boolean canCreateClassLoaders();

            public abstract ClassLoader getApplicationClassLoader();

            public abstract File getLocalClassCache();
        }
    }

    public static abstract class Typescript {
        public abstract String compile(String var1) throws IOException;
    }
}

