/*
 * Decompiled with CFR 0.152.
 */
package tripphippy;

import java.awt.geom.Point2D;
import java.util.Vector;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import tripphippy.StatusMessage;
import wiki.HelperMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BotData {
    public String name;
    public double x;
    public double y;
    public double lastx;
    public double lasty;
    public double energy;
    public double lastEnergy;
    public double direction;
    public double lastDirection;
    public double velocity;
    public double lastVelocity;
    public long lastUpdate;
    public double hits;
    public double shotsFiredAt;
    public boolean dead;
    public boolean friend;
    public boolean leader;
    public Vector<State> history;
    public static TeamRobot r;
    public static final int HISTORY_SIZE = 10;
    public static final int UPDATE_TOLERANCE = 8;
    public static final int MAX_HISTORY = Integer.MAX_VALUE;

    public BotData(TeamRobot in_r) {
        r = in_r;
        this.name = "";
        this.x = 0.0;
        this.y = 0.0;
        this.lastx = 0.0;
        this.lasty = 0.0;
        this.energy = 0.0;
        this.lastEnergy = 0.0;
        this.direction = 0.0;
        this.lastDirection = 0.0;
        this.velocity = 0.0;
        this.lastVelocity = 0.0;
        this.lastUpdate = 0L;
        this.hits = 0.0;
        this.shotsFiredAt = 0.0;
        this.dead = true;
        this.friend = false;
        this.leader = false;
        this.history = new Vector();
    }

    public void Reset() {
        this.dead = true;
        this.friend = false;
        this.leader = false;
        this.lastUpdate = 0L;
    }

    public boolean isUpdated() {
        if (this.dead || this.lastUpdate == 0L || this.lastUpdate > r.getTime()) {
            return false;
        }
        return r.getTime() - this.lastUpdate <= 8L;
    }

    public boolean isShooting() {
        return this.getEnergyChange() > -3.0 && this.getEnergyChange() < -0.1;
    }

    public double getEnergyChange() {
        return this.energy - this.lastEnergy;
    }

    public double getDirectionChange() {
        return Utils.normalRelativeAngle((double)(this.direction - this.lastDirection));
    }

    public double getAcceleration() {
        return this.velocity - this.lastVelocity;
    }

    public double getHitRatio() {
        if (this.shotsFiredAt > 0.0) {
            return this.hits / this.shotsFiredAt;
        }
        return 0.0;
    }

    public Vector<State> getLastPattern() {
        int begindex;
        Vector<State> last = new Vector<State>();
        for (int i = begindex = Math.max(this.history.size() - 10, 0); i < this.history.size(); ++i) {
            last.add(this.history.elementAt(i));
        }
        return last;
    }

    public Point2D.Double getPredictedPosition(int numTicks) {
        Point2D.Double pos = new Point2D.Double(this.x, this.y);
        int index = this.findIndexOfNearestPatternMatch();
        if (index > 0) {
            int endIndex = Math.min(index + numTicks, this.history.size());
            for (int i = index; i < index + numTicks; ++i) {
                State currState = i < endIndex ? this.history.elementAt(i) : this.history.elementAt(this.history.size() - 1);
                pos.setLocation(pos.getX() + HelperMethods.getXcomponent(currState.direction, currState.velocity), pos.getY() + HelperMethods.getYcomponent(currState.direction, currState.velocity));
                r.getGraphics().drawOval((int)pos.getX() - 3, (int)pos.getY() - 3, 6, 6);
            }
        }
        double wid = (r.getWidth() + r.getHeight()) / 4.0;
        if (pos.getX() < wid) {
            pos.setLocation(wid, pos.getY());
        }
        if (pos.getX() > r.getBattleFieldWidth() - wid) {
            pos.setLocation(r.getBattleFieldWidth() - wid, pos.getY());
        }
        if (pos.getY() < wid) {
            pos.setLocation(pos.getX(), wid);
        }
        if (pos.getY() > r.getBattleFieldHeight() - wid) {
            pos.setLocation(pos.getX(), r.getBattleFieldHeight() - wid);
        }
        return pos;
    }

    public Point2D.Double getPredictedPositionDelta(int numTicks) {
        Point2D.Double pos = new Point2D.Double(this.x, this.y);
        int index = this.findIndexOfNearestPatternMatchDelta();
        if (index > 0) {
            int endIndex = Math.min(index + numTicks, this.history.size());
            double dir = this.direction;
            for (int i = index; i < index + numTicks; ++i) {
                State currState = i < endIndex ? this.history.elementAt(i) : this.history.elementAt(this.history.size() - 1);
                pos.setLocation(pos.getX() + HelperMethods.getXcomponent(dir += currState.deltaD, currState.velocity), pos.getY() + HelperMethods.getYcomponent(dir, currState.velocity));
                r.getGraphics().drawOval((int)pos.getX() - 3, (int)pos.getY() - 3, 6, 6);
            }
        }
        double wid = (r.getWidth() + r.getHeight()) / 4.0;
        if (pos.getX() < wid) {
            pos.setLocation(wid, pos.getY());
        }
        if (pos.getX() > r.getBattleFieldWidth() - wid) {
            pos.setLocation(r.getBattleFieldWidth() - wid, pos.getY());
        }
        if (pos.getY() < wid) {
            pos.setLocation(pos.getX(), wid);
        }
        if (pos.getY() > r.getBattleFieldHeight() - wid) {
            pos.setLocation(pos.getX(), r.getBattleFieldHeight() - wid);
        }
        return pos;
    }

    public void Update(ScannedRobotEvent e) {
        this.name = e.getName();
        this.lastUpdate = e.getTime();
        if (this.dead) {
            this.lastDirection = e.getHeadingRadians();
            this.lastEnergy = e.getEnergy();
            this.lastVelocity = e.getVelocity();
            if (this.lastEnergy > 196.0) {
                this.leader = true;
            }
            this.lastx = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), e.getDistance()) + r.getX();
            this.lasty = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), e.getDistance()) + r.getY();
        } else {
            this.lastDirection = this.direction;
            this.lastEnergy = this.energy;
            this.lastVelocity = this.velocity;
            this.lastx = this.x;
            this.lasty = this.y;
        }
        this.x = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), e.getDistance()) + r.getX();
        this.y = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), e.getDistance()) + r.getY();
        this.direction = e.getHeadingRadians();
        this.energy = e.getEnergy();
        this.velocity = e.getVelocity();
        this.history.add(new State(this.velocity, this.getDirectionChange(), this.direction));
        if (this.history.size() > Integer.MAX_VALUE) {
            this.history.remove(0);
        }
        this.friend = r.isTeammate(e.getName());
        this.dead = false;
    }

    public void Update(StatusMessage m) {
        if (this.lastUpdate > m.time) {
            return;
        }
        if (m.dead) {
            this.name = m.name;
            this.energy = 0.0;
            this.lastEnergy = 0.0;
            this.lastUpdate = m.time;
            this.dead = true;
        } else {
            this.name = m.name;
            this.lastUpdate = m.time;
            this.x = m.x;
            this.y = m.y;
            this.lastDirection = m.lastDirection;
            this.direction = m.direction;
            this.lastVelocity = m.lastVelocity;
            this.velocity = m.velocity;
            this.lastEnergy = m.lastEnergy;
            this.energy = m.energy;
            if (this.energy > 196.0) {
                this.leader = true;
            }
            this.history.add(new State(this.velocity, this.getDirectionChange(), this.direction));
            if (this.history.size() > Integer.MAX_VALUE) {
                this.history.remove(0);
            }
            this.friend = r.isTeammate(m.name);
            this.dead = false;
        }
    }

    public void Update(RobotDeathEvent e) {
        this.name = e.getName();
        this.energy = 0.0;
        this.lastEnergy = 0.0;
        this.lastUpdate = e.getTime();
        this.dead = true;
    }

    public void Update(BulletHitEvent e) {
        this.name = e.getName();
        this.lastEnergy = this.dead ? e.getEnergy() : this.energy;
        this.energy = e.getEnergy();
        this.dead = this.energy <= 0.0;
        this.hits += 1.0;
        this.friend = r.isTeammate(e.getName());
    }

    public void Update(HitRobotEvent e) {
        if (this.dead) {
            this.lastEnergy = e.getEnergy();
            this.lastx = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getWidth()) + r.getX();
            this.lasty = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getHeight()) + r.getY();
            this.lastUpdate = e.getTime();
        } else {
            this.lastEnergy = this.energy;
            this.lastx = this.x;
            this.lasty = this.y;
        }
        this.x = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getWidth()) + r.getX();
        this.y = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getHeight()) + r.getY();
        this.energy = e.getEnergy();
        this.name = e.getName();
        this.friend = r.isTeammate(e.getName());
    }

    public void Update(HitByBulletEvent e) {
        if (this.dead) {
            this.lastx = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getWidth()) + r.getX();
            this.lasty = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getHeight()) + r.getY();
            this.x = HelperMethods.getXcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getWidth()) + r.getX();
            this.y = HelperMethods.getYcomponent(e.getBearingRadians() + r.getHeadingRadians(), r.getHeight()) + r.getY();
            this.lastUpdate = e.getTime();
        }
        this.name = e.getName();
        this.friend = r.isTeammate(e.getName());
    }

    public void Update(DeathEvent e) {
        this.lastUpdate = 0L;
        this.dead = true;
    }

    public void Run() {
        if (!this.dead && r.getTime() > this.lastUpdate) {
            this.lastx = this.x;
            this.lasty = this.y;
            this.x += HelperMethods.getXcomponent(this.direction, this.velocity);
            this.y += HelperMethods.getYcomponent(this.direction, this.velocity);
            this.history.add(new State(this.velocity, this.getDirectionChange(), this.direction));
            if (this.history.size() > Integer.MAX_VALUE) {
                this.history.remove(0);
            }
        }
    }

    public int findIndexOfNearestPatternMatch() {
        double score = Double.POSITIVE_INFINITY;
        int location = -1;
        double currScore = 0.0;
        Vector<State> pattern = this.getLastPattern();
        int endex = this.history.size() - 10 - pattern.size();
        for (int i = 0; i < endex; ++i) {
            currScore = this.calcDifference(pattern, i);
            if (!(currScore < score)) continue;
            score = currScore;
            location = i + pattern.size();
        }
        return location;
    }

    public double calcDifference(Vector<State> pattern, int indexInHistory) {
        double diff = 0.0;
        for (int i = 0; i < pattern.size(); ++i) {
            diff += pattern.elementAt(i).getDiff(this.history.elementAt(indexInHistory + i));
        }
        return diff;
    }

    public int findIndexOfNearestPatternMatchDelta() {
        double score = Double.POSITIVE_INFINITY;
        int location = -1;
        double currScore = 0.0;
        Vector<State> pattern = this.getLastPattern();
        int endex = this.history.size() - 10 - pattern.size();
        for (int i = 0; i < endex; ++i) {
            currScore = this.calcDifferenceDelta(pattern, i);
            if (!(currScore < score)) continue;
            score = currScore;
            location = i + pattern.size();
        }
        return location;
    }

    public double calcDifferenceDelta(Vector<State> pattern, int indexInHistory) {
        double diff = 0.0;
        for (int i = 0; i < pattern.size(); ++i) {
            diff += pattern.elementAt(i).getDiffDelta(this.history.elementAt(indexInHistory + i));
        }
        return diff;
    }

    public class State {
        public double velocity;
        public double deltaD;
        public double direction;

        public State(double vel, double dirchange, double dir) {
            this.velocity = vel;
            this.deltaD = Utils.normalRelativeAngle((double)dirchange);
            this.direction = dir;
        }

        public boolean equals(State other) {
            return Utils.isNear((double)this.velocity, (double)other.velocity) && Utils.isNear((double)this.deltaD, (double)other.deltaD);
        }

        public double getDiffDelta(State other) {
            return Math.abs(this.velocity - other.velocity) + Math.abs(this.deltaD - other.deltaD);
        }

        public double getDiff(State other) {
            return Math.abs(this.velocity - other.velocity) + Math.abs(Utils.normalRelativeAngle((double)(this.direction - other.direction)));
        }

        public String toString() {
            return new String("D=" + Double.toString(Math.toDegrees(this.direction)) + ",V=" + Double.toString(this.velocity));
        }
    }
}

