/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import agd.util.TargetSelectionStrategy;
import robocode.RobotDeathEvent;

public class NearestTargetSelector
extends AdvancedRobotAdapter
implements TargetSelectionStrategy {
    RobotInformation ri;
    Enemy closest = null;
    static final int REMEMBER_TICKS = 20;

    public NearestTargetSelector(RobotInformation ri) {
        this.ri = ri;
        ri.addListener(this);
    }

    public Enemy getTarget() {
        return this.closest;
    }

    public void onEnemySighted(Enemy enemy) {
        if (this.closest == null) {
            this.closest = enemy;
        } else if (enemy != this.closest) {
            Coord ourPos = this.ri.getPosition();
            Coord newPos = enemy.getLastSighting().getTheirPosition();
            Coord closestPos = this.closest.getLastSighting().getTheirPosition();
            if (ourPos.distanceTo(newPos) / ourPos.distanceTo(closestPos) < 0.75 || this.ri.getAdvancedRobot().getTime() - this.closest.getLastSighting().getScannedRobotEvent().getTime() > 20L) {
                this.closest = enemy;
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent rde) {
        if (this.closest != null && rde.getName().equals(this.closest.getName())) {
            this.closest = null;
        }
    }

    static {
        REMEMBER_TICKS = 20;
    }
}

