/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.CircularGun;
import ahr.ice.Gun;
import ahr.ice.HeadOnGun;
import ahr.ice.InfinityGun;
import ahr.ice.LinearGun;
import ahr.ice.LinearIterativeGun;
import ahr.ice.Math.Enemy;
import ahr.ice.Math.PointEvaluator;
import ahr.ice.Math.math;
import ahr.ice.MeanCircularGun;
import ahr.ice.MeanIterativeGun;
import ahr.ice.Pilot.Movement;
import ahr.ice.RobotState;
import ahr.ice.SimpleGun;
import ahr.ice.VirtualGuns;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public abstract class AHRBot
extends AdvancedRobot {
    public static RobotState me;
    public static RobotState target;
    public static Vector guns;
    public static Vector virtualBullets;
    public static Rectangle2D.Double battlefield;
    public static int bestGun;
    public static Hashtable targets;
    public static final double radarLockFactor = 1.7;
    static double firepower;
    public static long mrTimeToNextSpot;
    public static long lastWallAvoidTime;
    public static long timeSinceScan;
    public static final Point2D.Double origin;
    public static Point2D.Double middle;
    public static Enemy lastAttacker;
    public boolean isRamming = false;
    public boolean isShooting = true;
    public Point2D.Double averagePosition = origin;
    public PointEvaluator PE = new PointEvaluator(this);
    public Movement movement;

    public abstract void run();

    public abstract void onScannedRobot(ScannedRobotEvent var1);

    public abstract void onStartUp();

    public abstract void onCustomEvent(CustomEvent var1);

    public abstract void onRoundEnded(RoundEndedEvent var1);

    public abstract void onRobotDeath(RobotDeathEvent var1);

    public void adjust() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
    }

    public Rectangle2D.Double getBattleField() {
        return new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }

    public Point2D.Double getMiddle() {
        return new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    public void onWin(WinEvent e) {
        while (true) {
            this.setTurnRadarRight(360.0);
            this.setTurnGunLeft(360.0);
            this.setTurnRight(360.0);
            this.setMaxVelocity(2.0);
            this.setAhead(10.0);
            this.execute();
        }
    }

    public void setColors() {
        this.setBodyColor(new Color(100, 224, 255));
        this.setRadarColor(new Color(200, 220, 255));
        this.setBulletColor(new Color(0, 143, 255));
        this.setScanColor(new Color(0, 143, 255));
        this.setGunColor(new Color(0, 134, 255));
    }

    public void onHitRobot(HitRobotEvent e) {
        try {
            Enemy en = AHRBot.setupEnemy(e.getName());
            en.danger += 50.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ram(RobotState who) {
        this.goTo(who.x, who.y);
        this.isRamming = true;
        VirtualGuns.holdFire();
        virtualBullets.clear();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        try {
            Enemy en = AHRBot.setupEnemy(e.getName());
            en.danger += 10.0 * e.getBullet().getPower();
            ++en.bulletHits;
            if (en.name.equals(AHRBot.lastAttacker.name)) {
                target = new RobotState();
                AHRBot.target.name = en.name;
                AHRBot.target.heading = en.heading;
                target.setLocation(en.x, en.y);
                AHRBot.target.velocity = en.speed;
            }
            lastAttacker = en;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (e.getEnergy() > 0.0) {
            Enemy en = AHRBot.setupEnemy(e.getName());
            en.danger /= 2.0;
        }
    }

    public Point2D.Double position() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public static void addGuns(AHRBot r) {
        guns = new Vector();
        LinearGun defaultGun = new LinearGun();
        defaultGun.hits = 1L;
        guns.add(defaultGun);
        guns.add(new HeadOnGun());
        guns.add(new CircularGun());
        guns.add(new InfinityGun());
        guns.add(new LinearIterativeGun());
        guns.add(new MeanCircularGun());
        guns.add(new MeanIterativeGun());
        guns.add(new SimpleGun());
    }

    public void doInfo(ScannedRobotEvent e, Enemy en) {
        this.doEInfo(e, en);
    }

    public Enemy doEInfo(ScannedRobotEvent e, Enemy en) {
        Point2D.Double coordinates;
        double eAbsBearing = this.getHeadingRadians() + e.getBearingRadians();
        double rX = this.getX();
        double rY = this.getY();
        double eX = rX + e.getDistance() * Math.sin(eAbsBearing);
        double eY = rY + e.getDistance() * Math.cos(eAbsBearing);
        en.name = e.getName();
        en.bearing = e.getBearingRadians();
        en.x = eX;
        en.y = eY;
        en.energy = e.getEnergy();
        en.coords = coordinates = new Point2D.Double(eX, eY);
        ++en.scans;
        en.headings += e.getHeadingRadians();
        en.velocities += e.getVelocity();
        en.meanHeadingChange = en.headings / (double)en.scans;
        en.meanVelocity = en.velocities / (double)en.scans;
        en.bearing = e.getBearingRadians();
        en.oldHeading = en.heading;
        en.heading = e.getHeadingRadians();
        en.ctime = this.getTime();
        en.speed = e.getVelocity();
        en.distance = e.getDistance();
        en.lastCoords = en.coords;
        en.live = true;
        targets.remove(e.getName());
        targets.put(e.getName(), en);
        return en;
    }

    public static Enemy setupEnemy(String name) {
        Enemy en;
        try {
            en = (Enemy)targets.get(name);
            en.name = name;
        }
        catch (Exception err) {
            en = new Enemy();
            targets.put(name, en);
        }
        return en;
    }

    public RobotState setupTarget(ScannedRobotEvent e) {
        RobotState t = new RobotState();
        t.setLocation(me.project(e.getBearingRadians() + this.getHeadingRadians(), e.getDistance()));
        t.heading = e.getHeadingRadians();
        t.velocity = e.getVelocity();
        t.name = e.getName();
        return t;
    }

    public void virtualGun() {
        VirtualGuns.moveBullets(battlefield);
        if (target != null) {
            VirtualGuns.gun();
        }
    }

    public void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(math.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(me.distance(new Point2D.Double(x, y)) * r);
    }

    public int turnTo(double angle) {
        int dir;
        double ang = math.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    public void adjustGunHits() {
        if (this.getRoundNum() % 5 == 0) {
            for (Gun gun : guns) {
                gun.hits /= 50L;
            }
        }
    }

    public Enemy bestTarget(Enemy en) {
        this.out.println("Yup, it's being used");
        Enemy targetEnemy = en;
        double bestTargetRating = 100000.0;
        Enumeration enu = targets.elements();
        while (enu.hasMoreElements()) {
            double targetRating = 0.0;
            Enemy enem = (Enemy)enu.nextElement();
            Enumeration i = targets.elements();
            while (i.hasMoreElements()) {
                Enemy j = (Enemy)i.nextElement();
                Point2D.Double jP = new Point2D.Double(j.x, j.y);
                targetRating -= jP.distance(enem.x, enem.y);
            }
            if (!((targetRating += me.distance(enem.x, enem.y)) < bestTargetRating) || enem.name == null || !enem.live) continue;
            targetEnemy = enem;
            bestTargetRating = targetRating;
        }
        return targetEnemy;
    }

    public void setFirepower(ScannedRobotEvent e) {
        double bestP = 1.5 + this.getEnergy() / 33.0 * (300.0 / e.getDistance());
        double pToKill = (e.getEnergy() + 2.0) / 6.0 + 0.1;
        firepower = Math.min(bestP, Math.min(this.getEnergy() - 0.1, Math.min(3.0, pToKill)));
    }

    public RobotState myState() {
        RobotState m = new RobotState();
        m.name = "me";
        m.velocity = this.getVelocity();
        m.heading = this.getHeadingRadians();
        m.x = this.getX();
        m.y = this.getY();
        m.gunHeading = this.getGunHeadingRadians();
        return m;
    }

    static {
        virtualBullets = new Vector();
        targets = new Hashtable();
        timeSinceScan = 0L;
        origin = new Point2D.Double(0.0, 0.0);
    }
}

