/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.DefaultPattern;
import TNT.Pattern;
import TNT.Recon;
import TNT.ReconCollection;
import TNT.StrafingPattern;
import TNT.TNT;
import java.util.Enumeration;

class PatternAnalyzer
implements Runnable {
    public static final Pattern DEFAULT = new DefaultPattern();
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{new StrafingPattern()};
    private static final long SLEEP_INTERVAL = 500L;
    public TNT m_owner = null;
    private Thread m_thread = null;
    private boolean shouldRun = false;

    public void startAnalyzer() {
        if (!this.shouldRun) {
            this.shouldRun = true;
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stopAnalyzer() {
        if (this.shouldRun) {
            try {
                this.shouldRun = false;
                this.m_thread.interrupt();
            }
            catch (SecurityException error) {
                TNT.debug("WARNING - Could Not Stop Pattern Analyzer, Security Exception");
            }
        }
    }

    public void run() {
        try {
            TNT.debug("Init Enemy Pattern Analysis System...");
            Enumeration allElements = null;
            ReconCollection current = null;
            Recon[] strand = null;
            int numberOfPatterns = ALL_PATTERNS.length;
            int counter = 0;
            boolean result = false;
            while (this.shouldRun) {
                Thread.sleep(500L);
                allElements = TNT.m_scannedInformation.elements();
                while (allElements.hasMoreElements()) {
                    current = (ReconCollection)allElements.nextElement();
                    strand = current.getLatestStrand();
                    if (strand == null) continue;
                    counter = numberOfPatterns - 1;
                    while (counter >= 0) {
                        result = ALL_PATTERNS[counter].test(strand);
                        if (result && ALL_PATTERNS[counter].getClass() != current.getPattern().getClass()) {
                            current.setPattern(ALL_PATTERNS[counter]);
                        } else if (!result && ALL_PATTERNS[counter].getClass() == current.getPattern().getClass() && current.getPattern() != DEFAULT) {
                            current.setPattern(DEFAULT);
                        }
                        --counter;
                    }
                }
            }
        }
        catch (InterruptedException error) {
            TNT.debug("Stopping Pattern Analyzer");
        }
    }

    public PatternAnalyzer(TNT in_owner) {
        this.m_owner = in_owner;
    }
}

