/*
 * Decompiled with CFR 0.152.
 */
package simonton.movements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import simonton.core.Bot;
import simonton.movements.Destination;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.Wave;

public class Path
implements Comparable {
    public List points = new ArrayList();
    public Collection pendingWaves = new LinkedList();
    public Collection unreachableWaves = new LinkedList();
    private double totalDanger;

    public Path(Bot bot, Collection pendingWaves) {
        this.points.add(new Destination(bot));
    }

    public Path(Path startPath, Destination additionalPoint) {
        this.points.addAll(startPath.points);
        this.points.add(additionalPoint);
        this.totalDanger = startPath.totalDanger;
        this.addDanger(additionalPoint.safety.wave, additionalPoint);
        this.unreachableWaves.addAll(startPath.unreachableWaves);
    }

    public boolean canAdvance(Collection flyingWaves) {
        for (Wave wave : flyingWaves) {
            if (this.alreadyCrossed(wave)) continue;
            return true;
        }
        return false;
    }

    public Wave getNextWave(Collection flyingWaves) {
        Wave nextWave = null;
        Destination lastPoint = (Destination)this.points.get(this.points.size() - 1);
        int nextTimeToImpact = Integer.MAX_VALUE;
        for (Wave wave : flyingWaves) {
            int timeToImpact;
            if (this.alreadyCrossed(wave) || (timeToImpact = wave.impactTime(lastPoint)) >= nextTimeToImpact) continue;
            nextTimeToImpact = timeToImpact;
            nextWave = wave;
        }
        return nextWave;
    }

    private boolean alreadyCrossed(Wave wave) {
        for (Destination point : this.points) {
            if (point.safety == null || point.safety.wave != wave) continue;
            return true;
        }
        for (Wave crossedWave : this.unreachableWaves) {
            if (crossedWave != wave) continue;
            return true;
        }
        return false;
    }

    public void addDanger(Wave wave, Location crashLoc) {
        this.totalDanger += wave.getProbability(crashLoc);
    }

    public void addDanger(Destination destination) {
        this.totalDanger += destination.safety.getProbability(destination.distFromWave);
    }

    public Destination getFirstDestination() {
        if (this.points.size() == 1) {
            return (Destination)this.points.get(0);
        }
        return (Destination)this.points.get(1);
    }

    public Destination getLastDestination() {
        return (Destination)this.points.get(this.points.size() - 1);
    }

    public int compareTo(Path p) {
        int compare = (int)Math.signum(this.totalDanger - p.totalDanger);
        int i = 1;
        while (compare == 0 && i < this.points.size() && i < p.points.size()) {
            compare = (int)Math.signum(FastMath.abs(((Destination)this.points.get((int)i)).safety.gf) - FastMath.abs(((Destination)p.points.get((int)i)).safety.gf));
            ++i;
        }
        return compare;
    }

    public void onPaint(Graphics2D g, long time) {
        if (this.points.size() < 2) {
            return;
        }
        int i = 1;
        while (i < this.points.size()) {
            g.setColor(Color.GREEN);
            Util.paintLine(g, (Point2D.Double)this.points.get(i - 1), (Point2D.Double)this.points.get(i));
            ((Destination)this.points.get(i)).onPaint(g, time);
            ++i;
        }
    }

    public int compareTo(Object obj) {
        return this.compareTo((Path)obj);
    }
}

