/*
 * Decompiled with CFR 0.152.
 */
package ender;

import ender.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class WaveManager {
    private static WaveManager _instance = null;
    private ArrayList<Wave> mWaves = new ArrayList();

    public static WaveManager instance() {
        if (_instance == null) {
            _instance = new WaveManager();
        }
        return _instance;
    }

    public void onPaint(Graphics2D graphics) {
        graphics.setColor(Color.MAGENTA);
        for (Wave w : this.mWaves) {
            Point2D.Double center = w.getCenter();
            graphics.drawOval((int)(center.x - w.getDistance()), (int)(center.y - w.getDistance()), (int)(w.getDistance() * 2.0), (int)(w.getDistance() * 2.0));
        }
    }

    public boolean isEmpty() {
        return this.mWaves.size() == 0;
    }

    public void pushWave(Point2D.Double location, double speed, long time) {
        Wave wave = new Wave(location, speed, time);
        this.mWaves.add(wave);
    }

    public void update(Point2D.Double location, double heading, double velocity, long time) {
        int i = 0;
        while (i < this.mWaves.size()) {
            Wave w = this.mWaves.get(i);
            w.update();
            if (w.getDistance() - 20.0 > location.distance(w.getCenter())) {
                this.mWaves.remove(w);
                --i;
            }
            ++i;
        }
    }

    public Wave getQuickestWave(Point2D.Double location) {
        double min = Double.POSITIVE_INFINITY;
        Wave w = null;
        for (Wave wave : this.mWaves) {
            if (!(wave.getCenter().distance(location) < min)) continue;
            min = wave.getCenter().distance(location);
            w = wave;
        }
        return w;
    }

    public Wave getHit(Point2D.Double position, double speed) {
        for (Wave wave : this.mWaves) {
            if (!(wave.getDistance() - position.distance(wave.getCenter()) < 30.0) || !(wave.getSpeed() - speed < 1.0)) continue;
            return wave;
        }
        return null;
    }

    public void remove(Wave wave) {
        this.mWaves.remove(wave);
    }
}

