/*
 * Decompiled with CFR 0.152.
 */
package syl.movement;

import syl.core.BaseRobot;
import syl.core.Component;
import syl.movement.EvasiveGravityMovementStrategy;
import syl.movement.GravityMovementStrategy;
import syl.movement.MovementStrategy;
import syl.movement.WaypointGravityMovementStrategy;

public class MovementStrategyManager
implements Component {
    private BaseRobot robot;
    private MovementStrategy gravityMovementStrategy;
    private MovementStrategy evasiveMovement;
    private MovementStrategy waypointGravMovement;

    public MovementStrategyManager(BaseRobot robot) {
        this.robot = robot;
        this.gravityMovementStrategy = new GravityMovementStrategy(robot);
        this.evasiveMovement = new EvasiveGravityMovementStrategy(robot);
        this.waypointGravMovement = new WaypointGravityMovementStrategy(robot);
    }

    public void initialize() {
        this.gravityMovementStrategy.initialize();
        this.evasiveMovement.initialize();
        this.waypointGravMovement.initialize();
    }

    public void cleanUp() {
        this.gravityMovementStrategy.cleanUp();
        this.evasiveMovement.cleanUp();
        this.waypointGravMovement.cleanUp();
    }

    public MovementStrategy getMovementStrategy() {
        return this.gravityMovementStrategy;
    }
}

