/*
 * Decompiled with CFR 0.152.
 */
package grav;

import grav.GravPoint;
import grav.GravityCollection;
import grav.WaveLine;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import math.Vect2d;
import sim.Bot;
import sim.Data;
import sim.EnemyWave;
import sim.Wave;
import sim.WaveLookup;

public class GravRobot
extends GravityCollection {
    private Bot _robot;
    private GravPoint _robotPoint;
    private HashMap<EnemyWave, WaveLine> _waves;
    private final double _pointStrength = 2500.0;

    public GravRobot(Bot robot) {
        this._robot = robot;
        this._robotPoint = new GravPoint(2500.0, 1.0, new Point2D.Double());
        this._waves = new HashMap();
        this.Add(this._robotPoint);
    }

    @Override
    public Vect2d GetEffectiveGravity(long time) {
        if (!this._robot.Alive) {
            this.Remove(this._robotPoint);
        } else {
            Object line;
            this._robotPoint.Location.setLocation(this._robot.Position);
            WaveLookup<EnemyWave> enemyWaves = Data.EnemyWaves.byBotName(this._robot);
            for (EnemyWave enemyWave : enemyWaves) {
                if (this._waves.containsKey(enemyWave)) continue;
                Vect2d initialDelta = enemyWave.bearing.copy();
                initialDelta.setMagnitude(Data.Battle.MaxDistance);
                line = initialDelta.projectLine(enemyWave.center);
                WaveLine gravLine = new WaveLine((Line2D.Double)line, 500.0, 1.5, enemyWave.bearing);
                this._waves.put(enemyWave, gravLine);
                this.Add(gravLine);
            }
            ArrayList<EnemyWave> removableWaves = new ArrayList<EnemyWave>();
            for (EnemyWave wave : this._waves.keySet()) {
                if (!enemyWaves.contains(wave) || wave.status == Wave.WaveKind.Neutralized) {
                    removableWaves.add(wave);
                    this.Remove(this._waves.get(wave));
                    continue;
                }
                line = this._waves.get(wave);
                ((WaveLine)line).Delta.moveLine(((WaveLine)line).Line);
            }
            for (EnemyWave wave : removableWaves) {
                this._waves.remove(wave);
            }
            int n = Data.Robots.Enemies().size();
            this._robotPoint.DropoffFactor = 1.0 + 0.1 * (double)n;
            if (!this._robot.IsThreat()) {
                this._robotPoint.Strength = -2500.0;
                this._robotPoint.DropoffFactor = 0.0;
            }
        }
        return super.GetEffectiveGravity(time);
    }
}

