/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Queue;
import pedersen.core.Combatant;
import pedersen.core.Controller;
import pedersen.core.EventProcessor;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.core.RateControlRobot1716;
import pedersen.core.Teammate;
import pedersen.debug.Metrics;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.BulletBank;
import pedersen.divination.WaveOutboundImpl;
import pedersen.movement.MovementMethod;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.Firepower;
import pedersen.physics.SnapshotImpl;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.FireControl;
import pedersen.systems.ScannerSubsystem;
import pedersen.systems.TurretSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.targeting.TargetingMethod;
import pedersen.util.Arena;
import pedersen.util.Conversions;
import pedersen.util.ExceptionHandler;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public abstract class Foundation
extends RateControlRobot1716 {
    private static Foundation singleton;
    private final Color chassis;
    private final Color turret;
    private final Color radar;
    private StatusEvent eventStatus = null;
    private WinEvent eventWin = null;
    private DeathEvent eventDeath = null;
    private Queue<BulletHitBulletEvent> queueBulletHitBullet = new LinkedList<BulletHitBulletEvent>();
    private Queue<BulletMissedEvent> queueBulletMissed = new LinkedList<BulletMissedEvent>();
    private Queue<ScannedRobotEvent> queueScannedRobot = new LinkedList<ScannedRobotEvent>();
    private Queue<SkippedTurnEvent> queueSkippedTurn = new LinkedList<SkippedTurnEvent>();
    private Queue<HitByBulletEvent> queueHitByBullet = new LinkedList<HitByBulletEvent>();
    private Queue<RobotDeathEvent> queueRobotDeath = new LinkedList<RobotDeathEvent>();
    private Queue<BulletHitEvent> queueBulletHit = new LinkedList<BulletHitEvent>();
    private Queue<HitRobotEvent> queueHitRobot = new LinkedList<HitRobotEvent>();
    private Queue<HitWallEvent> queueHitWall = new LinkedList<HitWallEvent>();
    private Queue<MessageEvent> queueMessage = new LinkedList<MessageEvent>();

    protected Foundation(Color newChassis, Color newTurret, Color newRadar) {
        this.chassis = newChassis;
        this.turret = newTurret;
        this.radar = newRadar;
        singleton = this;
        Combatant.getCombatant();
        TurretSubsystem.getInstance();
        ScannerSubsystem.getInstance();
        TargetBank.getInstance();
        Teammate.commonTrim(0.0);
    }

    public static Foundation getInstance() {
        return singleton;
    }

    public void run() {
        super.setColors(this.chassis, this.turret, this.radar);
        Controller.getInstance().roundSetup();
        while (true) {
            try {
                while (true) {
                    GraphicalDebugger.turnTeardown();
                    this.processAllEvents();
                    NotificationSubsystem.getInstance().publishTurn(GameState.getInstance().getTurn());
                    Controller.getInstance().processTurn();
                    this.applyInstructions();
                    super.execute();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
                continue;
            }
            break;
        }
    }

    public abstract Queue<MovementMethod> getMovementMethods();

    public abstract Queue<MovementMethod> getMovementMethods(int var1);

    public abstract Iterable<TargetingMethod> getOutboundTargetingMethods(Target var1);

    public abstract Iterable<TargetingMethod> getInboundTargetingMethods(Target var1);

    public abstract FireControl getFireControl();

    private void processAllEvents() {
        if (this.eventStatus != null) {
            this.process(this.eventStatus, super.getRoundNum(), super.getTime(), super.getOthers());
            this.eventStatus = null;
        }
        while (!this.queueSkippedTurn.isEmpty()) {
            EventProcessor.process(this.queueSkippedTurn.remove());
        }
        while (!this.queueBulletMissed.isEmpty()) {
            EventProcessor.process(this.queueBulletMissed.remove());
        }
        while (!this.queueBulletHitBullet.isEmpty()) {
            EventProcessor.process(this.queueBulletHitBullet.remove());
        }
        while (!this.queueBulletHit.isEmpty()) {
            EventProcessor.process(this.queueBulletHit.remove());
        }
        while (!this.queueHitByBullet.isEmpty()) {
            EventProcessor.process(this.queueHitByBullet.remove());
        }
        while (!this.queueHitWall.isEmpty()) {
            EventProcessor.process(this.queueHitWall.remove());
        }
        while (!this.queueHitRobot.isEmpty()) {
            EventProcessor.process(this.queueHitRobot.remove());
        }
        while (!this.queueRobotDeath.isEmpty()) {
            EventProcessor.process(this.queueRobotDeath.remove());
        }
        while (!this.queueScannedRobot.isEmpty()) {
            EventProcessor.process(this.queueScannedRobot.remove());
        }
        while (!this.queueMessage.isEmpty()) {
            CommunicationSubsystem.getInstance().process(this.queueMessage.remove());
        }
        CommunicationSubsystem.getInstance().processTeamMessages();
        if (this.eventWin != null) {
            EventProcessor.process(this.eventWin);
            this.eventWin = null;
        }
        if (this.eventDeath != null) {
            EventProcessor.process(this.eventDeath);
            this.eventDeath = null;
        }
    }

    public void onStatus(StatusEvent event) {
        this.eventStatus = event;
    }

    public void onWin(WinEvent event) {
        this.eventWin = event;
    }

    public void onDeath(DeathEvent event) {
        this.eventDeath = event;
    }

    public void onBattleEnded(BattleEndedEvent event) {
        EventProcessor.process(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.queueBulletHitBullet.add(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.queueBulletMissed.add(event);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.queueScannedRobot.add(event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.queueSkippedTurn.add(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.queueHitByBullet.add(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.queueRobotDeath.add(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.queueBulletHit.add(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.queueHitRobot.add(event);
    }

    public void onHitWall(HitWallEvent event) {
        this.queueHitWall.add(event);
    }

    public void onMessageReceived(MessageEvent event) {
        this.queueMessage.add(event);
    }

    public void onPaint(Graphics2D console) {
        Controller.getInstance().onPaint(console);
    }

    public void onKeyTyped(KeyEvent e) {
        EventProcessor.process(e);
    }

    private void process(StatusEvent event, int roundNum, long time, int others) {
        RobotStatus status = event.getStatus();
        GameState state = GameState.getInstance();
        state.setSnapshot(new SnapshotImpl(roundNum, time, status.getX(), status.getY(), status.getHeadingRadians(), status.getVelocity(), status.getEnergy()));
        state.setActiveEnemyCount(others);
        state.setGunHeat(status.getGunHeat());
        state.setScannerFacing(status.getRadarHeadingRadians());
        state.setTurretFacing(status.getGunHeadingRadians());
        Instructions.getInstance().refresh();
        if (state.isFirstRound() && state.isFirstTurn()) {
            state.setName(super.getName());
            state.setRounds(super.getNumRounds());
            state.setGunCoolingRate(super.getGunCoolingRate());
            Arena.singleton = new Arena(super.getBattleFieldWidth(), super.getBattleFieldHeight());
            state.nextPersistentRandom();
        }
        if (state.isFirstTurn()) {
            NotificationSubsystem.getInstance().publishRound(roundNum);
        }
        Combatant.getCombatant().update(GameState.getInstance().getSnapshot());
    }

    public void applyInstructions() {
        Instructions instructions = Instructions.getInstance();
        WaveOutboundImpl outboundWave = instructions.getOutboundWave();
        if (instructions.isShotFired() && GameState.getInstance().isGunCool() && outboundWave.getPosition().equalsPosition(GameState.getInstance().getChassis())) {
            Firepower firepower = Conversions.getFirepowerFromBulletVelocity(outboundWave);
            Bullet bullet = super.setFireBullet(firepower.firepower());
            BulletBank.getInstance().add(bullet, outboundWave);
            Metrics.getInstance().shotFired(firepower);
            GameState.getInstance().nextPersistentRandom();
        }
        super.setTurnRateRadians(instructions.getChassisHeadingChange());
        super.setGunRotationRateRadians(instructions.getTurretHeadingChange());
        super.setRadarRotationRateRadians(instructions.getScannerHeadingChange());
        super.setVelocityRate(instructions.getDesiredVelocity());
        Metrics.getInstance().addSpeed(super.getVelocityRate());
    }

    public String[] getTeammates() {
        return null;
    }

    public void sendMessage(String name, Serializable message) throws IOException {
    }
}

