/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.HashSet;
import java.util.Map;
import pedersen.core.Combatant;
import pedersen.core.Competitor;
import pedersen.divination.BaseCombatWave;
import pedersen.divination.CombatWaveBank;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.opponent.Target;
import pedersen.physics.HasWave;
import pedersen.physics.Snapshot;
import pedersen.targeting.TargetingMethod;

public class WaveInboundImpl
extends BaseCombatWave {
    public WaveInboundImpl(HasWave wave, Target target) {
        super(wave);
        Snapshot defender = Combatant.getCombatant().getHistoricalSnapshot(2L);
        Snapshot agressor = target.getSnapshot();
        TargetAnalysis targetAnalysis = new TargetAnalysis(this, agressor, defender);
        this.targetAnalyses.put(target, targetAnalysis);
        HashSet<FiringSolution> firingSolutions = new HashSet<FiringSolution>(target.getDefensiveGunCount());
        for (TargetingMethod targetingMethod : target.getOffensiveTargetingMethods()) {
            FiringSolution firingSolution = targetingMethod.getFiringSolution(this, targetAnalysis);
            if (firingSolution == null) continue;
            firingSolutions.add(firingSolution);
        }
        this.addFiringSolutions(target, firingSolutions);
        this.enablePainting();
        CombatWaveBank.getInstance().add(this);
    }

    public Competitor getVictim() {
        return Combatant.getCombatant();
    }

    @Override
    protected void recordWave() {
        for (Map.Entry e : this.targetAnalyses.entrySet()) {
            ((Target)e.getKey()).recordOffensiveWave(this, (TargetAnalysis)e.getValue());
        }
    }

    @Override
    public boolean isWaveUseful() {
        Snapshot p = Combatant.getCombatant().getSnapshot();
        return !super.isWavePastTarget(p);
    }
}

