/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pedersen.core.Teammate;
import pedersen.debug.Debuggable;
import pedersen.debug.DebuggableBase;
import pedersen.debug.Metrics;
import pedersen.opponent.Target;
import pedersen.opponent.TargetFactory;
import pedersen.physics.HasPosition;
import pedersen.util.Conversions;

public class TargetBank
extends DebuggableBase {
    private static final TargetBank singleton = new TargetBank();
    private final Map<String, Target> map = new HashMap<String, Target>();

    private TargetBank() {
    }

    public static TargetBank getInstance() {
        return singleton;
    }

    public Target findByName(String name) {
        return this.map.get(name);
    }

    public Target findOrCreateByName(String name) {
        Target vaultEntry = this.findByName(name);
        if (vaultEntry == null && Teammate.findByName(name) == null) {
            this.map.put(name, TargetFactory.singleton.produce(name));
            Metrics.getInstance().incrementTargetCount();
        }
        return vaultEntry;
    }

    public Target findByPosition(HasPosition position) {
        Target target = null;
        for (Target e : this.map.values()) {
            if (!position.getPosition().equalsPosition(e.getSnapshot())) continue;
            target = e;
            break;
        }
        return target;
    }

    public Set<Target> getActiveTargets() {
        HashSet<Target> targets = new HashSet<Target>();
        for (Target e : this.map.values()) {
            if (e == null || !e.isActive()) continue;
            targets.add(e);
        }
        return targets;
    }

    public void detectShotFired() {
        for (Target e : this.map.values()) {
            e.detectShotFired();
        }
    }

    public void onRobotHitByCombatant(String name, double firepower) {
        Target target = this.findByName(name);
        if (target != null) {
            target.getEnergyTracker().receiveBulletDamage(Conversions.getBulletDamageFromFirepower(firepower));
        }
    }

    public void onCombatantHitByRobot(String name, double firepower) {
        Target target = this.findByName(name);
        if (target != null) {
            target.getEnergyTracker().dealBulletDamage(firepower);
        }
    }

    public void onRobotCollision(String name) {
        Target target = this.findByName(name);
        if (target != null) {
            target.getEnergyTracker().receiveRamDamage(0.6);
        }
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName()).append(": ");
        buffer.append(this.map.size()).append(" entries, ").append(Metrics.getInstance().getTargetCount()).append(" processed.").append("\n");
        for (Debuggable debuggable : this.map.values()) {
            buffer.append(debuggable.description()).append("\n");
        }
        return buffer.toString();
    }
}

