/*
 * Decompiled with CFR 0.152.
 */
package jbot.engines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbot.Rabbit2;
import jbot.engines.Engine;
import jbot.tracer.Ray;
import jbot.tracer.Tracer;
import jbot.tracer.Wave;
import jbot.tracer.techniques.SegmentedAngleTechnique;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class MainEngine
extends Engine {
    Vector2 mWallsForce = new Vector2();
    Vector2 mWavesForce = new Vector2();
    Vector2 mBestDistForce = new Vector2();
    Vector2 mSpinForce = new Vector2();
    Vector2 mForce = new Vector2();
    double mBestDistance = 300.0;
    Profile mProfile = Profile.NEUTRAL;
    public boolean mAvoiding = true;
    static final double DANGER_SMOOTH = 4.0;
    static final double WALLS_FORCE_FACTOR = 0.6;
    static final double WAVES_FORCE_FACTOR = 0.4;
    static final double BEST_DISTANCE_FORCE_FACTOR = 0.8;
    static final double SPIN_FORCE_FACTOR = 0.0;
    static final double MIN_FORCE_VALUE = 0.001;
    int randomCounter = 0;
    boolean triger = false;
    Vector2 escPos;
    Vector2 maxVelEscAngleAtShoot;
    Vector2 minVelEscAngleAtShoot;
    Vector2 maxVelEscAngleNow;
    Vector2 minVelEscAngleNow;
    Wave lastDangerWave;
    List<Double> rayAnglesList = new ArrayList<Double>();
    List<Double> rayDangersList = new ArrayList<Double>();
    Wave dangerWave;

    public MainEngine(Rabbit2 bot) {
        super(bot);
    }

    protected void frameLogic(double deltaTime) {
        if (this.mRandom.nextInt(10) % 10 == 0) {
            int newProfileIndex = this.mRandom.nextInt(Profile.values().length);
            this.mProfile = Profile.values()[newProfileIndex];
        }
        this.updateWallsForce();
        this.updateWavesForce();
        this.updateBestDistanceForce();
        this.mWallsForce.multiply(0.6);
        this.mWavesForce.multiply(0.4);
        this.mBestDistForce.multiply(0.8);
        this.mSpinForce.multiply(0.0);
        this.mForce.setXY(0.0, 0.0);
        this.mForce.add(this.mWallsForce.clone());
        this.mForce.add(this.mWavesForce.clone());
        this.mForce.add(this.mBestDistForce.clone());
        double angle = 0.0;
        double ahead_dir = 0.0;
        if (this.mForce.getLength() < 0.001) {
            Vector2 dir = this.mTarget.getRelativePos().normalize();
            dir.rotateByHalfPiRight();
            angle = this.mBot.getDirection().getAngleTo(dir);
            ahead_dir = 0.0;
            if (Math.abs(angle) > 1.5707963267948966) {
                angle -= Math.PI;
                angle = Utils.normalRelativeAngle((double)angle);
            }
        } else {
            angle = this.mBot.getDirection().getAngleTo(this.mForce);
            ahead_dir = 1.0;
            if (Math.abs(angle) > 1.5707963267948966) {
                ahead_dir = -1.0;
                angle -= Math.PI;
                angle = Utils.normalRelativeAngle((double)angle);
            }
            if (angle > 0.3490658503988659) {
                this.mBot.setMaxVelocity(4.0);
            } else if (angle > 0.17453292519943295) {
                this.mBot.setMaxVelocity(6.0);
            } else {
                this.mBot.setMaxVelocity(8.0);
            }
        }
        this.mAhead = 200.0 * ahead_dir;
        this.mTurnBearing = angle;
    }

    void updateWallsForce() {
        Vector2 p = this.mBot.getPosition();
        double x_factor = 1.0 - 2.0 * p.getX() / this.mBot.getBattleFieldWidth();
        x_factor = Math.pow(Math.abs(x_factor), 3.0) * (double)MathUtil.sign(x_factor);
        double y_factor = 1.0 - 2.0 * p.getY() / this.mBot.getBattleFieldHeight();
        y_factor = Math.pow(Math.abs(y_factor), 3.0) * (double)MathUtil.sign(y_factor);
        this.mWallsForce.setXY(x_factor, y_factor);
    }

    int calcTravelTime(double vel, double dist) {
        int time = 0;
        double traveled = 0.0;
        while (traveled < dist) {
            ++time;
            traveled += vel;
            if (vel < 0.0) {
                vel += 2.0;
                continue;
            }
            if (!(vel < 8.0)) continue;
            vel += 1.0;
        }
        return time;
    }

    boolean isPointOnField(Vector2 point, double border) {
        if (point.getX() < border || point.getY() < border) {
            return false;
        }
        return !(point.getX() > this.mBot.getBattleFieldWidth() - border) && !(point.getY() > this.mBot.getBattleFieldHeight() - border);
    }

    double calcTravelDistFor(double vel, double dstVel, double time) {
        double curTime = 0.0;
        double traveled = 0.0;
        while (curTime < time) {
            curTime += 1.0;
            traveled += vel;
            if (vel >= 0.0) {
                if (vel < dstVel) {
                    vel += 1.0;
                    continue;
                }
                vel -= 2.0;
                continue;
            }
            if (vel > dstVel) {
                vel -= 1.0;
                continue;
            }
            vel += 2.0;
        }
        return traveled;
    }

    void updateWavesForce() {
        this.mWavesForce = new Vector2();
        for (Wave w : this.mTarget.mWavesList) {
            double distance;
            if (!w.isRealBullet() || (distance = w.getDistanceTo(this.mBot.getPosition(), this.mBot.getTime())) < 0.0) continue;
            Vector2 direction = this.mBot.getPosition().sub(w.getShotPos()).normalize();
            Vector2 wavePos = w.getShotPos().add(direction.clone().multiply(w.getTraveledDistance()));
            if (!w.equals(this.lastDangerWave)) {
                this.lastDangerWave = w;
                Vector2 dir = direction.clone();
                dir.rotateByHalfPiRight();
                if (dir.dot(this.mBot.getDirection()) < 0.0) {
                    dir.invert();
                }
                this.maxVelEscAngleAtShoot = new Vector2(Tracer.getMaxKeepDirAngle(w.getShotPos(), this.mSelf, w.getPower()));
                this.minVelEscAngleAtShoot = new Vector2(Tracer.getMaxReverseDirAngle(w.getShotPos(), this.mSelf, w.getPower()));
                double deltaAngle = this.minVelEscAngleAtShoot.getAngleTo(this.maxVelEscAngleAtShoot) / 11.0;
                double angleRange = Math.abs(this.minVelEscAngleAtShoot.getAngleTo(this.maxVelEscAngleAtShoot));
                double clearShootAngle = Tracer.getClearShootAngle(w.getDistToTarget());
                double clearShootRange = clearShootAngle / angleRange * 10.0;
                this.maxVelEscAngleNow = new Vector2(Tracer.getMaxKeepDirAngle(wavePos, this.mSelf, w.getPower()));
                this.minVelEscAngleNow = new Vector2(Tracer.getMaxReverseDirAngle(wavePos, this.mSelf, w.getPower()));
                Vector2 center = this.maxVelEscAngleNow.clone().add(this.minVelEscAngleNow).normalize();
                double adif = center.getAngleTo(this.maxVelEscAngleNow) * (distance / w.getDistToTarget());
                this.maxVelEscAngleNow = center.clone().rotate(adif);
                adif = center.getAngleTo(this.minVelEscAngleNow) * (distance / w.getDistToTarget());
                this.minVelEscAngleNow = center.clone().rotate(adif);
                double f = Math.abs(this.maxVelEscAngleNow.getAngleTo(this.minVelEscAngleAtShoot));
                int maxEscAngleIndex = SegmentedAngleTechnique.factorToIndex(f /= angleRange);
                f = Math.abs(this.minVelEscAngleNow.getAngleTo(this.minVelEscAngleAtShoot));
                int minEscAngleIndex = SegmentedAngleTechnique.factorToIndex(f /= angleRange);
                this.rayAnglesList = new ArrayList<Double>();
                this.rayDangersList = new ArrayList<Double>();
                this.dangerWave = w;
                float[] factorCounts = this.mTracer.mTargetsSegmentedAngleTechnique.getRecentFactorCountsVector();
                double factorSum = this.mTracer.mTargetsSegmentedAngleTechnique.getRecentFactorSum();
                int i = 0;
                while (i < 11) {
                    factorCounts[i] = factorCounts[i] / ((float)factorSum + 1.0f);
                    ++i;
                }
                double[] dangers = this.createDangersForProfile(this.mProfile, 0.001);
                Vector2 angle = this.minVelEscAngleAtShoot.clone();
                double indices = 10.0;
                int l = 0;
                while (l < 11) {
                    double danger = 0.0;
                    for (Ray r : w.mRaysList) {
                        TracerTechnique t = r.getTechnique();
                        double error = Math.abs(angle.getAngleTo(r.getDirection()));
                        if ((error *= angleRange / (clearShootAngle * 4.0)) > 1.0) {
                            error = 1.0;
                        }
                        double rayDanger = this.mTracer.getTargetTechniquesRealHits() == 0 ? 0.0 : (double)t.getRealHits() / (double)this.mTracer.getTargetTechniquesRealHits();
                        if (!this.mAvoiding) {
                            rayDanger = -rayDanger;
                        }
                        danger += rayDanger * (1.0 - error);
                        rayDanger = r.getHitProbability();
                        if (!this.mAvoiding) {
                            rayDanger = -rayDanger;
                        }
                        danger += rayDanger * 0.5 * (1.0 - error);
                    }
                    int n = l++;
                    dangers[n] = dangers[n] + danger;
                    angle.rotate(deltaAngle);
                }
                double dangersSum = 0.0;
                int l2 = 0;
                while (l2 < 11) {
                    dangersSum += dangers[l2];
                    ++l2;
                }
                l2 = 0;
                while (l2 < 11) {
                    int n = l2++;
                    dangers[n] = dangers[n] / Math.abs(dangersSum);
                }
                if (maxEscAngleIndex < minEscAngleIndex) {
                    int swap = minEscAngleIndex;
                    minEscAngleIndex = maxEscAngleIndex;
                    maxEscAngleIndex = swap;
                    deltaAngle *= -1.0;
                    if (minEscAngleIndex < 0) {
                        minEscAngleIndex = 0;
                    }
                    if (maxEscAngleIndex >= 10) {
                        maxEscAngleIndex = 10;
                    }
                }
                angle = this.minVelEscAngleAtShoot.clone();
                double minDanger = 10000.0;
                Vector2 bestEscAngle = this.maxVelEscAngleNow.clone();
                int l3 = 0;
                while (l3 < 11) {
                    if (l3 >= minEscAngleIndex && l3 <= maxEscAngleIndex && dangers[l3] <= minDanger) {
                        minDanger = dangers[l3];
                        bestEscAngle = angle.clone();
                    }
                    this.rayAnglesList.add(angle.getAngle());
                    this.rayDangersList.add(dangers[l3]);
                    angle.rotate(deltaAngle);
                    ++l3;
                }
                this.escPos = bestEscAngle.clone();
                this.escPos.multiply(w.getTraveledDistance() + w.getDistanceTo(this.mBot.getPosition(), this.mBot.getTime()));
                this.escPos.add(w.getShotPos());
            }
            if (this.escPos != null) {
                Vector2 dirToEscPos = this.escPos.clone().sub(w.getShotPos());
                if (direction.getAngleTo(dirToEscPos) > 0.0) {
                    direction.rotateByHalfPiRight();
                } else {
                    direction.rotateByHalfPiLeft();
                }
            }
            this.mWavesForce = direction.clone();
            break;
        }
    }

    void updateBestDistanceForce() {
        this.mBestDistance = 300.0;
        Vector2 dirToTarget = this.mTarget.getPosition().sub(this.mBot.getPosition());
        double distToTarget = dirToTarget.getLength();
        dirToTarget.normalize();
        double deltaDist = distToTarget - this.mBestDistance;
        this.mBestDistForce = dirToTarget.clone();
        this.mBestDistForce.setLength(Math.pow(Math.abs(deltaDist / this.mBestDistance), 1.5) * (double)MathUtil.sign(deltaDist));
    }

    void updateSpinForce() {
        double dist_diff = this.mTarget.getRelativePos().getLength() - this.mBestDistance;
        Vector2 direction = this.mBot.getPosition().sub(this.mTarget.getPosition()).normalize();
        direction.rotateByHalfPiRight();
        direction.setLength(1.0 - dist_diff / this.mBestDistance);
        this.mSpinForce = direction.clone();
    }

    protected double[] createDangersForProfile(Profile profile, double scale) {
        double[] dangers = new double[11];
        int range = 11;
        int halfRange = 5;
        switch (profile) {
            case NEUTRAL: {
                int i = 0;
                while (i < range) {
                    dangers[i] = 0.0;
                    ++i;
                }
                break;
            }
            case STATIC: {
                int i = 0;
                while (i < range) {
                    dangers[i] = scale * 2.0 * (double)Math.abs(i - halfRange) / (double)(range - 1);
                    ++i;
                }
                break;
            }
            case DYNAMIC: {
                int i = 0;
                while (i < range) {
                    dangers[i] = scale * (1.0 - 2.0 * (double)Math.abs(i - halfRange) / (double)(range - 1));
                    ++i;
                }
                break;
            }
            case KEEPING: {
                int i = 0;
                while (i < range) {
                    dangers[i] = scale * (1.0 - (double)i / (double)(range - 1));
                    ++i;
                }
                break;
            }
        }
        return dangers;
    }

    public void onHitByBullet(HitByBulletEvent evt) {
    }

    public void onPaint(Graphics2D g) {
        if (this.lastDangerWave == null) {
            return;
        }
        if (this.escPos != null) {
            g.setColor(Color.GREEN);
            g.drawOval((int)(this.escPos.getX() - 20.0), (int)(this.escPos.getY() - 20.0), 40, 40);
        }
        if (this.lastDangerWave != null) {
            ListIterator<Double> ai = this.rayAnglesList.listIterator(0);
            ListIterator<Double> di = this.rayDangersList.listIterator(0);
            while (ai.hasNext() && di.hasNext()) {
                double angle = ai.next();
                double danger = di.next();
                Vector2 pos = new Vector2(angle);
                pos.multiply(this.lastDangerWave.getTraveledDistance()).add(this.lastDangerWave.getShotPos());
                double size = Math.abs(danger) * 80.0;
                if (size < 3.0) {
                    size = 3.0;
                }
                g.setColor(new Color(255, 255, 0, 120));
                g.setBackground(Color.YELLOW);
                g.fillOval((int)(pos.getX() - size / 2.0), (int)(pos.getY() - size / 2.0), (int)size, (int)size);
            }
        }
        g.setColor(Color.RED);
        Vector2 v = this.mWallsForce.clone().multiply(200.0).add(this.mBot.getPosition());
        g.drawLine((int)this.mBot.getPosition().getX(), (int)this.mBot.getPosition().getY(), (int)v.getX(), (int)v.getY());
        Vector2 botPos = this.mBot.getPosition();
        g.setColor(Color.white);
        v = this.mWavesForce.clone().multiply(200.0).add(botPos);
        g.drawLine((int)botPos.getX(), (int)botPos.getY(), (int)v.getX(), (int)v.getY());
        g.setColor(Color.WHITE);
        v = this.mBestDistForce.clone().multiply(200.0).add(this.mBot.getPosition());
        g.drawLine((int)this.mBot.getPosition().getX(), (int)this.mBot.getPosition().getY(), (int)v.getX(), (int)v.getY());
        g.setColor(Color.WHITE);
        v = this.mForce.clone().multiply(200.0).add(this.mBot.getPosition());
        g.drawLine((int)this.mBot.getPosition().getX(), (int)this.mBot.getPosition().getY(), (int)v.getX(), (int)v.getY());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Profile {
        NEUTRAL,
        STATIC,
        DYNAMIC,
        KEEPING;

    }
}

