/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.misc.Host;
import pedersen.misc.Metrics;
import pedersen.opponent.Target;
import pedersen.physics.StaticPosition;
import pedersen.systems.FireControlBase;

public class FireControlStandardImpl
extends FireControlBase {
    public double getBulletVelocity(StaticPosition firingPosition, Target target) {
        double bulletVelocity = 0.0;
        double firepower = 2.5;
        double killpower = Conversions.getFirepowerFromBulletDamage(target.getEnergy());
        if (killpower < firepower) {
            firepower = killpower;
        } else if (firingPosition.getDistance(target) < 100.0) {
            firepower = 3.0;
        } else if (Host.singleton.getActiveEnemyCount() > 6) {
            firepower = 3.0;
        } else if (Metrics.getFiredShotCount() < 5L) {
            firepower = 0.1;
        }
        firepower = Constraints.getClosestLegalFirepower(firepower);
        bulletVelocity = Conversions.getBulletVelocityFromFirepower(firepower);
        return bulletVelocity;
    }

    public boolean isFiringAdvisable(Target target, double firepower) {
        boolean fire = true;
        double combatantEnergy = Host.singleton.getEnergy();
        double combatantFutureEnergy = combatantEnergy - firepower;
        if (combatantFutureEnergy < 0.1) {
            fire = false;
        }
        return fire;
    }
}

