/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting;

import pedersen.core.Conversions;
import pedersen.debug.Debug;
import pedersen.divination.FiringAngle;
import pedersen.tactics.targeting.TargetingMethod;

public class FiringSolution
extends FiringAngle {
    private final double firepower;

    public FiringSolution(FiringAngle firingAngle, double newVelocity) {
        super(firingAngle);
        this.firepower = Conversions.getFirepowerFromBulletVelocity(newVelocity);
    }

    public FiringSolution(TargetingMethod newTargetingMethod, double heading, double newVelocity) {
        super(newTargetingMethod, heading);
        this.firepower = Conversions.getFirepowerFromBulletVelocity(newVelocity);
    }

    public double getFirepower() {
        return this.firepower;
    }

    public double getOffensiveIndex() {
        return this.getTargetingStatistics().getSuccessRate() * Conversions.getBulletDamageFromFirepower(this.firepower);
    }

    public void debug() {
        Debug.debug("Firing solution:");
        Debug.debug("firepower: " + this.firepower);
        super.debug();
    }
}

