/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategy;
import dmh.robocode.gunner.simulator.EnemySimulator;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;

public abstract class CalibratedAimingStrategyUsingEnemySimulator
extends CalibratedAimingStrategy {
    private static final double maxShootingRange = 1200.0;

    public CalibratedAimingStrategyUsingEnemySimulator(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
    }

    protected Location getSimulatorIntercept(EnemySimulator simulator, double bulletSpeed) {
        Location lastLocationOnBattlefield = null;
        long turn = 0L;
        while ((double)turn < 1200.0 / bulletSpeed) {
            ++turn;
            simulator.takeOneTurn();
            if (!simulator.getLocation().isOnBattlefield(this.getMyRobot().getBattleFieldWidth(), this.getMyRobot().getBattleFieldHeight())) {
                return lastLocationOnBattlefield;
            }
            lastLocationOnBattlefield = simulator.getLocation();
            double travelDistance = (double)turn * bulletSpeed;
            double targetDistance = Geometry.getDistanceBetweenLocations(simulator.getLocation(), this.getMyRobot().getLocation());
            if (!(travelDistance - bulletSpeed < targetDistance) || !(travelDistance + bulletSpeed > targetDistance)) continue;
            return simulator.getLocation();
        }
        return null;
    }
}

