/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.enemy;

import dmh.robocode.bullet.DangerousBullet;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.enemy.EnemyShootingAtUsStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;

public class EnemyShootAtMyCurrentLocation
extends EnemyShootingAtUsStrategy {
    public EnemyShootAtMyCurrentLocation(CommandBasedRobot myRobot, EnemyRobot enemy) {
        super(myRobot, enemy);
    }

    @Override
    public DangerousBullet getDangerousBulletFiredNow(double bulletPower, double likelyToBeAimingForUs) {
        Location firedFrom = this.getEnemy().getLatestRadarObservation().getLocation();
        double estimatedHeading = Geometry.getBearingBetweenLocations(firedFrom, this.getMyRobot().getLocation());
        return new DangerousBullet(this, firedFrom, bulletPower, estimatedHeading, this.getMyRobot().getTime() - 1L, this.getEnemy(), likelyToBeAimingForUs);
    }
}

