/*
 * Decompiled with CFR 0.152.
 */
package bots;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class UnterBot
extends AdvancedRobot {
    double power;
    double dir;
    double speed;

    public void run() {
        this.power = 3.0;
        this.setFire(3.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.dir = 105.0;
        this.setBack(3.0 * 105.0);
        while (true) {
            this.scan();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double direction = this.getHeadingRadians() + e.getBearingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(direction - this.getRadarHeadingRadians())));
        this.setFire(this.power);
        this.speed = 0.85 * this.speed + 0.15 * e.getVelocity();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(direction - this.getGunHeadingRadians())) + this.speed * Math.sin(e.getHeadingRadians() - direction) / Math.sqrt(e.getDistance()));
        this.setTurnRight(e.getBearing() + 90.0 + this.dir / 5.0);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.power += 0.3;
        this.setBack(this.dir / 2.0);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.dir = -this.dir;
        this.setBack(this.dir);
        this.power -= 0.2;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.dir = -this.dir;
        this.setBack(this.dir);
    }

    public void onHitWall(HitWallEvent e) {
        this.dir = -this.dir;
        this.setBack(this.dir);
    }
}

