/*
 * Decompiled with CFR 0.152.
 */
package kid.data.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kid.data.pattern.FoldedEntry;
import kid.data.pattern.FoldedLinkedList;
import kid.data.pattern.Pattern;
import kid.data.pattern.PatternFactory;
import kid.data.pattern.Polar;
import kid.data.pattern.RobotRecorder;
import kid.graphics.Colors;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.management.RobotManager;
import kid.robot.RobotData;
import kid.utils.Utils;
import robocode.Event;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class PatternMatcher<E extends Pattern> {
    private RobotRecorder<E> recorder;
    private HashMap<String, LinkedList<FoldedEntry<E>>> robotMatches;
    private E NULL_PATTERN;
    private static RobotManager robots;

    public void start(Robot myRobot, PatternFactory<E> factory) {
        if (this.recorder == null) {
            this.recorder = new RobotRecorder<E>(myRobot, factory);
            this.robotMatches = new HashMap();
            this.NULL_PATTERN = factory.getNullPattern();
            robots = new RobotManager(myRobot);
        }
    }

    public FoldedEntry<E> getMatch(String name) {
        LinkedList<FoldedEntry<E>> matches = this.robotMatches.get(name);
        if (matches != null) {
            return matches.getFirst();
        }
        return null;
    }

    public FoldedEntry<E> getBestMatch(List<FoldedEntry<E>> choices) {
        LinkedList<FoldedEntry<E>> best = new LinkedList<FoldedEntry<E>>(choices);
        LinkedList future = new LinkedList(best);
        int recersion = 0;
        while (best.size() > 1 && recersion < 35) {
            char fold;
            ++recersion;
            LinkedList<FoldedEntry<E>> futureTemp = new LinkedList<FoldedEntry<E>>(future);
            future.clear();
            ArrayList<Character> folds = new ArrayList<Character>(futureTemp.size());
            int[] count = new int[futureTemp.size()];
            for (FoldedEntry foldedEntry : futureTemp) {
                if (!this.goodNext(foldedEntry)) continue;
                future.add(foldedEntry.next);
                fold = ((Pattern)foldedEntry.next.item).getFold();
                int index = folds.indexOf(Character.valueOf(fold));
                if (index >= 0) {
                    int n = index;
                    count[n] = count[n] + 1;
                    continue;
                }
                folds.add(Character.valueOf(fold));
            }
            boolean bl = false;
            int index = -1;
            int i = 0;
            while (i < folds.size()) {
                int n;
                int c = count[i];
                if (c > n) {
                    n = c;
                    index = i;
                }
                ++i;
            }
            if (index == -1) {
                return best.getFirst();
            }
            fold = ((Character)folds.get(index)).charValue();
            ListIterator iterB = best.listIterator();
            ListIterator iterF = future.listIterator();
            while (iterB.hasNext() && iterF.hasNext()) {
                iterB.next();
                if (((Pattern)((FoldedEntry)iterF.next()).item).getFold() == fold) continue;
                iterB.remove();
                iterF.remove();
            }
        }
        return best.getFirst();
    }

    public void inEvent(Event e) {
        this.recorder.inEvent(e);
        if (e instanceof ScannedRobotEvent) {
            this.handleScannedRobotEvent((ScannedRobotEvent)e);
        }
    }

    private void handleScannedRobotEvent(ScannedRobotEvent e) {
        FoldedLinkedList<E> movie;
        if (!this.robotMatches.containsKey(e.getName())) {
            this.robotMatches.put(e.getName(), new LinkedList());
        }
        if ((movie = this.recorder.get(e.getName())) == null) {
            return;
        }
        Pattern latest = (Pattern)movie.getLast();
        LinkedList<FoldedEntry<E>> matches = this.robotMatches.get(e.getName());
        LinkedList<FoldedEntry<E>> newMatches = new LinkedList<FoldedEntry<E>>();
        for (FoldedEntry foldedEntry : matches) {
            if (!latest.equals(foldedEntry.next.item) || !this.goodNext(foldedEntry.next)) continue;
            newMatches.add(foldedEntry.next);
        }
        int n = movie.size();
        LinkedList<FoldedEntry<E>> fold = movie.getFold(latest.getFold());
        if (newMatches.size() < 100 && fold != null) {
            for (FoldedEntry foldedEntry : fold) {
                if (n - foldedEntry.index <= 50) continue;
                newMatches.add(foldedEntry);
            }
            newMatches.addAll(fold);
        }
        this.robotMatches.put(e.getName(), newMatches);
    }

    private boolean goodNext(FoldedEntry<E> entry) {
        return entry != null && entry.next != null && entry.next.item != this.NULL_PATTERN;
    }

    public void draw(RGraphics grid) {
        this.recorder.draw(grid);
        if (!DrawMenu.getValue("Matcher", "Movie")) {
            return;
        }
        grid.setColor(Colors.GREEN);
        for (String name : this.robotMatches.keySet()) {
            FoldedLinkedList<E> list = this.recorder.get(name);
            LinkedList<FoldedEntry<E>> matchList = this.robotMatches.get(name);
            RobotData r = robots.getRobot(name);
            FoldedEntry<E> match = this.getMatch(name);
            if (!(match.item instanceof Polar) || r.isDead() || list == null || matchList.size() <= 0) continue;
            double x = r.getX();
            double y = r.getY();
            double h = r.getHeading();
            int i = 0;
            while (this.goodNext(match) && i < 50) {
                match = match.next;
                Polar p = (Polar)match.item;
                grid.fillOvalCenter(x += p.getVelocity() * Utils.sin(h += p.getDeltaHeading()), y += p.getVelocity() * Utils.cos(h), 2.0, 2.0);
                if (!this.goodNext(match)) {
                    match = this.getMatch(name);
                }
                ++i;
            }
        }
    }
}

