/*
 * Decompiled with CFR 0.152.
 */
package kid.info;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.io.Serializable;
import kid.data.Printable;
import kid.robot.RobotData;
import kid.robot.RobotVector;
import kid.utils.Utils;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.Rules;

public class RobotInfo
implements Cloneable,
Serializable,
Printable {
    private static final long serialVersionUID = -5451313209259625420L;
    public static final double WIDTH = 36.0;
    public static final double HEIGHT = 36.0;
    public static final double MIN_WALL_DIST = Math.max(36.0, 36.0) / 2.0 + 0.1;
    public static final double START_ENERGY = 100.0;
    public static final double START_ENERGY_DROID = 120.0;
    public static final double START_ENERGY_TEAM_LEADER = 200.0;
    public static final double START_ENERGY_DROID_TEAM_LEADER = 220.0;
    public static final double MAX_VELOCITY = 8.0;
    public static final double MAX_VELOCITY_REV = 8.0;
    public static final double MAX_TURN_RATE = Rules.getTurnRate((double)0.0);
    protected Robot robot;
    private Rectangle2D battlefield;
    private double battleFieldWidth;
    private double battleFieldHeight;

    public RobotInfo(Robot myRobot) {
        this.init(myRobot);
    }

    protected RobotInfo(RobotInfo myRobot) {
        this.init(myRobot.robot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        this.battleFieldWidth = this.robot.getBattleFieldWidth();
        this.battleFieldHeight = this.robot.getBattleFieldHeight();
        this.battlefield = new Rectangle2D.Double(MIN_WALL_DIST - 1.0, MIN_WALL_DIST - 1.0, this.getBattleFieldWidth() - 2.0 * (MIN_WALL_DIST - 1.0), this.getBattleFieldHeight() - 2.0 * (MIN_WALL_DIST - 1.0));
    }

    public String getName() {
        return this.robot.getName();
    }

    public double getX() {
        return this.robot.getX();
    }

    public double getY() {
        return this.robot.getY();
    }

    public Rectangle2D getBattleField() {
        return this.battlefield;
    }

    public double getMoveRemaining() {
        if (this.robot instanceof AdvancedRobot) {
            AdvancedRobot myRobot = (AdvancedRobot)this.robot;
            return myRobot.getDistanceRemaining();
        }
        return 0.0;
    }

    public int getMovingSign() {
        return this.getMoveRemaining() == 0.0 ? 0 : Utils.sign(this.getMoveRemaining());
    }

    public double getEnergy() {
        return this.robot.getEnergy();
    }

    public double getHeading() {
        return this.robot.getHeading();
    }

    public final double getFutureHeading() {
        return this.getHeading() + (double)this.getTurningSign() * Math.min(Math.abs(this.getTurnRemaining()), this.getTurnRate());
    }

    public static final double getFutureHeading(RobotVector current, double targetHeading) {
        double targetTurn = current.getHeading() - targetHeading;
        return current.getHeading() + Utils.absMin(targetTurn, Rules.getTurnRate((double)current.getHeading()));
    }

    public double getTurn() {
        return this.getTurnRate() * (double)this.getTurningSign();
    }

    public double getTurnRate() {
        return Rules.getTurnRate((double)this.getVelocity());
    }

    public double getTurnRemaining() {
        if (this.robot instanceof AdvancedRobot) {
            AdvancedRobot myRobot = (AdvancedRobot)this.robot;
            return myRobot.getTurnRemaining();
        }
        return 0.0;
    }

    public int getTurningSign() {
        return this.getTurnRemaining() == 0.0 ? 0 : Utils.sign(this.getTurnRemaining());
    }

    public double getVelocity() {
        return this.robot.getVelocity();
    }

    public final double getFutureVelocity() {
        double curVelocity = this.getVelocity();
        if (this.getMovingSign() == 0) {
            return curVelocity;
        }
        if (curVelocity == 0.0 || this.getMovingSign() == Utils.sign(curVelocity)) {
            return Utils.limit(8.0, curVelocity + (double)this.getMovingSign() * 1.0, 8.0);
        }
        return (double)Utils.sign(curVelocity) * Math.max(0.0, Math.abs(curVelocity) - 2.0);
    }

    public static final double getFutureVelocity(RobotVector current, double targetVelocity) {
        double curVelocity = current.getVelocity();
        int sign = Utils.sign(curVelocity);
        if ((double)sign * targetVelocity < (double)sign * curVelocity) {
            return Math.abs(curVelocity - targetVelocity) < 2.0 ? targetVelocity : curVelocity - (double)sign * 2.0;
        }
        return Math.abs(curVelocity - targetVelocity) < 1.0 ? targetVelocity : curVelocity + (double)sign * 1.0;
    }

    public static final double getFutureVelocity(double current, double target) {
        int sign = Utils.sign(current);
        if ((double)sign * target < (double)sign * current) {
            return Math.abs(current - target) < 2.0 ? target : current - (double)sign * 2.0;
        }
        return Math.abs(current - target) < 1.0 ? target : current + (double)sign * 1.0;
    }

    public long getTime() {
        return this.robot.getTime();
    }

    public int getOthers() {
        return this.robot.getOthers();
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }

    public final double angle(double x, double y) {
        double theta = Utils.atan2(x - this.getX(), y - this.getY());
        return Utils.relative(theta);
    }

    public final double angle(RobotData robot) {
        if (robot == null || robot.isDead()) {
            return this.getHeading();
        }
        return this.angle(robot.getX(), robot.getY());
    }

    public final double angle(Point2D point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.angle(point.getX(), point.getY());
    }

    public final double bearing(double angle) {
        return Utils.relative(angle - this.getHeading());
    }

    public final double bearing(double x, double y) {
        return this.bearing(this.angle(x, y));
    }

    public final double bearing(RobotData robot) {
        if (robot == null || robot.isDead()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.bearing(this.angle(robot));
    }

    public final double bearing(Point2D point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.bearing(this.angle(point));
    }

    public final double distSq(double x, double y) {
        return Utils.distSq(this.getX(), this.getY(), x, y);
    }

    public final double distSq(RobotData robot) {
        if (robot == null || robot.isDead()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.distSq(robot.getX(), robot.getY());
    }

    public final double distSq(Point2D point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.distSq(point.getX(), point.getY());
    }

    public final double dist(double x, double y) {
        return Utils.sqrt(this.distSq(x, y));
    }

    public final double dist(RobotData robot) {
        return Utils.sqrt(this.distSq(robot));
    }

    public final double dist(Point2D point) {
        return Utils.sqrt(this.distSq(point));
    }

    public static final double turnRadius(double velocity) {
        return 180.0 * Math.abs(velocity) / (Math.PI * RobotInfo.turnRate(velocity));
    }

    public static final double turnRate(double velocity) {
        return Rules.getTurnRate((double)velocity);
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    public Object clone() {
        return new RobotInfo(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RobotInfo) {
            RobotInfo robot = (RobotInfo)obj;
            return robot.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    protected void finalize() {
        this.robot = null;
    }
}

