/*
 * Decompiled with CFR 0.152.
 */
package kid.targeting;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import kid.graphics.Colors;
import kid.robot.RobotData;
import kid.targeting.Targeting;
import kid.utils.Utils;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.Rules;

public class LinearTargeting
extends Targeting {
    private static final long serialVersionUID = 6581499402431094042L;
    private boolean avgVelocity = false;

    public LinearTargeting(Robot myRobot) {
        this(myRobot, false);
    }

    public LinearTargeting(Robot myRobot, boolean avgVelocity) {
        super(myRobot);
        this.init(avgVelocity);
    }

    public LinearTargeting(LinearTargeting targeting) {
        super(targeting);
        this.init(targeting.avgVelocity);
    }

    private void init(boolean avgVelocity) {
        this.avgVelocity = avgVelocity;
    }

    @Override
    public double getAngle(RobotData target, double firePower) {
        double angle = Utils.relative(this.gunInfo.getHeading() + this.gunInfo.getHeading());
        if (target != null && !target.isDead()) {
            firePower = Math.min(this.robot.getEnergy(), firePower);
            firePower = Utils.limit(0.1, firePower, 3.0);
            double bulletVelocity = Rules.getBulletSpeed((double)firePower);
            Rectangle2D battleField = this.gunInfo.getBattleField();
            double myX = this.robot.getX();
            double myY = this.robot.getY();
            double prodictedX = target.getX();
            double prodictedY = target.getY();
            double enemyVelocity = this.avgVelocity ? target.getAvgVelocity() : target.getVelocity();
            double deltaX = Utils.getDeltaX(enemyVelocity, target.getHeading());
            double deltaY = Utils.getDeltaY(enemyVelocity, target.getHeading());
            int t = -1;
            while (Utils.sqr((double)t * bulletVelocity) < Utils.distSq(myX, myY, prodictedX, prodictedY) && battleField.contains(prodictedX, prodictedY)) {
                if (!battleField.contains(prodictedX += deltaX, prodictedY += deltaY)) {
                    prodictedX -= deltaX;
                    prodictedY -= deltaY;
                }
                ++t;
            }
            angle = this.gunInfo.angle(prodictedX, prodictedY);
        }
        return angle;
    }

    @Override
    public Color getColor() {
        return Colors.GREEN;
    }

    @Override
    public String getName() {
        return new String("Linear Targeting");
    }

    @Override
    public String getType() {
        return new String("Fast");
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    public void debug(PrintStream console) {
    }

    public void debug(RobocodeFileOutputStream output) {
    }

    public Object clone() {
        return new LinearTargeting(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LinearTargeting) {
            LinearTargeting targeting = (LinearTargeting)obj;
            if (targeting.robot != null && targeting.robot.getName() != null && this.robot != null) {
                return targeting.robot.getName().equals(this.robot.getName());
            }
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

