/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.morfeas.EnemyState;
import gre.svman4.morfeas.EnemyWaveBullet;
import gre.svman4.morfeas.OneVsOneMovementStrategy;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class WaveSurfer
extends OneVsOneMovementStrategy {
    private ArrayList<EnemyWaveBullet> _waves;

    public WaveSurfer(RobotState me, Rectangle2D movingArea, EnemyState target, ArrayList<EnemyWaveBullet> waves) {
        super(me, movingArea, target);
        this._waves = waves;
    }

    private float checkDanger(EnemyWaveBullet surfWave, int direction) {
        int indexAngle = surfWave.getFactorIndex(this.predictPosition(surfWave, direction));
        return surfWave.getEnemyCurrentStatus()[indexAngle];
    }

    private EnemyWaveBullet getClosestSurfableWave() {
        double closestDistance = Double.MAX_VALUE;
        EnemyWaveBullet surfWave = null;
        for (EnemyWaveBullet ew : this._waves) {
            double distance = this._mineRobot.distance(ew.fireLocation) - ew.distanceTraveled;
            if (!(distance > ew.bulletVelocity) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    @Override
    public Color getColor() {
        return Color.yellow;
    }

    @Override
    public String getName() {
        return "Wave surfer";
    }

    @Override
    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        for (int i = 0; i < this._waves.size(); ++i) {
            EnemyWaveBullet wave = this._waves.get(i);
            wave.onPaint(g);
        }
    }

    private FieldPoint predictPosition(EnemyWaveBullet surfWave, int direction) {
        FieldPoint predictedPosition = (FieldPoint)this._mineRobot.clone();
        double predictedVelocity = this._mineRobot.velocity;
        double predictedHeading = this._mineRobot.heading;
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, surfWave.fireLocation.getAngleTo(predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + EnemyWaveBullet.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = EnemyWaveBullet.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = predictedPosition.project(predictedVelocity, predictedHeading);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    @Override
    public void run(AdvancedRobot robot) {
        EnemyWaveBullet surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            this._movingAngle = this._target.getAngleTo(this._mineRobot);
            this._movingAngle = this.wallSmoothing(this._mineRobot, this._movingAngle, -1);
            this.goTo(this._movingAngle, 50.0, robot);
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        this._movingAngle = surfWave.fireLocation.getAngleTo(this._mineRobot);
        if (dangerLeft < dangerRight) {
            this._movingAngle -= 1.5707963267948966;
            this._movingAngle = this.wallSmoothing(this._mineRobot, this._movingAngle, -1);
        } else {
            this._movingAngle += 1.5707963267948966;
            this._movingAngle = this.wallSmoothing(this._mineRobot, this._movingAngle, 1);
        }
        this.goTo(this._movingAngle, 50.0, robot);
    }

    public void setWaves(ArrayList<EnemyWaveBullet> wave) {
        this._waves = wave;
    }

    private void drawDistanceLineFromTarget(Graphics2D g) {
        g.setColor(Color.GREEN);
        FieldPoint tempPoint = new FieldPoint();
        double temp = this._mineRobot.distance(this._target);
        g.setColor(this.getColor(-100.0, -temp + 100.0, 100.0));
        g.drawLine((int)this._mineRobot.x, (int)this._mineRobot.y, (int)this._target.x, (int)this._target.y);
        tempPoint.setLocation(this._mineRobot.getMeanPoint(this._target));
        g.drawString(String.format("%.0fpx", temp), (int)tempPoint.x, (int)tempPoint.y);
    }
}

