/*
 * Decompiled with CFR 0.152.
 */
package fwb;

import MGAM.BotMaster;
import MGAM.Enemy;
import MGAM.Gun;
import MGAM.Vec2D;
import fwb.FWBBotInfo;
import java.awt.Graphics2D;

public class HeadOnTargeting
extends Gun {
    boolean fired = false;

    public HeadOnTargeting(BotMaster bot) {
        super(bot);
    }

    @Override
    public void shoot() {
        if (this.bot.enemy != null) {
            if (this.fired && (this.bot.getEnergy() > 5.0 || this.bot.chumpShot && this.bot.getOthers() <= 3)) {
                int energy = 0;
                for (Enemy tank : BotMaster.enemies.values()) {
                    if (tank.bDead) continue;
                    energy = (int)((double)energy + ((FWBBotInfo)tank.botInfo).dEnergy);
                }
                energy /= this.bot.getOthers();
                if (this.bot.chumpShot || !this.bot.plannedShot && this.bot.getOthers() > 1) {
                    if (this.bot.getEnergy() > (double)(energy * 2) && !this.bot.chumpShot) {
                        this.bot.setFireBullet(3.0);
                    } else if (this.bot.getEnergy() > (double)energy && !this.bot.chumpShot) {
                        this.bot.setFireBullet(0.25);
                    } else if (this.bot.chumpShot) {
                        this.bot.setFireBullet(0.1);
                    }
                } else if (this.bot.plannedShot) {
                    this.bot.setFireBullet(3.0);
                }
                this.fired = false;
            }
            this.fired = false;
            Vec2D myDir = new Vec2D(Math.sin(this.bot.getHeadingRadians()), Math.cos(this.bot.getHeadingRadians()));
            Vec2D gunDir = new Vec2D(Math.sin(this.bot.getGunHeadingRadians()), Math.cos(this.bot.getGunHeadingRadians()));
            gunDir.normalize();
            Vec2D gunPerp = new Vec2D(-gunDir.getY(), gunDir.getX());
            Vec2D targetPos = ((FWBBotInfo)this.bot.enemy.botInfo).getPosition();
            Vec2D targetDir = targetPos.subtract(((FWBBotInfo)this.bot.self.botInfo).getPosition());
            Vec2D targetHeading = new Vec2D(Math.sin(((FWBBotInfo)this.bot.enemy.botInfo).dHeadingRad), Math.cos(((FWBBotInfo)this.bot.enemy.botInfo).dHeadingRad));
            targetHeading = targetHeading.normalize();
            if (((FWBBotInfo)this.bot.enemy.botInfo).dVelocity < 0.0) {
                // empty if block
            }
            targetDir.normalize();
            myDir.normalize();
            targetHeading = new Vec2D(0.0, 0.0);
            targetPos = targetPos.add(targetHeading);
            targetDir = targetPos.subtract(((FWBBotInfo)this.bot.self.botInfo).getPosition());
            targetDir.normalize();
            double angle = gunDir.angle(targetDir);
            if (targetDir.dotProduct(gunPerp) < 0.0) {
                this.bot.setTurnGunRight(angle);
            } else {
                this.bot.setTurnGunLeft(angle);
            }
            if (Math.abs(angle) < 20.0) {
                this.fired = true;
            }
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        for (Enemy tank : BotMaster.enemies.values()) {
            if (tank.bDead || tank.botInfo.dEnergy == 0.0) continue;
            Vec2D tankPos = ((FWBBotInfo)tank.botInfo).getPosition();
            Vec2D myPos = new Vec2D(this.bot.self.botInfo.dX, this.bot.self.botInfo.dY);
            tankPos.distance(myPos);
            Vec2D gunDir = new Vec2D(Math.sin(this.bot.getGunHeadingRadians()), Math.cos(this.bot.getGunHeadingRadians()));
            Vec2D targetDir = tankPos.subtract(myPos);
            gunDir = gunDir.multiply(100.0);
            targetDir = targetDir.multiply(100.0);
            Vec2D drawgun = myPos.add(gunDir);
            Vec2D drawTarget = myPos.add(targetDir);
            g.drawLine((int)myPos.getX(), (int)myPos.getY(), (int)drawgun.getX(), (int)drawgun.getY());
            g.drawLine((int)myPos.getX(), (int)myPos.getY(), (int)drawTarget.getX(), (int)drawTarget.getY());
            gunDir.normalize();
            targetDir.normalize();
        }
    }

    public class Line {
        Vec2D p1;
        Vec2D p2;

        public Line(Vec2D point1, Vec2D point2) {
            this.p1 = point1;
            this.p2 = point2;
        }

        public Line() {
            this.p1 = new Vec2D(0.0, 0.0);
            this.p2 = new Vec2D(0.0, 0.0);
        }

        public Vec2D Intersect(Line line) {
            Vec2D temp = new Vec2D(0.0, 0.0);
            temp.x = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.x - line.p2.x) - (this.p1.x - this.p2.x) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            temp.y = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            return temp;
        }
    }
}

