/*
 * Decompiled with CFR 0.152.
 */
package fwb;

import MGAM.BotMaster;
import MGAM.Enemy;
import MGAM.Movement;
import MGAM.Vec2D;
import fwb.FWBBotInfo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import robocode.Event;

public class SuperWallsMovement
extends Movement {
    List<WallData> m_WallData = new LinkedList<WallData>();
    List<Vec2D> m_PositionData = new LinkedList<Vec2D>();
    int positionIndex = 0;
    final int m_NumSegments = 25;
    final double m_TargetConeDeg = 45.0;
    final double m_TargetConeRad = Math.toRadians(45.0);
    final int m_WallBuffer = 80;
    final int m_TargetSpeed = 10;
    Vec2D m_TargetPos = new Vec2D(0.0, 0.0);
    Vec2D m_TargetDir = new Vec2D(10.0, 0.0);
    boolean init = true;
    double reverseTimer = 0.0;
    double reverseTime = 10.0;
    double time = 0.0;
    double juke = 1.0;
    double targetTurnTime = 0.0;
    int m_TargetDirection = 1;
    double m_DirectionChangeTime = 0.0;
    int m_MyDirection = 1;

    public SuperWallsMovement(BotMaster bot) {
        super(bot);
        int i = 0;
        while (i < 100) {
            this.m_WallData.add(new WallData());
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.m_PositionData.add(new Vec2D(0.0, 0.0));
            ++i;
        }
    }

    public void init() {
        Vec2D myPos = new Vec2D(this.bot.self.botInfo.dX, this.bot.self.botInfo.dY);
        this.m_TargetPos = this.PosToWallPos(myPos);
        System.out.println("INIT!");
    }

    @Override
    public void move() {
        this.time += 1.0;
        if (this.init) {
            this.init();
            this.init = false;
        }
        this.UpdateTarget();
        this.ClearThreats();
        this.UpdateThreats();
        this.UpdateBotMotion();
        Vec2D myPos = new Vec2D(this.bot.self.botInfo.dX, this.bot.self.botInfo.dY);
        this.m_PositionData.get((int)this.positionIndex).x = myPos.x;
        this.m_PositionData.get((int)this.positionIndex).y = myPos.y;
        ++this.positionIndex;
        if (this.positionIndex >= 4) {
            this.positionIndex = 0;
        }
        int numSame = 0;
        int i = 0;
        while (i < 3) {
            if (this.m_PositionData.get(i).distance(this.m_PositionData.get(i + 1)) < 1.0E-6) {
                ++numSame;
            }
            ++i;
        }
        if (numSame == 3 && this.time > this.m_DirectionChangeTime + 10.0) {
            this.m_MyDirection *= -1;
            this.m_DirectionChangeTime = this.time;
        }
    }

    public void UpdateTarget() {
        Vec2D curDir = this.m_TargetDir.multiply(this.m_TargetDirection);
        int element = this.PosToElement(this.m_TargetPos);
        double curThreat = this.m_WallData.get((int)element).m_Threat;
        if (curThreat > 75.0 && this.bot.getOthers() <= 5 || this.time < 20.0) {
            curDir = curDir.multiply(3.0);
        }
        this.m_TargetPos = this.m_TargetPos.add(curDir);
        if (this.m_TargetPos.x < 80.0) {
            this.m_TargetPos.x = 80.0;
            this.m_TargetDir = new Vec2D(0.0, -10.0);
        }
        if (this.m_TargetPos.y < 80.0) {
            this.m_TargetPos.y = 80.0;
            this.m_TargetDir = new Vec2D(10.0, 0.0);
        }
        if (this.m_TargetPos.x > BotMaster.battlefieldWidth - 80.0) {
            this.m_TargetPos.x = BotMaster.battlefieldWidth - 80.0;
            this.m_TargetDir = new Vec2D(0.0, 10.0);
        }
        if (this.m_TargetPos.y > BotMaster.battlefieldHeight - 80.0) {
            this.m_TargetPos.y = BotMaster.battlefieldHeight - 80.0;
            this.m_TargetDir = new Vec2D(-10.0, 0.0);
        }
        double leftThreat = 10000.0;
        double rightThreat = 10000.0;
        int curElement = element;
        double lookAhead = 2.0;
        int getSettledTime = 50;
        if (this.time > (double)getSettledTime) {
            lookAhead = this.bot.getOthers() == 1 ? 1.0 : 2.0 * (1.0 - (double)((float)this.bot.getOthers() / ((float)BotMaster.enemies.size() + 1.0f)));
        }
        int i = 0;
        while ((double)i < 25.0 * lookAhead) {
            curElement = curElement < 99 ? ++curElement : 0;
            leftThreat += this.m_WallData.get((int)curElement).m_Threat;
            ++i;
        }
        curElement = element;
        i = 0;
        while ((double)i < 50.0) {
            curElement = curElement < 99 ? ++curElement : 0;
            double cfr_ignored_0 = this.m_WallData.get((int)curElement).m_Threat;
            ++i;
        }
        curElement = element;
        i = 0;
        while ((double)i < 25.0 * lookAhead) {
            curElement = curElement > 0 ? --curElement : 99;
            rightThreat += this.m_WallData.get((int)curElement).m_Threat;
            ++i;
        }
        curElement = element;
        i = 0;
        while ((double)i < 50.0) {
            curElement = curElement > 0 ? --curElement : 99;
            double cfr_ignored_1 = this.m_WallData.get((int)curElement).m_Threat;
            ++i;
        }
        if (curThreat >= 10.0 && this.time > this.targetTurnTime + 10.0 || this.time < (double)getSettledTime || this.targetTurnTime + 50.0 < this.time || this.targetTurnTime + 10.0 < this.time && this.bot.getOthers() == 1) {
            if (this.m_TargetDirection < 0 && leftThreat > rightThreat) {
                this.m_TargetDirection *= -1;
            }
            if (this.m_TargetDirection > 0 && leftThreat < rightThreat) {
                this.m_TargetDirection *= -1;
            }
            this.targetTurnTime = this.time;
        }
    }

    public void ClearThreats() {
        int i = 0;
        while (i < 100) {
            WallData wallData = this.m_WallData.get(i);
            wallData.m_Threat = 0.0;
            ++i;
        }
    }

    public void UpdateBotMotion() {
        double dot;
        Vec2D turnDir = new Vec2D(0.0, 50.0);
        double[] turnWeights = new double[45];
        int i = 0;
        while (i < 45) {
            turnWeights[i] = 0.0;
            ++i;
        }
        Vec2D myPos = new Vec2D(this.bot.self.botInfo.dX, this.bot.self.botInfo.dY);
        Vec2D targetHeading = this.m_TargetPos.subtract(myPos);
        int i2 = 0;
        while (i2 < 45) {
            turnDir = turnDir.rotateRadians(Math.toRadians(8.0));
            new Vec2D(myPos.add((Vec2D)turnDir).x, myPos.add((Vec2D)turnDir).y);
            for (Enemy tank : BotMaster.enemies.values()) {
                if (tank.bDead || tank.botInfo.dEnergy == 0.0) continue;
                Vec2D tankPos = ((FWBBotInfo)tank.botInfo).getPosition();
                Vec2D enemyDir = tankPos.subtract(myPos);
                double distance = enemyDir.magnitude();
                if (distance < 150.0) {
                    Vec2D bufferDir = new Vec2D(0.0, 50.0);
                    int j = 0;
                    while (j < 8) {
                        Vec2D trueTankPos;
                        Vec2D trueTankDir;
                        double bufferDot;
                        bufferDir = bufferDir.rotateRadians(Math.toRadians(45.0));
                        tankPos = ((FWBBotInfo)tank.botInfo).getPosition();
                        enemyDir = (tankPos = tankPos.add(bufferDir)).subtract(myPos);
                        double angle = turnDir.angle(enemyDir);
                        if (angle > 200.0) {
                            angle = 180.0 - (angle - 180.0);
                        }
                        if ((bufferDot = enemyDir.dotProduct(trueTankDir = (trueTankPos = ((FWBBotInfo)tank.botInfo).getPosition()).subtract(myPos))) > 0.2 && Math.abs(angle) < 30.0) {
                            int n = i2;
                            turnWeights[n] = turnWeights[n] - 50.0;
                        }
                        ++j;
                    }
                }
                Vec2D testTurnDir = turnDir;
                testTurnDir.normalize();
                testTurnDir.multiply(100.0);
                testTurnDir = turnDir.add(myPos);
                if (!(testTurnDir.x < 0.0 || testTurnDir.x > BotMaster.battlefieldWidth || testTurnDir.y < 0.0) && !(testTurnDir.y > BotMaster.battlefieldHeight)) continue;
                int n = i2;
                turnWeights[n] = turnWeights[n] - 50.0;
            }
            double targetAngle = targetHeading.angle(turnDir);
            int n = i2++;
            turnWeights[n] = turnWeights[n] + (1.0 - targetAngle / 360.0) * 50.0;
        }
        double bestTurn = 0.0;
        int turnIndex = -1;
        int i3 = 0;
        while (i3 < 45) {
            if (turnWeights[i3] > bestTurn) {
                turnIndex = i3;
                bestTurn = turnWeights[i3];
            }
            ++i3;
        }
        turnDir = new Vec2D(0.0, 50.0);
        Vec2D myDir = new Vec2D(Math.sin(this.bot.getHeadingRadians()), Math.cos(this.bot.getHeadingRadians()));
        myDir = myDir.multiply(this.m_MyDirection);
        Vec2D myPerp = new Vec2D(myDir.y, -myDir.x);
        double angle = (myDir = myDir.multiply(100.0)).angle(turnDir = turnDir.rotateRadians(Math.toRadians(8.0) * (double)turnIndex));
        if (Math.abs(angle) > 90.0 && Math.abs(angle) < 270.0 && this.time > this.m_DirectionChangeTime + 20.0) {
            this.m_DirectionChangeTime = this.time;
            this.m_MyDirection *= -1;
            if (angle > 180.0) {
                angle -= 180.0;
            } else if (angle < 180.0) {
                angle = 180.0 - angle;
            }
        }
        if ((dot = myPerp.dotProduct(turnDir)) < 0.0) {
            angle *= -1.0;
        }
        if (this.time % 20.0 == 0.0) {
            this.juke *= -1.0;
        }
        double fakeout = 45.0 * this.juke;
        if (Math.abs(angle) > 15.0 || this.time < 30.0) {
            fakeout = 0.0;
        }
        this.bot.setTurnRight(angle + fakeout);
        if (Math.abs(angle) < 40.0) {
            this.bot.setAhead(1000 * this.m_MyDirection);
        } else {
            this.bot.setAhead(15 * this.m_MyDirection);
        }
    }

    public void UpdateThreats() {
        int i = 0;
        while (i < 100) {
            Vec2D wallPos = this.WallSegmentToPos(i);
            Iterator<Enemy> iterator = BotMaster.enemies.values().iterator();
            boolean incremented = false;
            while (iterator.hasNext()) {
                Enemy tank = iterator.next();
                Vec2D tankPos = ((FWBBotInfo)tank.botInfo).getPosition();
                Iterator<Enemy> inItterator = BotMaster.enemies.values().iterator();
                double closestEnemy = BotMaster.battlefieldWidth + BotMaster.battlefieldHeight;
                while (inItterator.hasNext()) {
                    Vec2D targetTankPos;
                    double dist;
                    Enemy targetTank = inItterator.next();
                    if (targetTank == tank || targetTank.bDead || !((dist = (targetTankPos = ((FWBBotInfo)targetTank.botInfo).getPosition()).distance(tankPos)) < closestEnemy)) continue;
                    closestEnemy = dist;
                }
                double wallDist = tankPos.distance(wallPos);
                closestEnemy *= 2.0;
                if (incremented || tank.bDead || this.bot.getOthers() < 2 && tank.botInfo.dEnergy == 0.0 && !(this.bot.self.botInfo.dEnergy < 10.0) || !(wallDist < closestEnemy && closestEnemy < 400.0) && (!(closestEnemy > 400.0) || !(wallDist < 500.0))) continue;
                incremented = true;
                this.m_WallData.get((int)i).m_Threat += 10.0;
                if (wallDist < 400.0) {
                    this.m_WallData.get((int)i).m_Threat += 5.0;
                }
                if (!(wallDist < 300.0)) continue;
                this.m_WallData.get((int)i).m_Threat += 5.0;
            }
            ++i;
        }
        for (Enemy tank : BotMaster.enemies.values()) {
            for (Enemy targetTank : BotMaster.enemies.values()) {
                Vec2D intersect;
                if (tank == targetTank || targetTank.bDead || tank.bDead || tank.botInfo.dEnergy == 0.0) continue;
                Vec2D tankPos = ((FWBBotInfo)tank.botInfo).getPosition();
                Vec2D targetTankPos = ((FWBBotInfo)targetTank.botInfo).getPosition();
                Vec2D dir = targetTankPos.subtract(tankPos);
                dir = dir.normalize();
                Vec2D leftTargetDir = dir.rotateRadians(-this.m_TargetConeRad / 2.0);
                Vec2D rightTargetDir = dir.rotateRadians(this.m_TargetConeRad / 2.0);
                leftTargetDir = leftTargetDir.normalize();
                rightTargetDir = rightTargetDir.normalize();
                leftTargetDir = leftTargetDir.multiply(2000.0);
                rightTargetDir = rightTargetDir.multiply(2000.0);
                leftTargetDir = leftTargetDir.add(tankPos);
                rightTargetDir = rightTargetDir.add(tankPos);
                Line top = new Line();
                top.p1 = new Vec2D(0.0, BotMaster.battlefieldHeight - 0.0);
                top.p2 = new Vec2D(BotMaster.battlefieldWidth - 0.0, BotMaster.battlefieldHeight - 0.0);
                Line bottom = new Line();
                bottom.p1 = new Vec2D(0.0, 0.0);
                bottom.p2 = new Vec2D(BotMaster.battlefieldWidth - 0.0, 0.0);
                Line left = new Line();
                left.p1 = new Vec2D(0.0, 0.0);
                left.p2 = new Vec2D(0.0, BotMaster.battlefieldHeight - 0.0);
                Line right = new Line();
                right.p1 = new Vec2D(BotMaster.battlefieldWidth - 0.0, BotMaster.battlefieldHeight - 0.0);
                right.p2 = new Vec2D(BotMaster.battlefieldWidth - 0.0, 0.0);
                Line leftTargetLine = new Line();
                leftTargetLine.p1 = tankPos;
                leftTargetLine.p2 = leftTargetDir;
                Line rightTargetLine = new Line();
                rightTargetLine.p1 = tankPos;
                rightTargetLine.p2 = rightTargetDir;
                Vec2D leftIntersect = new Vec2D(0.0, 0.0);
                Vec2D rightIntersect = new Vec2D(0.0, 0.0);
                if (this.DoesIntersectOnMap(top, leftTargetLine, tankPos, leftTargetDir)) {
                    leftIntersect = intersect = top.Intersect(leftTargetLine);
                } else if (this.DoesIntersectOnMap(bottom, leftTargetLine, tankPos, leftTargetDir)) {
                    Vec2D intersect2;
                    leftIntersect = intersect2 = bottom.Intersect(leftTargetLine);
                } else if (this.DoesIntersectOnMap(left, leftTargetLine, tankPos, leftTargetDir)) {
                    Vec2D intersect3;
                    leftIntersect = intersect3 = left.Intersect(leftTargetLine);
                } else if (this.DoesIntersectOnMap(right, leftTargetLine, tankPos, leftTargetDir)) {
                    Vec2D intersect4;
                    leftIntersect = intersect4 = right.Intersect(leftTargetLine);
                }
                if (this.DoesIntersectOnMap(top, rightTargetLine, tankPos, rightTargetDir)) {
                    rightIntersect = intersect = top.Intersect(rightTargetLine);
                } else if (this.DoesIntersectOnMap(bottom, rightTargetLine, tankPos, rightTargetDir)) {
                    rightIntersect = intersect = bottom.Intersect(rightTargetLine);
                } else if (this.DoesIntersectOnMap(left, rightTargetLine, tankPos, rightTargetDir)) {
                    rightIntersect = intersect = left.Intersect(rightTargetLine);
                } else if (this.DoesIntersectOnMap(right, rightTargetLine, tankPos, rightTargetDir)) {
                    rightIntersect = intersect = right.Intersect(rightTargetLine);
                }
                int leftElement = this.PosToElement(leftIntersect);
                int rightElement = this.PosToElement(rightIntersect);
                while (leftElement != rightElement) {
                    rightElement = rightElement < 99 ? ++rightElement : 0;
                    this.bot.getOthers();
                    if (!(this.m_WallData.get((int)rightElement).m_Threat > 255.0)) continue;
                    this.m_WallData.get((int)rightElement).m_Threat = 255.0;
                }
            }
        }
    }

    @Override
    public void handleEvent(Event e) {
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(new Color(255, 255, 255, 255));
        g.fillRect((int)this.m_TargetPos.getX(), (int)this.m_TargetPos.getY(), 30, 30);
        int i = 0;
        while (i < 100) {
            WallData wallData = this.m_WallData.get(i);
            Vec2D pos = this.WallSegmentToPos(i);
            int color = (int)wallData.m_Threat * 3;
            if (color > 255) {
                color = 255;
            }
            g.setColor(new Color(color, color, 0, 255));
            g.fillRect((int)pos.getX(), (int)pos.getY(), 10, 10);
            ++i;
        }
    }

    public boolean DoesIntersectOnMap(Line line1, Line line2, Vec2D refPos, Vec2D refDir) {
        Vec2D intersect = line1.Intersect(line2);
        if (intersect.x >= -80.0 && intersect.x <= BotMaster.battlefieldWidth + 80.0 && intersect.y >= -80.0 && intersect.y <= BotMaster.battlefieldHeight + 80.0) {
            Vec2D interDir = refPos.subtract(intersect);
            Vec2D targetDir = refPos.subtract(refDir);
            double interDot = targetDir.dotProduct(interDir);
            if (interDot > 0.0) {
                return true;
            }
        }
        return false;
    }

    public int PosToWallIndex(Vec2D vec) {
        if (vec.x <= 80.0) {
            return 3;
        }
        if (vec.x >= BotMaster.battlefieldWidth - 80.0) {
            return 1;
        }
        if (vec.y <= 80.0) {
            return 2;
        }
        if (vec.y >= BotMaster.battlefieldHeight - 80.0) {
            return 0;
        }
        System.out.println("OMG AN ERROR... LIKE WOAH");
        return -1;
    }

    public int PosToElement(Vec2D vec) {
        int index = this.PosToWallIndex(vec);
        int offset = 0;
        if (index == 0) {
            offset = (int)(vec.x / BotMaster.battlefieldWidth * 25.0);
        }
        if (index == 2) {
            offset = 25 - (int)(vec.x / BotMaster.battlefieldWidth * 25.0);
        } else if (index == 1) {
            offset = 25 - (int)(vec.y / BotMaster.battlefieldHeight * 25.0);
        } else if (index == 3) {
            offset = (int)(vec.y / BotMaster.battlefieldHeight * 25.0);
        }
        int element = index * 25 + offset;
        if (element >= 100) {
            element = 99;
        }
        return element;
    }

    public Vec2D WallSegmentToPos(int segment) {
        int index = this.WallSegmentToIndex(segment);
        double segmentOffset = segment % 25;
        double segmentOffsetRatio = segmentOffset / 25.0;
        double segmentLength = 0.0;
        Vec2D startPos = new Vec2D(0.0, 0.0);
        Vec2D dir = new Vec2D(0.0, 0.0);
        if (index == 0) {
            startPos = new Vec2D(0.0, BotMaster.battlefieldHeight);
            dir = new Vec2D(1.0, 0.0);
            segmentLength = segmentOffsetRatio * BotMaster.battlefieldWidth;
        } else if (index == 1) {
            startPos = new Vec2D(BotMaster.battlefieldWidth, BotMaster.battlefieldHeight);
            dir = new Vec2D(0.0, -1.0);
            segmentLength = segmentOffsetRatio * BotMaster.battlefieldHeight;
        } else if (index == 2) {
            startPos = new Vec2D(BotMaster.battlefieldWidth, 0.0);
            dir = new Vec2D(-1.0, 0.0);
            segmentLength = segmentOffsetRatio * BotMaster.battlefieldWidth;
        } else if (index == 3) {
            startPos = new Vec2D(0.0, 0.0);
            dir = new Vec2D(0.0, 1.0);
            segmentLength = segmentOffsetRatio * BotMaster.battlefieldHeight;
        }
        Vec2D offset = dir.multiply(segmentLength);
        Vec2D finalPos = startPos.add(offset);
        return finalPos;
    }

    public int WallSegmentToIndex(int segment) {
        return segment / 25;
    }

    public Vec2D PosToWallPos(Vec2D pos) {
        Vec2D up = new Vec2D(0.0, 1.0);
        Vec2D down = new Vec2D(0.0, -1.0);
        Vec2D right = new Vec2D(1.0, 0.0);
        Vec2D left = new Vec2D(-1.0, 0.0);
        Vec2D topLeft = new Vec2D(0.0, BotMaster.battlefieldHeight);
        Vec2D topRight = new Vec2D(BotMaster.battlefieldWidth, BotMaster.battlefieldHeight);
        Vec2D bottomLeft = new Vec2D(0.0, 0.0);
        Vec2D bottomRight = new Vec2D(BotMaster.battlefieldWidth, 0.0);
        Line upLine = new Line(pos, pos.add(up));
        Line downLine = new Line(pos, pos.add(down));
        Line rightLine = new Line(pos, pos.add(right));
        Line leftLine = new Line(pos, pos.add(left));
        Line battleFieldUp = new Line(topLeft, topRight);
        Line battleFieldDown = new Line(bottomLeft, bottomRight);
        Line battleFieldLeft = new Line(topLeft, bottomLeft);
        Line battleFieldRight = new Line(topRight, bottomRight);
        Vec2D[] points = new Vec2D[]{upLine.Intersect(battleFieldUp), downLine.Intersect(battleFieldDown), leftLine.Intersect(battleFieldLeft), rightLine.Intersect(battleFieldRight)};
        double closest = BotMaster.battlefieldWidth + BotMaster.battlefieldHeight;
        int closestIndex = 0;
        int i = 0;
        while (i < 4) {
            double dist = points[i].distance(pos);
            if (dist < closest) {
                closest = dist;
                closestIndex = i;
            }
            ++i;
        }
        return points[closestIndex];
    }

    public class BulletData {
        Vec2D m_PosFired;
        double m_Time;
    }

    public class Line {
        Vec2D p1;
        Vec2D p2;

        public Line(Vec2D point1, Vec2D point2) {
            this.p1 = point1;
            this.p2 = point2;
        }

        public Line() {
            this.p1 = new Vec2D(0.0, 0.0);
            this.p2 = new Vec2D(0.0, 0.0);
        }

        public Vec2D Intersect(Line line) {
            Vec2D temp = new Vec2D(0.0, 0.0);
            temp.x = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.x - line.p2.x) - (this.p1.x - this.p2.x) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            temp.y = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            return temp;
        }
    }

    public class WallData {
        double m_Threat = 0.0;
        List<BulletData> m_BulletData = new LinkedList<BulletData>();
    }
}

