/*
 * Decompiled with CFR 0.152.
 */
package boe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyEvent;
import robocode.MouseEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Minerva
extends AdvancedRobot {
    private static double midpointAGPowerMin = 500.0;
    private static double midpointAGPowerMax = 600.0;
    private static double midpointAGPowerInterval = 100.0;
    private static double quadrantAGPowerMin = 20000.0;
    private static double quadrantAGPowerMax = 21000.0;
    private static double quadrantAGPowerInterval = 500.0;
    private static double wallsAGPowerMin = 5000.0;
    private static double wallsAGPowerMax = 6000.0;
    private static double wallsAGPowerInterval = 1000.0;
    private static double enemyAGPowerMin = -10000.0;
    private static double enemyAGPowerMax = -8000.0;
    private static double enemyAGPowerInterval = 1000.0;
    private static double bulletAGPowerMin = 0.0;
    private static double bulletAGPowerMax = 1.0;
    private static double bulletAGPowerInterval = 1.0;
    private static double midpointAGPowMin = 1.5;
    private static double midpointAGPowMax = 2.0;
    private static double midpointAGPowInterval = 0.5;
    private static double quadrantAGPowMin = 1.5;
    private static double quadrantAGPowMax = 2.0;
    private static double quadrantAGPowInterval = 0.5;
    private static double wallsAGPowMin = 3.0;
    private static double wallsAGPowMax = 4.0;
    private static double wallsAGPowInterval = 1.0;
    private static double enemyAGPowMin = 2.0;
    private static double enemyAGPowMax = 3.0;
    private static double enemyAGPowInterval = 1.0;
    private static double bulletAGPowMin = 0.0;
    private static double bulletAGPowMax = 1.0;
    private static double bulletAGPowInterval = 1.0;
    private static long round_count_per_static = 10L;
    private static double GRAVITY_SQUARE_FREQUENCY = 24.0;
    private static double midpointAGPower = 1000.0;
    private static double quadrantAGPower = 10000.0;
    private static double wallsAGPower = -100000.0;
    private static double enemyAGPower = -10000.0;
    private static double bulletAGPower = 0.0;
    private static double midpointAGPow = 1.8;
    private static double quadrantAGPow = 1.0;
    private static double wallsAGPow = 2.7;
    private static double enemyAGPow = 2.0;
    private static double bulletAGPow = 1.0;
    private static double angularyAGPower = -1000.0;
    private static double angularyAGPow = 2.0;
    private static double headOnAGPower = -2000.0;
    private static double headOnAGPow = 3.0;
    private static int roundCount;
    private static int battleCount;
    private static long passed_tick_for_round;
    private static boolean incrementedBattles;
    private static double oldEnemyHeading;
    private static double[] numTargetingWins;
    private static double[] numTargetingPos;
    private static double[] numTargetingGames;
    private static int TargetingStrategy;
    private static int MovingStrategy;
    private static int SampleEnemyRobotRoundCounter;
    private static int SampleEnemyRobotDetector;
    double previousEnergy = 100.0;
    double changeInEnergy;
    int movementDirection = 50;
    long lastTime;
    Random generator = new Random();
    ArrayList<VirtualBullet> bullets = new ArrayList();
    VirtualBullet newBullet;
    VirtualBullet bullet;
    VirtualBullet bulletTrajectory;
    static int index;
    private static final int PATTERN_MATCH_VALUE = 50000;
    static double[] ev;
    static StringBuffer pattern;
    private static final int NUM_LOGS = 5;
    private static final int PATTERN_LENGTH = 9000;
    private static int searchLength;
    private static int PatternSize;
    private static double[][] TheLog;
    private static int Cursor;
    private Point2D EnemyLocation;
    private double EnemyDistance;
    private static double LastEnemyReading;
    private static double lastEnemyEnergy;
    private static double EnemyBulletPower;
    private static double EnergyDrop;
    private static int CLOSEST_SIZE;
    private static double MAX_ESCAPE_ANGLE;
    private static double MaxX;
    private static double MaxY;
    private static double EnemyLastX;
    private static double EnemyLastY;
    private static double MinervaLastX;
    private static double MinervaLastY;
    Hashtable<String, Enemy> targets;
    Enemy target;
    Enemy scannedEnemy;
    double midpointstrength = 0.0;
    double angularyEscStrength = 0.0;
    int midpointcount = 0;
    int bulletpredictioncount = 0;
    int escCount = 0;
    int quadrantCount = 0;
    int angularyEscCount = 0;
    private static double[] BulletPowerFireCount;
    private static double[] BulletPowerHitCount;
    private static int scannedX;
    private static int scannedY;
    private static double DrawEscapeX;
    private static double DrawEscapeY;
    private static double EscapeDensity;
    private static double[] DrawHeadOnX;
    private static double[] DrawHeadOnY;
    private static int DrawHeadOnCount;
    private static double[] DrawBulletStartX;
    private static double[] DrawBulletStartY;
    private static double MiddleDensity;
    double angularyEscDistance = 75.0;
    double BattleFieldWidth;
    double BattleFieldHeight;
    double escGravpointX;
    double escGravpointY;
    private static int POS_QUEUE_SIZE;
    private static int MAX_QUADRANT_COUNT;
    private static int MAX_ESCAPE_COUNT;
    ArrayList<Double> posXQueue = new ArrayList();
    ArrayList<Double> posYQueue = new ArrayList();
    private static int posIndex;
    private static double escPosX;
    private static double escPosY;
    private static double ESCAPE_FORCE;
    private static double escAngle;
    private static int MINIMUM_POS_DIFF;
    private static double quadrantX;
    private static double quadrantY;
    private static double antiGravXForce;
    private static double antiGravYForce;

    static {
        incrementedBattles = false;
        numTargetingWins = new double[3];
        numTargetingPos = new double[3];
        numTargetingGames = new double[3];
        TargetingStrategy = 0;
        MovingStrategy = 0;
        SampleEnemyRobotRoundCounter = 0;
        SampleEnemyRobotDetector = 0;
        ev = new double[50000];
        pattern = new StringBuffer();
        searchLength = 20;
        PatternSize = 0;
        TheLog = new double[9000][5];
        Cursor = 0;
        LastEnemyReading = 0.0;
        EnemyBulletPower = 0.1;
        EnergyDrop = 0.0;
        CLOSEST_SIZE = 50;
        MAX_ESCAPE_ANGLE = 0.9;
        BulletPowerFireCount = new double[4];
        BulletPowerHitCount = new double[4];
        DrawHeadOnX = new double[10];
        DrawHeadOnY = new double[10];
        DrawBulletStartX = new double[10];
        DrawBulletStartY = new double[10];
        POS_QUEUE_SIZE = 7;
        MAX_QUADRANT_COUNT = 20;
        MAX_ESCAPE_COUNT = 20;
        ESCAPE_FORCE = -1000000.0;
        escAngle = 0.0;
        MINIMUM_POS_DIFF = 6;
    }

    public void run() {
        this.targets = new Hashtable();
        this.target = new Enemy();
        this.target.distance = 100000.0;
        this.setMaxVelocity(8.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.BattleFieldWidth = this.getBattleFieldWidth();
        this.BattleFieldHeight = this.getBattleFieldHeight();
        MaxX = this.BattleFieldWidth - 18.0;
        MaxY = this.BattleFieldHeight - 18.0;
        int i = 0;
        while (i < POS_QUEUE_SIZE) {
            this.posXQueue.add(i % POS_QUEUE_SIZE, 10.0 * (double)i);
            this.posYQueue.add(i % POS_QUEUE_SIZE, 10.0 * (double)i);
            ++i;
        }
        while (true) {
            this.scan();
            this.move();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        int n = (int)e.getBullet().getPower();
        BulletPowerHitCount[n] = BulletPowerHitCount[n] + 1.0;
        this.previousEnergy -= 4.0 * e.getBullet().getPower() + Math.max(0.0, 2.0 * (e.getBullet().getPower() - 1.0));
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    public void onBulletMissed(BulletMissedEvent event) {
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.previousEnergy += 3.0 * event.getBullet().getPower();
    }

    public void onHitRobot(HitRobotEvent event) {
        this.previousEnergy -= 0.6;
    }

    public void onHitWall(HitWallEvent event) {
        this.movementDirection = -this.movementDirection;
        this.out.println("MINERVA HITS TO WALL");
    }

    public void onKeyPressed(KeyEvent e) {
    }

    public void onKeyReleased(KeyEvent e) {
    }

    public void onKeyTyped(KeyEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (this.scannedEnemy == this.targets.get(event.getName())) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onStatus(StatusEvent e) {
    }

    public void onWin(WinEvent e) {
        if (++SampleEnemyRobotRoundCounter == 3 && SampleEnemyRobotDetector != -1) {
            SampleEnemyRobotDetector = 1;
        }
    }

    public void onDeath(DeathEvent e) {
        SampleEnemyRobotDetector = -1;
        if (++SampleEnemyRobotRoundCounter == 3 && SampleEnemyRobotDetector != -1) {
            SampleEnemyRobotDetector = 1;
        }
    }

    public void onRoundEnded(RoundEndedEvent event) {
        passed_tick_for_round = this.getTime();
    }

    public void onBattleEnded(BattleEndedEvent event) {
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        if (this.targets.containsKey(e.getName())) {
            this.scannedEnemy = this.targets.get(e.getName());
        } else {
            this.scannedEnemy = new Enemy();
            this.targets.put(e.getName(), this.scannedEnemy);
        }
        double AbsBearingRad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        this.scannedEnemy.name = e.getName();
        double h = this.normaliseBearing(e.getHeadingRadians() - this.scannedEnemy.heading);
        this.scannedEnemy.changehead = h /= (double)(this.getTime() - this.scannedEnemy.ctime);
        this.scannedEnemy.x = this.getX() + Math.sin(AbsBearingRad) * e.getDistance();
        this.scannedEnemy.y = this.getY() + Math.cos(AbsBearingRad) * e.getDistance();
        this.scannedEnemy.bearing = e.getBearingRadians();
        this.scannedEnemy.heading = e.getHeadingRadians();
        this.scannedEnemy.ctime = this.getTime();
        this.scannedEnemy.speed = e.getVelocity();
        this.scannedEnemy.distance = e.getDistance();
        this.scannedEnemy.live = true;
        if (this.scannedEnemy.distance < this.target.distance || !this.target.live) {
            this.target = this.scannedEnemy;
        }
        double absoluteBearing = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        EnemyLastX = this.getX() + Math.sin(absoluteBearing) * e.getDistance();
        EnemyLastY = this.getY() + Math.cos(absoluteBearing) * e.getDistance();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.chooseTargetingStrategy(e);
        double angle = Math.toRadians((this.getHeading() + e.getBearing()) % 360.0);
        scannedX = (int)(this.getX() + Math.sin(angle) * e.getDistance());
        scannedY = (int)(this.getY() + Math.cos(angle) * e.getDistance());
        this.previousEnergy = e.getEnergy();
        this.changeInEnergy = this.previousEnergy - this.previousEnergy;
        if (d > 0.0 && this.changeInEnergy <= 3.0) {
            this.newBullet = new VirtualBullet(this.scannedEnemy.x, this.scannedEnemy.y, 20.0 - 3.0 * this.changeInEnergy, Utils.normalRelativeAngle((double)(absoluteBearing + Math.PI + Math.asin(Math.sin(e.getBearingRadians()) * this.getVelocity() / (20.0 - 3.0 * this.changeInEnergy)))));
            this.bullets.add(this.newBullet);
        }
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            this.bullet.tick(this.getTime() - this.lastTime);
            this.bullets.set(i, this.bullet);
            if (this.bullets.get(i).checkCollide(this.getX(), this.getY())) {
                this.bullets.remove(i--);
            }
            ++i;
        }
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.lastTime = this.getTime();
    }

    public void PatternMatch1(ScannedRobotEvent e) {
        double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Math.sin(targetBearing - this.getRadarHeadingRadians()));
        int pt = (int)(e.getVelocity() * Math.sin(e.getHeadingRadians() - targetBearing));
        Minerva.ev[++Minerva.index] = ev[index - 1] + (double)pt;
        pattern.append((char)pt);
        int len = 30;
        while (--len * (pt = pattern.lastIndexOf(pattern.substring(Math.max(pattern.length() - len, 0)), pattern.length() - 100)) < -1) {
        }
        this.setTurnGunRightRadians(Math.sin((ev[Math.min((pt += len) + (int)e.getDistance() / 11, index)] - ev[pt]) / e.getDistance() + targetBearing - this.getGunHeadingRadians()) + 1.0 * Math.random() * 2.0 * Math.PI / 360.0);
        int n = (int)this.firePower(e);
        BulletPowerFireCount[n] = BulletPowerFireCount[n] + 1.0;
        this.setFire(this.firePower(e));
    }

    public void PatternMatch2(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this.EnemyLocation = new Point2D.Double(this.getX(), this.getY());
        this.EnemyDistance = e.getDistance();
        EnergyDrop = lastEnemyEnergy - e.getEnergy();
        if (EnergyDrop >= 0.1 && EnergyDrop <= 3.0) {
            EnemyBulletPower = EnergyDrop;
        }
        double bulletPower = EnemyBulletPower;
        bulletPower = Math.min(bulletPower, e.getEnergy() / 5.0);
        bulletPower = Minerva.limit(0.1, bulletPower, 3.0);
        if (this.getEnergy() > bulletPower && this.getGunHeat() / this.getGunCoolingRate() < 3.0 && this.getGunTurnRemainingRadians() == 0.0) {
            double BearingOffset = this.bestBearing(TheLog, e, bulletPower, absBearing);
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + BearingOffset - this.getGunHeadingRadians() + (Math.random() - 0.5) * 2.0 * Math.PI / 360.0)));
            int n = (int)bulletPower;
            BulletPowerFireCount[n] = BulletPowerFireCount[n] + 1.0;
            this.setFire(bulletPower);
        }
        Minerva.TheLog[Minerva.Cursor][0] = e.getVelocity();
        Minerva.TheLog[Minerva.Cursor][1] = e.getHeadingRadians() - LastEnemyReading;
        Cursor = (Cursor + 1) % 9000;
        if (PatternSize < 9000) {
            ++PatternSize;
        }
        LastEnemyReading = e.getHeadingRadians();
        lastEnemyEnergy = e.getEnergy();
    }

    private double bestBearing(double[][] Series, ScannedRobotEvent e, double bulletPower, double absbearing) {
        int[] closestIndex = new int[CLOSEST_SIZE];
        double[] closestDiff = new double[CLOSEST_SIZE];
        double[] angles = new double[CLOSEST_SIZE];
        int count = 0;
        double BulletSpeed = 20.0 - 3.0 * bulletPower;
        double BulletTravelTime = this.EnemyDistance / BulletSpeed;
        int c = 0;
        while (c < CLOSEST_SIZE) {
            closestDiff[c] = Double.POSITIVE_INFINITY;
            ++c;
        }
        int i = (9000 + Cursor - 1) % 9000;
        while (count < 9000) {
            double Diff = 0.0;
            int j = 0;
            while (j < searchLength) {
                int k = (i + j) % 9000;
                int SearchIndex = (9000 + Cursor - searchLength + j) % 9000;
                if (k == SearchIndex) {
                    Diff = Double.POSITIVE_INFINITY;
                    break;
                }
                Diff += Math.abs(Series[SearchIndex][0] - Series[k][0]) / 8.0;
                Diff += Math.abs(Series[SearchIndex][1] - Series[k][1]) / Rules.MAX_TURN_RATE_RADIANS;
                ++j;
            }
            int MaxDiffIndex = 0;
            c = 0;
            while (c < CLOSEST_SIZE) {
                if (closestDiff[c] > closestDiff[MaxDiffIndex]) {
                    MaxDiffIndex = c;
                }
                ++c;
            }
            if (Diff < closestDiff[MaxDiffIndex] && (double)Math.abs((i + searchLength) % 9000 - Cursor) > BulletTravelTime) {
                closestDiff[MaxDiffIndex] = Diff;
                closestIndex[MaxDiffIndex] = (i + searchLength) % 9000;
            }
            ++count;
            i = (9000 + i - 1) % 9000;
        }
        double InitialEX = this.EnemyDistance * Math.sin(absbearing);
        double InitialEY = this.EnemyDistance * Math.cos(absbearing);
        double eV = e.getVelocity();
        c = 0;
        while (c < CLOSEST_SIZE) {
            double eX = InitialEX;
            double eY = InitialEY;
            double ww = e.getHeadingRadians();
            double v = eV;
            double db = 0.0;
            int index = closestIndex[c];
            while ((db += BulletSpeed) < Point2D.distance(0.0, 0.0, eX += (v = TheLog[index][0]) * Math.sin(ww += TheLog[index = (index + 1) % 9000][1]), eY += v * Math.cos(ww))) {
            }
            double AbsoluteEX = Minerva.limit(18.0, eX + this.EnemyLocation.getX(), MaxX);
            double AbsoluteEY = Minerva.limit(18.0, eY + this.EnemyLocation.getY(), MaxY);
            angles[c] = Utils.normalRelativeAngle((double)(Math.atan2(AbsoluteEX - this.EnemyLocation.getX(), AbsoluteEY - this.EnemyLocation.getY()) - absbearing));
            ++c;
        }
        double AngleThreshHold = 36.0 / e.getDistance();
        int BinSize = (int)(MAX_ESCAPE_ANGLE * 2.0 / AngleThreshHold) + 1;
        int[] StatBin = new int[BinSize];
        double[] MetaAngle = new double[BinSize];
        c = 0;
        while (c < CLOSEST_SIZE) {
            int BinIndex = (int)((angles[c] + MAX_ESCAPE_ANGLE) / AngleThreshHold);
            MetaAngle[BinIndex] = angles[c];
            int n = BinIndex;
            StatBin[n] = StatBin[n] + 1;
            ++c;
        }
        int MaxIndex = 0;
        c = 0;
        while (c < BinSize) {
            if (StatBin[c] > StatBin[MaxIndex]) {
                MaxIndex = c;
            }
            ++c;
        }
        return MetaAngle[MaxIndex];
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public double firePower(ScannedRobotEvent e) {
        double bulletPower = 0.1;
        bulletPower = e.getDistance() < 400.0 ? 3.0 : (e.getDistance() < 500.0 ? 3.0 - (e.getDistance() - 400.0) / 40.0 : 0.5);
        return bulletPower;
    }

    public void move() {
        MovingStrategy = 0;
        this.posXQueue.add(posIndex % POS_QUEUE_SIZE, this.getX());
        this.posYQueue.add(posIndex % POS_QUEUE_SIZE, this.getY());
        ++posIndex;
        if (MovingStrategy == 0) {
            this.antiGravMove();
        } else if (MovingStrategy == 1) {
            this.basicMove();
        }
    }

    double absoluteBearingRadians(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.asin(xo / hyp);
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = Math.PI * 2 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = Math.PI - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = Math.PI - arcSin;
        }
        return bearing;
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void randomTargeting(ScannedRobotEvent e) {
        double targetAngle = this.getHeadingRadians() + e.getBearingRadians();
        double bulletPower = Math.max(0.1, Math.random() * 3.0);
        double escapeAngle = Math.asin(8.0 / Rules.getBulletSpeed((double)bulletPower));
        double randomAimOffset = -escapeAngle + Math.random() * 2.0 * escapeAngle;
        double headOnTargeting = targetAngle - this.getGunHeadingRadians();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(headOnTargeting + randomAimOffset)));
        this.setFire(bulletPower);
    }

    public void linearTargeting(ScannedRobotEvent e) {
        double bulletPower = this.firePower(e);
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double deltaTime = 0.0;
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > this.BattleFieldWidth - 18.0) && !(predictedY > this.BattleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), this.BattleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), this.BattleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        int n = (int)bulletPower;
        BulletPowerFireCount[n] = BulletPowerFireCount[n] + 1.0;
        this.setFire(bulletPower);
    }

    public void circularTargeting(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        if (absoluteBearing < 0.0) {
            absoluteBearing += Math.PI * 2;
        }
        double myX = this.getX();
        double myY = this.getY();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - oldEnemyHeading;
        double enemyVelocity = e.getVelocity();
        oldEnemyHeading = enemyHeading;
        double firePowerVal = Math.min(500.0 / e.getDistance(), 3.0);
        double deltaTime = 0.0;
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * firePowerVal) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > this.BattleFieldWidth - 18.0) && !(predictedY > this.BattleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), this.BattleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), this.BattleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        int n = (int)firePowerVal;
        BulletPowerFireCount[n] = BulletPowerFireCount[n] + 1.0;
        this.setFire(firePowerVal);
    }

    public void chooseTargetingStrategy(ScannedRobotEvent e) {
        double totalGames = 0.0;
        Math.random();
        int i = 0;
        while (i < 3) {
            totalGames += numTargetingGames[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            Minerva.numTargetingPos[i] = Math.random() + totalGames * Math.random();
            if (numTargetingGames[i] != 0.0) {
                int n = i;
                numTargetingPos[n] = numTargetingPos[n] + numTargetingWins[i] / numTargetingGames[i] * (totalGames * Math.random()) / (totalGames - numTargetingWins[i]);
            }
            ++i;
        }
        double largest = 0.0;
        int i2 = 0;
        while (i2 < numTargetingPos.length) {
            if (numTargetingPos[i2] >= largest) {
                largest = numTargetingPos[i2];
            }
            ++i2;
        }
        TargetingStrategy = e.getDistance() < 200.0 ? 0 : 3;
        if (TargetingStrategy == 0) {
            this.linearTargeting(e);
        } else if (TargetingStrategy == 1) {
            this.circularTargeting(e);
        } else if (TargetingStrategy == 2) {
            this.PatternMatch1(e);
        } else if (TargetingStrategy == 3) {
            this.PatternMatch2(e);
        }
    }

    void antiGravMove() {
        MinervaLastX = this.getX();
        MinervaLastY = this.getY();
        this.antiGravCalculate(MinervaLastX, MinervaLastY, true);
        this.goTo(MinervaLastX - antiGravXForce, MinervaLastY - antiGravYForce);
    }

    void antiGravCalculate(double AntiGravX, double AntiGravY, boolean moveFlag) {
        double ang;
        double force;
        GravPoint p;
        double xforce = 0.0;
        double yforce = 0.0;
        Enumeration<Enemy> e = this.targets.elements();
        double pX = 0.0;
        double pY = 0.0;
        while (e.hasMoreElements()) {
            Enemy en = e.nextElement();
            if (!en.live) continue;
            p = new GravPoint(en.x, en.y, (int)enemyAGPower);
            force = p.power / Math.pow(this.getRange(AntiGravX, AntiGravY, p.x, p.y), enemyAGPow);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(AntiGravY - p.y, AntiGravX - p.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        if (moveFlag) {
            double minValX = this.posXQueue.get(0);
            double minValY = this.posYQueue.get(0);
            double maxValX = this.posXQueue.get(0);
            double maxValY = this.posYQueue.get(0);
            int i = 0;
            while (i < POS_QUEUE_SIZE) {
                if (this.posXQueue.get(i) < minValX) {
                    minValX = this.posXQueue.get(i);
                }
                if (this.posYQueue.get(i) < minValY) {
                    minValY = this.posYQueue.get(i);
                }
                if (this.posXQueue.get(i) > maxValX) {
                    maxValX = this.posXQueue.get(i);
                }
                if (this.posYQueue.get(i) > maxValY) {
                    maxValY = this.posYQueue.get(i);
                }
                ++i;
            }
            if (this.escCount == 0) {
                double distanceX = 0.0;
                double distanceY = 0.0;
                if (maxValX - minValX < (double)MINIMUM_POS_DIFF && maxValY - minValY < (double)MINIMUM_POS_DIFF) {
                    this.escCount = MAX_ESCAPE_COUNT;
                }
                if (Math.abs(EnemyLastX - MinervaLastX) > Math.abs(EnemyLastY - MinervaLastY)) {
                    if (this.BattleFieldHeight / 2.0 < MinervaLastY) {
                        escAngle = Math.PI;
                        escPosX = MinervaLastX;
                        escPosY = 0.0;
                    } else {
                        escAngle = 0.0;
                        escPosX = MinervaLastX;
                        escPosY = this.BattleFieldHeight;
                    }
                } else if (this.BattleFieldWidth / 2.0 < MinervaLastX) {
                    escAngle = 4.71238898038469;
                    escPosX = 0.0;
                    escPosY = MinervaLastY;
                } else {
                    escAngle = 1.5707963267948966;
                    escPosX = this.BattleFieldWidth;
                    escPosY = MinervaLastY;
                }
            }
            if (this.escCount > 0) {
                xforce += ESCAPE_FORCE * Math.sin(escAngle);
                yforce += ESCAPE_FORCE * Math.cos(escAngle);
                --this.escCount;
            }
        }
        if (moveFlag) {
            ++this.midpointcount;
            if (this.midpointcount > 5) {
                this.midpointcount = 0;
                this.midpointstrength = Math.random() * (double)(2 * (int)midpointAGPower) - (double)((int)midpointAGPower);
            }
        }
        MiddleDensity = -1.0 * this.midpointstrength;
        p = new GravPoint(this.BattleFieldWidth / 2.0, this.BattleFieldHeight / 2.0, this.midpointstrength);
        force = p.power / Math.pow(this.getRange(AntiGravX, AntiGravY, p.x, p.y), midpointAGPow);
        ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(AntiGravY - p.y, AntiGravX - p.x));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        xforce -= (double)((int)wallsAGPower) / Math.pow(this.getRange(AntiGravX, AntiGravY, this.BattleFieldWidth, AntiGravY), wallsAGPow);
        xforce += (double)((int)wallsAGPower) / Math.pow(this.getRange(AntiGravX, AntiGravY, 0.0, AntiGravY), wallsAGPow);
        yforce -= (double)((int)wallsAGPower) / Math.pow(this.getRange(AntiGravX, AntiGravY, AntiGravX, this.BattleFieldHeight), wallsAGPow);
        yforce += (double)((int)wallsAGPower) / Math.pow(this.getRange(AntiGravX, AntiGravY, AntiGravX, 0.0), wallsAGPow);
        this.escGravpointX = -1.0;
        this.escGravpointY = -1.0;
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            double bulletDistance = this.getRange(MinervaLastX, MinervaLastY, this.bullet.getX(), this.bullet.getY());
            if (bulletDistance < this.bullet.speed * 20.0) {
                double angle = 1.5707963267948966;
                double escGravpointX1 = MinervaLastX + Math.sin((angle += this.absoluteBearingRadians(scannedX, scannedY, MinervaLastX, MinervaLastY)) % (Math.PI * 2)) * this.angularyEscDistance;
                double escGravpointY1 = MinervaLastY + Math.cos(angle % (Math.PI * 2)) * this.angularyEscDistance;
                double escGravpointX2 = MinervaLastX + Math.sin(angle % (Math.PI * 2)) * this.angularyEscDistance * -1.0;
                double escGravpointY2 = MinervaLastY + Math.cos(angle % (Math.PI * 2)) * this.angularyEscDistance * -1.0;
                double d1 = this.getRange(escGravpointX1, escGravpointY1, this.bullet.getX(), this.bullet.getY());
                double d2 = this.getRange(escGravpointX2, escGravpointY2, this.bullet.getX(), this.bullet.getY());
                if (d2 < d1) {
                    this.escGravpointX = escGravpointX2;
                    this.escGravpointY = escGravpointY2;
                } else {
                    this.escGravpointX = escGravpointX1;
                    this.escGravpointY = escGravpointY1;
                }
                p = new GravPoint(this.escGravpointX, this.escGravpointY, angularyAGPower);
                force = p.power / Math.pow(this.getRange(AntiGravX, AntiGravY, p.x, p.y), angularyAGPow);
                ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(AntiGravY - p.y, AntiGravX - p.x));
                xforce += Math.sin(ang) * force;
                yforce += Math.cos(ang) * force;
            }
            if (moveFlag) {
                DrawHeadOnCount = 0;
                int j = 0;
                while (j < this.bullets.size()) {
                    this.bullet = this.bullets.get(j);
                    ++this.bulletpredictioncount;
                    Minerva.DrawHeadOnX[Minerva.DrawHeadOnCount] = this.bullet.HeadOnX;
                    Minerva.DrawHeadOnY[Minerva.DrawHeadOnCount] = this.bullet.HeadOnY;
                    Minerva.DrawBulletStartX[Minerva.DrawHeadOnCount] = this.bullet.getStartX();
                    Minerva.DrawBulletStartY[Minerva.DrawHeadOnCount] = this.bullet.getStartY();
                    ++DrawHeadOnCount;
                    ++j;
                }
            }
            boolean printFlag = true;
            double angleHeadOn = this.absbearing(this.bullet.getStartX(), this.bullet.getStartY(), this.bullet.HeadOnX, this.bullet.HeadOnY);
            double XX = this.bullet.getStartX();
            double YY = this.bullet.getStartY();
            while (XX > 0.0 && XX < this.BattleFieldWidth && YY > 0.0 && YY < this.BattleFieldHeight) {
                p = new GravPoint(XX += this.bullet.speed * Math.sin(angleHeadOn), YY += this.bullet.speed * Math.cos(angleHeadOn), (int)headOnAGPower);
                force = p.power / Math.pow(this.getRange(AntiGravX, AntiGravY, p.x, p.y), headOnAGPow);
                ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(AntiGravY - p.y, AntiGravX - p.x));
                xforce += Math.sin(ang) * force;
                yforce += Math.cos(ang) * force;
                printFlag = false;
            }
            ++i;
        }
        antiGravXForce = xforce;
        antiGravYForce = yforce;
        if (moveFlag) {
            this.out.println("XFORCE: " + antiGravXForce + "\t\tYFORCE: " + antiGravYForce);
        }
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (h == 0.0) {
            h = 0.01;
        }
        return h;
    }

    public int findQuadrant(double x, double y) {
        double width = this.BattleFieldWidth / 2.0;
        double height = this.BattleFieldHeight / 2.0;
        int returnval = 0;
        if (x <= width && y <= height) {
            returnval = 0;
        } else if (x <= width && y > height) {
            returnval = 1;
        } else if (x > width && y > height) {
            returnval = 2;
        } else if (x > width && y <= height) {
            returnval = 3;
        }
        return returnval;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void basicMove() {
        this.ahead(560.0);
        this.turnRightRadians(1.5707963267948966);
    }

    private void restoreData() {
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.getDataFile("minerva.dat")));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            roundCount = 0;
            battleCount = 0;
        }
        catch (NumberFormatException e) {
            roundCount = 0;
            battleCount = 0;
        }
        ++roundCount;
    }

    private void saveData() {
        block16: {
            if (!incrementedBattles) {
                ++battleCount;
                incrementedBattles = true;
            }
            RobocodeFileWriter t = null;
            try {
                try {
                    t = new RobocodeFileWriter(this.getDataFile("minerva.dat").getAbsolutePath().toString(), true);
                    if (0L == this.getDataFile("minerva.dat").length()) {
                        t.append((CharSequence)"MIDPOINT\t\tMID-MIDPOINT\t\tWALLS\t\t\tENEMY\t\t\t\tBULLET\t\tSURVIVAL\t\tROUND NO\t\tBATTLE NO\t\t\n");
                    }
                    t.append((CharSequence)(String.valueOf(midpointAGPower) + "/" + midpointAGPow + "\t\t" + quadrantAGPower + "/" + quadrantAGPow + "\t\t\t" + wallsAGPower + "/" + wallsAGPow + "\t\t" + enemyAGPower + "/" + enemyAGPow + "\t\t" + bulletAGPower + "/" + bulletAGPow + "\t\t" + passed_tick_for_round + "\t\t\t\t" + roundCount + "\t\t\t\t" + battleCount + "\n"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (t != null) {
                    try {
                        t.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (t != null) {
                try {
                    t.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.out.println("MINERVA LOG: " + roundCount + " rounds, in " + battleCount + " battles.");
    }

    public void onPaint(Graphics2D g) {
        Enumeration<Enemy> e = this.targets.elements();
        while (e.hasMoreElements()) {
            Enemy gp = e.nextElement();
            g.drawOval((int)gp.x - 5, (int)gp.y - 5, 10, 10);
        }
        g.setColor(new Color(255, 0, 0, 128));
        g.setStroke(new BasicStroke(3.0f));
        double angle = 1.5707963267948966;
        this.drawAntiGravityPoints(g, this.escGravpointX, this.escGravpointY, 1000.0, 0, 10);
        int i = 0;
        while (i < DrawHeadOnCount) {
            g.drawLine((int)DrawBulletStartX[i], (int)DrawBulletStartY[i], (int)DrawHeadOnX[i], (int)DrawHeadOnY[i]);
            ++i;
        }
        g.setColor(new Color(0, 255, 255, 128));
        if (this.escCount > 0) {
            g.drawLine((int)escPosX, (int)escPosY, (int)MinervaLastX, (int)MinervaLastY);
        }
        g.setColor(new Color(255, 0, 0, 128));
        this.drawAntiGravityPoints(g, this.BattleFieldWidth / 2.0, this.BattleFieldHeight / 2.0, MiddleDensity, 0, 10);
        this.drawAntiGravityPoints(g, DrawEscapeX, DrawEscapeY, EscapeDensity, 0, 10);
        int strength = -255;
        int ix = (int)(GRAVITY_SQUARE_FREQUENCY / 2.0);
        while ((double)ix < this.BattleFieldWidth) {
            int iy = (int)this.BattleFieldHeight - (int)(GRAVITY_SQUARE_FREQUENCY / 2.0);
            while (iy > 0) {
                this.antiGravCalculate(ix, iy, false);
                strength = (int)Math.sqrt(Math.pow(antiGravXForce, 2.0) + Math.pow(antiGravYForce, 2.0));
                double a = -12.0 * Math.cos(Math.atan2(antiGravYForce, antiGravXForce));
                double b = -12.0 * Math.sin(Math.atan2(antiGravYForce, antiGravXForce));
                Point fromPt = new Point(ix - (int)a, iy - (int)b);
                Point toPt = new Point(ix + (int)a, iy + (int)b);
                Shape s = Minerva.createArrowShape(fromPt, toPt);
                g.fill(s);
                iy -= (int)GRAVITY_SQUARE_FREQUENCY;
            }
            ix += (int)GRAVITY_SQUARE_FREQUENCY;
        }
        this.drawBulletPredictions(g);
    }

    public void drawBulletPredictions(Graphics2D g) {
        g.setColor(new Color(255, 255, 0));
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            g.fillOval((int)this.bullet.getX() - 3, (int)this.bullet.getY() - 3, 6, 6);
            ++i;
        }
        if (EnemyLastX == -1.0 && EnemyLastY == -1.0) {
            g.setColor(Color.green);
            g.drawString("No target", (int)this.BattleFieldWidth / 80, (int)this.BattleFieldHeight / 60);
        } else {
            g.setColor(new Color(255, 96, 0));
            g.drawString("Target locked", (int)this.BattleFieldWidth / 80, (int)this.BattleFieldHeight / 60);
            g.setColor(new Color(255, 32, 0));
            g.drawRect((int)EnemyLastX - 30, (int)EnemyLastY - 30, 60, 60);
            g.drawRect((int)EnemyLastX - 10, (int)EnemyLastY - 10, 20, 20);
            g.setColor(new Color(255, 32, 0, 64));
            g.fillRect((int)EnemyLastX - 30, (int)EnemyLastY - 30, 60, 60);
        }
    }

    public void drawAntiGravityPoints(Graphics2D t, double x, double y, double density, int strength, int len) {
        if (density <= 0.0) {
            t.setColor(new Color(0, 255, 0, 128));
        } else if (density > 0.0) {
            t.setColor(new Color(255, 0, 0, 128));
        }
        t.fillRoundRect((int)(x - (double)len), (int)(y - (double)len), 2 * len, 2 * len, (int)GRAVITY_SQUARE_FREQUENCY, (int)GRAVITY_SQUARE_FREQUENCY);
    }

    public static Shape createArrowShape(Point fromPt, Point toPt) {
        Polygon arrowPolygon = new Polygon();
        arrowPolygon.addPoint(-6, 1);
        arrowPolygon.addPoint(3, 1);
        arrowPolygon.addPoint(3, 3);
        arrowPolygon.addPoint(6, 0);
        arrowPolygon.addPoint(3, -3);
        arrowPolygon.addPoint(3, -1);
        arrowPolygon.addPoint(-6, -1);
        Point midPoint = new Point((int)((double)(fromPt.x + toPt.x) / 2.0), (int)((double)(fromPt.y + toPt.y) / 2.0));
        double rotate = Math.atan2(toPt.y - fromPt.y, toPt.x - fromPt.x);
        AffineTransform transform = new AffineTransform();
        transform.translate(midPoint.x, midPoint.y);
        double ptDistance = fromPt.distance(toPt);
        double scale = ptDistance / 12.0;
        transform.scale(scale, scale);
        transform.rotate(rotate);
        return transform.createTransformedShape(arrowPolygon);
    }

    public void setAntiGravityPowerValues() {
        boolean found = false;
        double i = midpointAGPowerMin;
        while (i <= midpointAGPowerMax) {
            double j = quadrantAGPowerMin;
            while (j <= quadrantAGPowerMax) {
                double k = wallsAGPowerMin;
                while (k <= wallsAGPowerMax) {
                    double l = enemyAGPowerMin;
                    while (l <= enemyAGPowerMax) {
                        double m = bulletAGPowerMin;
                        while (m <= bulletAGPowerMax) {
                            double n = midpointAGPowMin;
                            while (n <= midpointAGPowMax) {
                                double p = quadrantAGPowMin;
                                while (p <= quadrantAGPowMax) {
                                    double q = wallsAGPowMin;
                                    while (q <= wallsAGPowMax) {
                                        double r = enemyAGPowMin;
                                        while (r <= enemyAGPowMax) {
                                            double s = bulletAGPowMin;
                                            while (s <= bulletAGPowMax) {
                                                if (found) {
                                                    midpointAGPower = i;
                                                    midpointAGPow = n;
                                                    quadrantAGPower = j;
                                                    quadrantAGPow = p;
                                                    wallsAGPower = k;
                                                    wallsAGPow = q;
                                                    enemyAGPower = l;
                                                    enemyAGPow = r;
                                                    bulletAGPower = m;
                                                    bulletAGPow = s;
                                                    break;
                                                }
                                                if (midpointAGPower == i && midpointAGPow == n && quadrantAGPower == j && quadrantAGPow == p && wallsAGPower == k && wallsAGPow == q && enemyAGPower == l && enemyAGPow == r && bulletAGPower == m && bulletAGPow == s) {
                                                    found = true;
                                                }
                                                s += bulletAGPowInterval;
                                            }
                                            r += enemyAGPowInterval;
                                        }
                                        q += wallsAGPowInterval;
                                    }
                                    p += quadrantAGPowInterval;
                                }
                                n += midpointAGPowInterval;
                            }
                            m += bulletAGPowerInterval;
                        }
                        l += enemyAGPowerInterval;
                    }
                    k += wallsAGPowerInterval;
                }
                j += quadrantAGPowerInterval;
            }
            i += midpointAGPowerInterval;
        }
        if (!found) {
            this.out.println("MINERVA LOG: ALL TESTS FINISHED");
        }
    }

    public void onMouseClicked(MouseEvent e) {
    }

    public void onMouseDragged(MouseEvent e) {
    }

    public void onMouseEntered(MouseEvent e) {
    }

    public void onMouseExited(MouseEvent e) {
    }

    public void onMouseMoved(MouseEvent e) {
    }

    public void onMousePressed(MouseEvent e) {
    }

    public void onMouseReleased(MouseEvent e) {
    }

    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    class Enemy {
        String name;
        public double bearing;
        public double heading;
        public double speed;
        public double x;
        public double y;
        public double distance;
        public double changehead;
        public long ctime;
        public boolean live;

        Enemy() {
        }

        public Point2D.Double guessPosition(long when) {
            double diff = when - this.ctime;
            double newY = this.y + Math.cos(this.heading) * this.speed * diff;
            double newX = this.x + Math.sin(this.heading) * this.speed * diff;
            return new Point2D.Double(newX, newY);
        }
    }

    class GravPoint {
        public double x;
        public double y;
        public double power;

        public GravPoint(double pX, double pY, double pPower) {
            this.x = pX;
            this.y = pY;
            this.power = pPower;
        }
    }

    public class VirtualBullet {
        double x;
        double y;
        double speed;
        double angle;
        double HeadOnX;
        double HeadOnY;
        double xStart;
        double yStart;

        VirtualBullet(double startX, double startY, double velocity, double trajectory) {
            this.xStart = this.x = startX;
            this.yStart = this.y = startY;
            this.speed = velocity;
            this.angle = trajectory;
            this.HeadOnX = MinervaLastX;
            this.HeadOnY = MinervaLastY;
        }

        public void tick(long ticks) {
            while (ticks > 0L) {
                this.x += Math.sin(this.angle) * this.speed;
                this.y += Math.cos(this.angle) * this.speed;
                --ticks;
            }
        }

        public double getStartX() {
            return this.xStart;
        }

        public double getStartY() {
            return this.yStart;
        }

        public double trajectoryX(long ticks) {
            return this.xStart + Math.sin(this.angle) * this.speed * (double)ticks;
        }

        public double trajectoryY(long ticks) {
            return this.yStart + Math.cos(this.angle) * this.speed * (double)ticks;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getDistance(double botX, double botY) {
            return Math.sqrt(Math.pow(botX - this.x, 2.0) + Math.pow(botY - this.y, 2.0));
        }

        public boolean checkCollide(double botX, double botY) {
            if (this.x < 0.0 || this.y < 0.0 || this.x > Minerva.this.BattleFieldWidth || this.y > Minerva.this.BattleFieldHeight) {
                return true;
            }
            return botX - 18.0 < this.x && botX + 18.0 > this.x && botY - 18.0 < this.y && botY + 18.0 > this.y;
        }

        public boolean checkCollideTrajectory(double posX, double posY) {
            return posX < 0.0 || posY < 0.0 || posX > Minerva.this.BattleFieldWidth * 0.8 || posY > Minerva.this.BattleFieldHeight * 0.8;
        }
    }
}

