/*
 * Decompiled with CFR 0.152.
 */
package lrem.micro;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class FalseProphet
extends AdvancedRobot {
    static final double comfortableDistance = 150.0;
    static final double movementOffset = 0.5235987755982988;
    static final double reverseChance = 0.4;
    static final double firePower = 2.0;
    static final double bulletSpeed = 14.0;
    static final int searchDepth = 250;
    static char[] history = new char[500000];
    static double[] lateralHistory = new double[500000];
    static int[] pattern = new int[250];
    static double lateralMove;
    static double bearing;
    static double absoluteBearing;
    static double distance;
    static double power;
    static double gunHeading;
    static double energy;
    static int bulletTime;
    static int bestFoundIndex;
    static int bestFoundLength;
    static int direction;
    static int index;
    static int m;
    static int k;
    static int q;
    static int i;

    public void run() {
        this.setColors(Color.white, Color.yellow, null);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        bearing = scannedRobotEvent.getBearingRadians();
        absoluteBearing = Utils.normalRelativeAngle((double)(bearing + this.getHeadingRadians()));
        distance = scannedRobotEvent.getDistance();
        power = energy - scannedRobotEvent.getEnergy();
        energy = scannedRobotEvent.getEnergy();
        bulletTime = (int)(distance / 14.0);
        gunHeading = this.getGunHeadingRadians();
        this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
        if (distance < 150.0) {
            this.setTurnRightRadians(bearing + 1.5707963267948966 + 0.5235987755982988 * (double)direction);
        } else {
            this.setTurnRightRadians(bearing + 1.5707963267948966 - 0.5235987755982988 * (double)direction);
        }
        if (distance < 75.0) {
            this.setAhead(direction * 100);
        } else if (0.0 < power && power <= 3.0) {
            if (Math.random() < 0.4) {
                direction *= -1;
            }
            this.setAhead((double)direction * (distance / 4.0 + 25.0));
        }
        lateralMove = scannedRobotEvent.getVelocity() * Math.sin(scannedRobotEvent.getHeadingRadians() - absoluteBearing);
        FalseProphet.lateralHistory[++FalseProphet.index] = lateralHistory[index - 1] + lateralMove;
        FalseProphet.history[FalseProphet.index] = (char)lateralMove;
        m = Math.min(249, index - bulletTime);
        if (4 < m) {
            k = 0;
            FalseProphet.pattern[0] = 0;
            bestFoundLength = 0;
            for (q = 2; q <= m; ++q) {
                while (k != 0 && history[index - k] != history[index - (q - 1)]) {
                    k = pattern[k];
                }
                if (history[index - k] == history[index - (q - 1)]) {
                    // empty if block
                }
                FalseProphet.pattern[FalseProphet.q] = ++k;
            }
            q = 0;
            for (i = m; i < index; ++i) {
                while (q != 0 && history[index - q] != history[index - i]) {
                    q = pattern[q];
                }
                if (history[index - q] == history[index - i]) {
                    q = (q + 1) % m;
                }
                if (bestFoundLength >= q) continue;
                bestFoundLength = q;
                bestFoundIndex = index - i + bestFoundLength;
            }
            this.setTurnGunRightRadians(Math.sin((lateralHistory[bestFoundIndex + (int)(distance / 14.0)] - lateralHistory[bestFoundIndex]) / distance + absoluteBearing - gunHeading));
            this.fire(2.0);
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        direction *= -1;
        this.setBack(this.getDistanceRemaining());
    }

    static {
        energy = 100.0;
        direction = 1;
        index = 0;
    }
}

