/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.antigravity;

import florent.XSeries.Configuration;
import florent.XSeries.movement.antigravity.GravEntity;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GravLine
extends GravEntity {
    private static final double STR_7 = 40.0;
    private static final double DOFF_7 = 2.0;
    private static final double STR_5 = 30.0;
    private static final double DOFF_5 = 2.0;
    private static final double STR_4 = 20.0;
    private static final double DOFF_4 = 2.0;
    public Line2D.Double line;
    private Point2D.Double localisation;
    public double strength = 30.0;
    public double dropOff = 2.0;
    public boolean LOS = false;

    public GravLine(Line2D.Double line) {
        this.line = line;
    }

    public String getKey() {
        return String.valueOf(this.getClass().getSimpleName()) + "|" + this.line.toString();
    }

    protected double getMagnitude(Point2D.Double location) {
        if (this.LOS) {
            this.strength = 0.0;
        } else if (Configuration.others > 6) {
            this.strength = 40.0;
            this.dropOff = 2.0;
        } else if (Configuration.others > 4) {
            this.strength = 30.0;
            this.dropOff = 2.0;
        } else {
            this.strength = 20.0;
            this.dropOff = 2.0;
        }
        return -this.strength / Math.pow(this.line.ptLineDist(location), this.dropOff);
    }

    public Force getForce(Point2D.Double location) {
        if (this.line.equals(Configuration.NorthWall)) {
            this.localisation = new Point2D.Double(location.x, Configuration.battleFieldHeigth);
        } else if (this.line.equals(Configuration.SouthWall)) {
            this.localisation = new Point2D.Double(location.x, 0.0);
        } else if (this.line.equals(Configuration.EastWall)) {
            this.localisation = new Point2D.Double(Configuration.battleFieldWidth, location.y);
        } else if (this.line.equals(Configuration.WestWall)) {
            this.localisation = new Point2D.Double(0.0, location.y);
        } else {
            double a1 = (this.line.y2 - this.line.y1) / (this.line.x2 - this.line.x1);
            double b1 = this.line.y1 - a1 * this.line.x1;
            double a2 = -1.0 / a1;
            double b2 = location.y - a2 * location.x;
            this.localisation = new Point2D.Double((b2 - b1) / (a1 - a2), a1 * (b2 - b1) / (a1 - a2) + b1);
        }
        double angle = RobocodeTools.absoluteBearing(location, this.localisation);
        double magnitude = this.getMagnitude(location);
        Point2D.Double end = new Point2D.Double(location.x + magnitude * Math.sin(angle), location.y + magnitude * Math.cos(angle));
        return new Force(location, end);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.ORANGE);
        Force force = this.getForce(new Point2D.Double(Configuration.me.getX(), Configuration.me.getY()));
        force.multiplyMagnitude(100000.0);
        force.translateTo(this.localisation);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        g.drawString(this.getKey(), (float)this.localisation.x, (float)(Configuration.battleFieldHeigth - this.localisation.y));
        if (this.LOS) {
            g.drawLine((int)this.line.x1, (int)(Configuration.battleFieldHeigth - this.line.y1), (int)this.line.x2, (int)(Configuration.battleFieldHeigth - this.line.y2));
        }
    }
}

