/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.decision;

import ghent.common.Target;
import ghent.modules.Module;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetChooser
extends Module {
    private static final double TOO_FAR_AWAY = 200.0;
    private Map<String, Target> _targets;
    private Map<String, Integer> _hitted;
    private Map<String, Integer> _hitme;
    private int _missed = 0;
    private Target _lastTarget;

    public TargetChooser(AdvancedRobot robot, Map<String, Target> targets) {
        super(robot);
        this._targets = targets;
        this._hitted = new HashMap<String, Integer>(10);
        this._hitme = new HashMap<String, Integer>(10);
    }

    public Target getLastTarget() {
        return this._lastTarget;
    }

    public void setLastTarget(Target _lastTarget) {
        this._lastTarget = _lastTarget;
    }

    public int getMissed() {
        return this._missed;
    }

    public String mostHitted() {
        String name = null;
        for (String s : this._hitted.keySet()) {
            if (!this._targets.containsKey(s)) continue;
            if (name == null) {
                name = s;
                continue;
            }
            if (this._hitted.get(s) <= this._hitted.get(name)) continue;
            name = s;
        }
        return name;
    }

    public Target chooseTarget() {
        if (this._targets == null || this._targets.size() < this._robot.getOthers()) {
            return null;
        }
        Target target = this.getTarget(200.0);
        if (target == null) {
            Target weakest = this.getWeakestTarget();
            target = weakest != null && weakest.getEnergy() == 0.0 ? weakest : this.getNearestTarget();
        }
        if (target != null && this._lastTarget != null && target != this._lastTarget) {
            double lastTargetDistance = this._lastTarget.getDistance(this.getRobotLocation());
            double newTargetDistance = target.getDistance(this.getRobotLocation());
            if (lastTargetDistance < 200.0 && this.similarDistance(newTargetDistance, lastTargetDistance) && this._lastTarget.getEnergy() <= target.getEnergy()) {
                target = this._lastTarget;
            }
        }
        return target;
    }

    private Target getNearestTarget() {
        Point2D robotLocation = this.getRobotLocation();
        double nearestTargetDistance = Double.POSITIVE_INFINITY;
        Target nearestTarget = null;
        for (Target t : this._targets.values()) {
            double tDistance = t.getDistance(robotLocation);
            if (nearestTarget != null && !(tDistance < nearestTargetDistance)) continue;
            nearestTarget = t;
            nearestTargetDistance = tDistance;
        }
        return nearestTarget;
    }

    private Target getWeakestTarget() {
        Target weakestTarget = null;
        for (Target t : this._targets.values()) {
            if (weakestTarget != null && !(t.getEnergy() < weakestTarget.getEnergy())) continue;
            weakestTarget = t;
        }
        return weakestTarget;
    }

    private Target getTarget(double tooFar) {
        Point2D robotLocation = this.getRobotLocation();
        Target target = null;
        double targetDistance = Double.POSITIVE_INFINITY;
        for (Target t : this._targets.values()) {
            double tDistance = t.getDistance(robotLocation);
            if (tDistance < tooFar) {
                if (target == null) {
                    target = t;
                } else if (this.similarDistance(tDistance, targetDistance) && t.getEnergy() < target.getEnergy()) {
                    target = t;
                } else if (tDistance < targetDistance) {
                    target = t;
                }
            }
            if (target != t) continue;
            targetDistance = tDistance;
        }
        return target;
    }

    private boolean similarDistance(double d1, double d2) {
        return Math.abs(d1 - d2) < 10.0;
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        this._missed = 0;
        String tName = event.getName();
        Integer count = null;
        count = this._hitted.containsKey(tName) ? this._hitted.get(tName) : Integer.valueOf(1);
        this._hitted.put(tName, count);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        String tName = event.getName();
        Integer count = null;
        count = this._hitme.containsKey(tName) ? this._hitme.get(tName) : Integer.valueOf(1);
        this._hitme.put(tName, count);
    }

    @Override
    public void onBulletMissed(BulletMissedEvent event) {
        ++this._missed;
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        if (this._lastTarget != null && this._lastTarget.getName().equals(event.getName())) {
            this._lastTarget = null;
        }
    }
}

