/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.geom.Point2D;
import java.util.Arrays;
import robocode.Rules;
import robocode.util.Utils;
import synapse.BulletCondition;
import synapse.Enemy;
import synapse.Util;

public class Wave
implements Comparable<Wave> {
    public final long ctime;
    public final long eta;
    public final Point2D.Double origin;
    public final double power;
    public final double velocity;
    public final double extent;
    public final double heading;
    public float guessFactor;
    public final int clockwise;
    public final int segmentation;
    public final int bestSegment;
    public final int[] indices;
    private boolean fired = false;
    private BulletCondition bulletCondition = BulletCondition.ARRIVING;

    public Wave(Enemy e, Point2D.Double oldOldLocation, int clockwise, int segmentation, int[] indices, int bestSegment) {
        this(e.location, oldOldLocation, e.ctime - 1L, e.energyDrop, clockwise, segmentation, indices, bestSegment);
    }

    public Wave(Point2D.Double origin, Point2D.Double target, long ctime, double power, int clockwise, int segmentation, int[] indices, int bestSegment) {
        this.origin = new Point2D.Double(origin.x, origin.y);
        this.power = power;
        this.velocity = Rules.getBulletSpeed((double)power);
        this.extent = 2.0 * Util.maxEscapeAngle(this.velocity);
        this.heading = Util.absoluteBearing(origin, target);
        this.ctime = ctime;
        this.eta = (int)((double)ctime + origin.distance(target) / this.velocity);
        this.clockwise = clockwise;
        this.segmentation = segmentation;
        this.indices = Arrays.copyOf(indices, indices.length);
        this.bestSegment = bestSegment;
    }

    @Override
    public int compareTo(Wave w) {
        return w.eta < this.eta ? 1 : (w.eta == this.eta ? 0 : -1);
    }

    public static double getGuessFactor(Wave w, double x, double y) {
        double offsetAngle = Util.absoluteBearing(w.origin.x, w.origin.y, x, y) - w.heading;
        return (double)w.clockwise * Utils.normalRelativeAngle((double)offsetAngle) / Util.maxEscapeAngle(w.velocity);
    }

    public void setFired(float guessFactor) {
        this.guessFactor = guessFactor;
        this.fired = true;
    }

    public boolean getFired() {
        return this.fired;
    }

    public void setHit(BulletCondition bulletCondition) {
        this.bulletCondition = bulletCondition;
    }

    public BulletCondition getHit() {
        return this.bulletCondition;
    }

    public String toString() {
        return "Wave from (" + this.origin + ") at heading " + (int)Math.toDegrees(this.heading) + "deg with power " + this.power + " in segment " + this.segmentation + ".";
    }
}

