/*
 * Decompiled with CFR 0.152.
 */
package ultra.core;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;

public abstract class JMapMathToolBox {
    private JMapMathToolBox() {
    }

    public static Rectangle2D transformRectWithDoublePrecision(Rectangle rect, AffineTransform transform) {
        Point2D p1 = new Point2D.Double(rect.x, rect.y);
        Point2D p2 = new Point2D.Double(p1.getX() + (double)rect.width, p1.getY() + (double)rect.height);
        Point2D p3 = new Point2D.Double(p1.getX(), p1.getY() + (double)rect.height);
        Point2D p4 = new Point2D.Double(p1.getX() + (double)rect.width, p1.getY());
        p1 = transform.transform(p1, null);
        p2 = transform.transform(p2, null);
        p3 = transform.transform(p3, null);
        p4 = transform.transform(p4, null);
        Rectangle2D.Double gridRect = new Rectangle2D.Double(p1.getX(), p1.getY(), 0.0, 0.0);
        gridRect.add(p2);
        gridRect.add(p3);
        gridRect.add(p4);
        return gridRect;
    }

    public static double round(double value, int nbDecimals) {
        double pow = Math.pow(10.0, nbDecimals);
        return (double)Math.round(value * pow) / pow;
    }

    public static Rectangle2D growRect(Rectangle2D.Double rect, double width, double height) {
        return new Rectangle2D.Double(rect.x - width / 2.0, rect.y - height / 2.0, rect.width + width, rect.height + height);
    }

    public static boolean isIncludedIn(double val, double start, double end) {
        return start <= val && val <= end;
    }

    public static boolean equals(double[] a1, double[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        int size = a1.length;
        int i = 0;
        while (i < size) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Rectangle2D.Double getBoundingBox(double ... coords) {
        if (coords.length == 0 || coords.length % 2 != 0) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(coords[0], coords[1], 0.0, 0.0);
        int i = 2;
        while (i < coords.length) {
            rect.add(coords[i], coords[i + 1]);
            i += 2;
        }
        return rect;
    }

    public static float sum(float[] array) {
        float res = 0.0f;
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                res += array[i];
                ++i;
            }
        }
        return res;
    }

    public static <T> T[] mergeArrays(T[] ... arrays) {
        Object[] res = null;
        int length = 0;
        int i = 0;
        while (i < arrays.length) {
            if (arrays[i] != null) {
                length += arrays[i].length;
            }
            ++i;
        }
        res = (Object[])Array.newInstance(arrays[0][0].getClass(), length);
        int idx = 0;
        int i2 = 0;
        while (i2 < arrays.length) {
            if (arrays[i2] != null) {
                System.arraycopy(arrays[i2], 0, res, idx, arrays[i2].length);
                idx += arrays[i2].length;
            }
            ++i2;
        }
        return res;
    }

    public static double[] mergeArrays(double[] ... arrays) {
        double[] res = null;
        int length = 0;
        int i = 0;
        while (i < arrays.length) {
            if (arrays[i] != null) {
                length += arrays[i].length;
            }
            ++i;
        }
        res = new double[length];
        int idx = 0;
        int i2 = 0;
        while (i2 < arrays.length) {
            if (arrays[i2] != null) {
                System.arraycopy(arrays[i2], 0, res, idx, arrays[i2].length);
                idx += arrays[i2].length;
            }
            ++i2;
        }
        return res;
    }

    public static double arcDist(double centerX, double centerY, double p1X, double p1Y, double p2X, double p2Y) {
        double angle = JMapMathToolBox.angle3Pts(centerX, centerY, p1X, p1Y, p2X, p2Y);
        double ray = JMapMathToolBox.dist2Pts(centerX, centerY, p1X, p1Y);
        return angle * ray;
    }

    public static double fixAngle(double rad) {
        double signum = Math.signum(rad);
        double res = rad;
        double max = Math.PI * 2;
        while (Math.abs(res) > max) {
            res -= max * signum;
        }
        return res;
    }

    public static double angle3Pts(Point2D.Double center, Point2D.Double point1, Point2D.Double point2) {
        return JMapMathToolBox.angle3Pts(center.x, center.y, point1.x, point1.y, point2.x, point2.y);
    }

    public static double angle3Pts(double centerX, double centerY, double p1X, double p1Y, double p2X, double p2Y) {
        Vector v1 = new Vector(centerX, centerY, p1X, p1Y);
        Vector v2 = new Vector(centerX, centerY, p2X, p2Y);
        double productOfNorms = v1.getNorm() * v2.getNorm();
        double vectProduct = JMapMathToolBox.vectorProduct(v1, v2);
        double scalProduct = JMapMathToolBox.scalarProduct(v1, v2);
        double cos = scalProduct / productOfNorms;
        double sin = vectProduct / productOfNorms;
        double radAngle = Math.acos(cos);
        if (sin < 0.0) {
            radAngle = Math.PI * 2 - radAngle;
        }
        return radAngle;
    }

    public static double vectorProduct(Vector v1, Vector v2) {
        return v1.getX() * v2.getY() - v1.getY() * v2.getX();
    }

    public static double scalarProduct(Vector v1, Vector v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY();
    }

    public static double dist2Pts(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double dist2Pts(Point2D p1, Point2D p2) {
        return JMapMathToolBox.dist2Pts(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static Point2D projectPoint(Point2D p, Vector v) {
        return new Point2D.Double(p.getX() + v.getX(), p.getY() + v.getY());
    }

    public static Point2D.Double projectPoint(Point2D.Double start, double distance, double bearing) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double x = distance * Math.cos(radBearing);
        double y = distance * Math.sin(radBearing);
        return new Point2D.Double(start.getX() + x, start.getY() + y);
    }

    public static boolean r1IntersectsR2(Rectangle r1, Rectangle r2) {
        int tw = r1.width;
        int th = r1.height;
        int rw = r2.width;
        int rh = r2.height;
        int tx = r1.x;
        int ty = r1.y;
        int rx = r2.x;
        int ry = r2.y;
        return !((rw += rx) >= rx && rw <= tx || (rh += ry) >= ry && rh <= ty || (tw += tx) >= tx && tw <= rx || (th += ty) >= ty && th <= ry);
    }

    public static boolean r1IntersectsR2(Rectangle2D r1, Rectangle2D r2) {
        double tw = r1.getWidth();
        double th = r1.getHeight();
        double rw = r2.getWidth();
        double rh = r2.getHeight();
        double tx = r1.getX();
        double ty = r1.getY();
        double rx = r2.getX();
        double ry = r2.getY();
        return ((rw += rx) < rx || rw > tx) && ((rh += ry) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
    }

    public static boolean r1IntersectsR2(Rectangle2D.Double r1, Rectangle2D.Double r2) {
        double tw = r1.width;
        double th = r1.height;
        double rw = r2.width;
        double rh = r2.height;
        double tx = r1.x;
        double ty = r1.y;
        double rx = r2.x;
        double ry = r2.y;
        return ((rw += rx) < rx || rw > tx) && ((rh += ry) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
    }

    public static class Vector {
        public double x;
        public double y;

        public Vector(Point2D.Double p1, Point2D.Double p2) {
            this.x = p2.x - p1.x;
            this.y = p2.y - p1.y;
        }

        public Vector(double vX, double vY) {
            this.x = vX;
            this.y = vY;
        }

        public Vector(double p1X, double p1Y, double p2X, double p2Y) {
            this(p2X - p1X, p2Y - p1Y);
        }

        public Vector clone() {
            return new Vector(this.x, this.y);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public Vector scale(double factor) {
            this.x *= factor;
            this.y *= factor;
            return this;
        }

        public String toString() {
            return String.valueOf(this.x) + ", " + this.y;
        }

        public void addVect(Vector v) {
            this.x += v.x;
            this.y += v.y;
        }

        public Vector normalize() {
            double norm = this.getNorm();
            if (norm != 0.0) {
                this.x /= norm;
                this.y /= norm;
            } else {
                this.y = 0.0;
                this.x = 0.0;
            }
            return this;
        }

        public double getNorm() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        public Vector invert() {
            this.x = -this.x;
            this.y = -this.y;
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Vector) {
                Vector vObj = (Vector)obj;
                return vObj.x == this.x && vObj.y == this.y;
            }
            return false;
        }
    }
}

