/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jekl.Jekyl;
import jekl.gunnery.guns.CircularFire;
import jekl.gunnery.guns.Fire;
import jekl.gunnery.guns.WaveFire;
import jekl.gunnery.util.FiringAssistant;
import jekl.gunnery.util.WaveBullet;
import jekl.intelligence.Enemy;
import jekl.util.Constants;
import robocode.Bullet;

public class FireManager
implements Constants {
    Jekyl ar;
    Fire[] firingMethods;
    double lastTargetEnergy;
    FiringAssistant fa;
    ArrayList waves;

    public FireManager(Jekyl _ar) {
        this.ar = _ar;
        this.fa = new FiringAssistant(_ar);
        this.waves = new ArrayList();
        this.firingMethods = new Fire[2];
        this.firingMethods[0] = new WaveFire(_ar);
        this.firingMethods[1] = new CircularFire(_ar);
    }

    public void shoot() {
        Enemy target = this.ar.getTarget();
        if (target == null || !target.isLive() || target.getDistance() >= 1100.0) {
            return;
        }
        double firePower = this.fa.calculateFirePower(target);
        this.doStats();
        Fire f = this.getFireMethod();
        f.doTurn(this.fa);
        if (this.ar.getGunHeat() == 0.0 && target.isLive() && firePower > 0.0) {
            target.incrementShotsAt();
            target.incrementCumFirePwr(firePower);
            Bullet b = this.ar.setFireBullet(firePower);
            if (b != null && this.ar.getOthers() == 1) {
                this.waves.add(new WaveBullet(target, this.ar.getCurrentLoc(), firePower, this.ar.getTime(), this.fa.getDistanceIndex(firePower, target), this.fa.getLatVelIndex(target), this.fa.getAccelIndex(target), this.fa.getMaxAnglePossible(firePower), this.fa.getDirection(target), this.fa.getInitialTargetAbsBearing(target), this.fa.getRadialIndex(target), this.fa.getWallIndex(target)));
            }
        }
    }

    private Fire getFireMethod() {
        if (this.ar.getOthers() > 1) {
            return this.getFireMethod(1);
        }
        return this.getFireMethod(0);
    }

    private Fire getFireMethod(int fm) {
        return this.firingMethods[fm];
    }

    private double getAngleThreshold() {
        return Math.atan(10.0 / this.ar.getTarget().getDistance());
    }

    public void saveData() {
        try {
            File f = this.ar.getDataFile(this.getFileName());
            if (f.exists()) {
                Fire fire = this.firingMethods[0];
                fire.saveData();
            } else if (this.ar.getWinPercentage() < 0.8 || this.ar.getProps().getProperty("behavior").equalsIgnoreCase("reference")) {
                Fire fire = this.firingMethods[0];
                fire.saveData();
            } else if (this.ar.DEBUG) {
                System.out.println("Won with " + this.ar.getWinPercentage() + "%. Not Saving");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doStats() {
        long currentTick = this.ar.getTime();
        Iterator it = ((AbstractList)this.waves).iterator();
        while (it.hasNext()) {
            WaveBullet w = (WaveBullet)it.next();
            if (!w.hasReached(currentTick)) continue;
            int i = 0;
            while (i < this.firingMethods.length) {
                this.firingMethods[i].doStats(w);
                ++i;
            }
            it.remove();
        }
    }

    private String getFileName() {
        if (this.ar.getTarget().getName().indexOf(" ") >= 0) {
            return String.valueOf(this.ar.getTarget().getName().substring(0, this.ar.getTarget().getName().indexOf(" "))) + ".zip";
        }
        return String.valueOf(this.ar.getTarget().getName()) + ".zip";
    }
}

