/*
 * Decompiled with CFR 0.152.
 */
package jekl.navigation.movement;

import java.awt.geom.Point2D;
import jekl.Jekyl;
import jekl.navigation.movement.Movement;
import jekl.util.BotHelp;
import jekl.util.Constants;

public abstract class AbstractMovement
implements Movement,
Constants {
    Jekyl ar;

    public AbstractMovement(Jekyl _ar) {
        this.ar = _ar;
    }

    protected void goTo(Point2D.Double c) {
        double x = c.getX();
        double y = c.getY();
        if (x < 50.0) {
            x = 50.0;
        }
        if (y < 50.0) {
            y = 50.0;
        }
        if (x > this.ar.getBattleFieldWidth() - 50.0) {
            x = this.ar.getBattleFieldWidth() - 50.0;
        }
        if (y > this.ar.getBattleFieldHeight() - 50.0) {
            y = this.ar.getBattleFieldHeight() - 50.0;
        }
        double angle = Math.toDegrees(BotHelp.absbearing(this.ar.getX(), this.ar.getY(), x, y));
        double direction = this.turnTo(angle);
        this.ar.setAhead(Math.abs(c.distance(this.ar.getX(), this.ar.getY())) * direction);
    }

    protected int turnTo(double angle) {
        int dir;
        double ang = BotHelp.normaliseBearing(this.ar.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.ar.setTurnLeft(ang);
        return dir;
    }

    public abstract void doMovement();

    public abstract void notifyOfHit();
}

