/*
 * Decompiled with CFR 0.152.
 */
package mb.waves;

import java.util.ArrayList;
import java.util.List;
import mb.core.Coordinates;
import mb.waves.Segments;
import mb.waves.Wave;

public class WaveStorage {
    private List<Wave> waves = new ArrayList<Wave>();
    private static List<Coordinates>[][] diffVector = new ArrayList[Segments.headingSegments][Segments.distanceSegments];

    public WaveStorage() {
        int i = 0;
        while (i < diffVector.length) {
            int j = 0;
            while (j < diffVector[i].length) {
                WaveStorage.diffVector[i][j] = new ArrayList<Coordinates>();
                ++j;
            }
            ++i;
        }
    }

    public void newWave(long fireTime, double power, Coordinates start, Coordinates target, double heading, double distance) {
        Wave wave = new Wave(fireTime, power, start, target, heading, distance);
        this.waves.add(wave);
    }

    public void checkWaves(Coordinates enemyPosition, long currentTime) {
        int i = 0;
        while (i < this.waves.size()) {
            Wave currentWave = this.waves.get(i);
            if (currentWave.checkHit(enemyPosition, currentTime)) {
                diffVector[this.getHeadingSegment(currentWave.getHeading())][this.getDistanceSegment(currentWave.getDistance())].add(currentWave.getDiffVector(enemyPosition));
                this.waves.remove(currentWave);
                --i;
            }
            ++i;
        }
    }

    private int getHeadingSegment(double heading) {
        return (int)heading / (360 / Segments.headingSegments);
    }

    private int getDistanceSegment(double distance) {
        return (int)distance / (1200 / Segments.distanceSegments);
    }

    public List<Coordinates> getDiffVectors(double heading, double distance) {
        return diffVector[this.getHeadingSegment(heading)][this.getDistanceSegment(distance)];
    }
}

