/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.MathUtils;
import bing2.Position;

public class Wave
implements Cloneable {
    public Position center;
    public double radius;
    public long createTime;
    public double velocity;
    public long hitTime = 0L;
    public Position hitPosition = null;
    public double targetInitialBearing;
    public int targetInitialDirection;

    public Wave(double d, double d2, double d3, long l, double d4, int n) {
        this(new Position(d, d2), d3, l, d4, n);
    }

    public Wave(Position position, double d, long l, double d2, int n) {
        this.center = position;
        this.radius = 0.0;
        this.createTime = l;
        this.velocity = d;
        this.targetInitialBearing = d2;
        this.targetInitialDirection = n;
    }

    public Wave clone() {
        Wave wave = new Wave(this.center, this.velocity, this.createTime, this.targetInitialBearing, this.targetInitialDirection);
        wave.radius = this.radius;
        wave.hitTime = this.hitTime;
        wave.hitPosition = new Position(this.hitPosition.x, this.hitPosition.y);
        return wave;
    }

    public double distance(Position position) {
        return MathUtils.distance(position, this.center) - this.radius;
    }

    public boolean hitsRobot(Position position) {
        return Math.abs(this.distance(position)) <= 18.0;
    }

    public long timeToHitRobot(Position position) {
        double d = this.distance(position) - 18.0;
        if (Math.abs(d) <= 18.0) {
            return 0L;
        }
        if (d < 0.0) {
            return -1L;
        }
        return (long)Math.ceil(d / this.velocity);
    }

    public void update(long l) {
        this.radius = this.velocity * (double)l;
    }

    public String toString() {
        double d = 0.0;
        if (this.hitPosition != null) {
            d = MathUtils.toDegrees(MathUtils.bearing(this.hitPosition, this.center));
        }
        return "C = " + this.center + ", r = " + this.radius + ", v = " + this.velocity + ", t0 = " + this.createTime + "\n" + ", t = " + this.hitTime + ", P = " + this.hitPosition + ", B = " + d + ", TIB = " + this.targetInitialBearing + ", TID = " + this.targetInitialDirection;
    }
}

