/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.geom.Point2D;

public class Utils {
    private static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;

    public static double absoluteBearing(Point2D.Double p, Point2D.Double q) {
        return Math.atan2(q.x - p.x, q.y - p.y);
    }

    public static double normalizeHeading(double angle) {
        return (angle % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double normalizeBearing(double angle) {
        return Utils.normalizeHeading(angle + Math.PI) - Math.PI;
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double bulletDamage(double power) {
        return 4.0 * power + 2.0 * Math.max(power - 1.0, 0.0);
    }

    public static double bulletHeat(double power) {
        return 1.0 + power / 5.0;
    }

    public static int sign(double a) {
        return a < 0.0 ? -1 : 1;
    }

    public static double limit(double min, double max, double value) {
        return Math.min(max, Math.max(min, value));
    }

    public static Point2D.Double project(Point2D.Double source, double angle, double length) {
        return new Point2D.Double(source.x + Math.sin(angle) * length, source.y + Math.cos(angle) * length);
    }

    public static double timeWeightedRollingAverage(double newValue, double oldValue, double deltaTime, double decayRate) {
        double w = Math.exp(-decayRate * deltaTime);
        return w * oldValue + (1.0 - w) * newValue;
    }

    public static double computeDecayRate(double halfLife) {
        return -Math.log(0.5) / halfLife;
    }

    public static double DamageDealt(double power) {
        return power * 4.0 + Math.max(0.0, power - 1.0) * 2.0;
    }
}

