/*
 * Decompiled with CFR 0.152.
 */
package bh.facade;

import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heat;
import bh.units.Location;
import bh.units.Speed;
import bh.units.Units;
import bh.util.Vector;
import robocode.Rules;

public final class RulesFacade {
    public static final Speed ACCELERATION = new Speed(1.0);
    public static final Speed DECELERATION = new Speed(2.0);
    public static final Speed MAX_VELOCITY;
    public static final Speed MAX_SPEED;
    public static final Bearing MAX_TURN_RATE;
    public static final Bearing GUN_TURN_RATE;
    public static final Bearing RADAR_TURN_RATE;
    public static final Energy MIN_BULLET_POWER;
    public static final Energy MAX_BULLET_POWER;
    public static final Distance RADAR_SCAN_RADIUS;
    public static final Double ROBOT_HIT_BONUS;
    public static final Double ROBOT_HIT_DAMAGE;
    public static Distance BATTLEFIELD_HEIGHT;
    public static Distance BATTLEFIELD_WIDTH;
    public static final Distance BOT_HEIGHT;
    public static final Distance BOT_WIDTH;

    static {
        MAX_SPEED = MAX_VELOCITY = new Speed(8.0);
        MAX_TURN_RATE = new Bearing(Angle.fromDegrees(10.0));
        GUN_TURN_RATE = new Bearing(Angle.fromDegrees(20.0));
        RADAR_TURN_RATE = new Bearing(Angle.fromDegrees(45.0));
        MIN_BULLET_POWER = new Energy(0.1);
        MAX_BULLET_POWER = new Energy(3.0);
        RADAR_SCAN_RADIUS = new Distance(1200.0);
        ROBOT_HIT_BONUS = new Double(1.2);
        ROBOT_HIT_DAMAGE = new Double(0.6);
        BOT_HEIGHT = new Distance(36.0);
        BOT_WIDTH = new Distance(36.0);
    }

    public static Energy getBulletDamage(Energy bulletPower) {
        return new Energy(Rules.getBulletDamage((double)bulletPower.toDouble()));
    }

    public static Double getBulletHitBonus(Energy bulletPower) {
        return Rules.getBulletHitBonus((double)bulletPower.toDouble());
    }

    public static Speed getBulletSpeed(Energy bulletPower) {
        return new Speed(Rules.getBulletSpeed((double)bulletPower.toDouble()));
    }

    public static Heat getGunHeat(Energy bulletPower) {
        return new Heat(Rules.getGunHeat((double)bulletPower.toDouble()));
    }

    public static Bearing getTurnRate(Speed speed) {
        return new Bearing(Angle.fromDegrees(Rules.getTurnRate((double)speed.toDouble())));
    }

    public static Energy getWallHitDamage(Speed speed) {
        return new Energy(Rules.getWallHitDamage((double)speed.toDouble()));
    }

    public static Vector nearestWall(Location botLocation) {
        Vector up = new Vector(Distance.ZERO, BATTLEFIELD_HEIGHT.minus(botLocation.getY()).minus(BOT_HEIGHT.divide(2.0)));
        Vector down = new Vector(Distance.ZERO, BOT_HEIGHT.divide(2.0).minus(botLocation.getY()));
        Vector left = new Vector(BOT_WIDTH.divide(2.0).minus(botLocation.getX()), Distance.ZERO);
        Vector right = new Vector(BATTLEFIELD_WIDTH.minus(BOT_WIDTH.divide(2.0)).minus(botLocation.getX()), Distance.ZERO);
        Distance d = Units.min(up.getMagnitude(), down.getMagnitude());
        d = Units.min(d, left.getMagnitude());
        d = Units.min(d, right.getMagnitude());
        if (up.getMagnitude().equals(d)) {
            return up;
        }
        if (down.getMagnitude().equals(d)) {
            return down;
        }
        if (left.getMagnitude().equals(d)) {
            return left;
        }
        if (right.getMagnitude().equals(d)) {
            return right;
        }
        System.out.println("RulesFacade.nearestWall(): couldn't find nearest wall???");
        return null;
    }
}

