/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.BulletTracker;
import emp.Consts;
import emp.Control;
import emp.Enemy;
import emp.EnemyCollection;
import emp.Gunner;
import emp.Motor;
import emp.My;
import emp.Predictor;
import emp.Scanner;
import emp.Strategy;
import java.awt.Color;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Yngwie
extends AdvancedRobot
implements Consts {
    private int StatBulletsHit;
    private int StatBulletsMissed;
    private int StatSkippedTurns;
    private int StatTimeErrors;
    private static int StatTotalTime;
    private static int StatTotalTimeErrors;
    private static int StatTotalSkippedTurns;
    private static int StatTotalBulletsHit;
    private static int StatTotalBulletsMissed;
    private static long StatTotalWallCollisions;
    private static long StatTotalEnemyCollisions;
    private static long StatTotalExceptions;
    public static double BattleFieldHeight;
    public static double BattleFieldWidth;
    public double X;
    public double Y;
    public double LastX;
    public double LastY;
    private double LastEnemyX;
    private double LastEnemyY;
    public static Yngwie instance;
    public static boolean OneOnOne;
    public long LastTime;
    public Control control;
    public Motor motor;
    public Gunner gunner;
    public Scanner scanner;
    public static EnemyCollection EC;
    public Predictor predictor;
    public Vector bullettrackers;
    public Vector ScanEvents;
    public static long PeaceTime;
    public static boolean Melee;
    public boolean won;

    public void run() {
        this.setColors(Color.green, Color.green, Color.cyan);
        if (EC == null) {
            instance = this;
            EC = new EnemyCollection(this);
            StatTotalTime = 0;
            StatTotalTimeErrors = 0;
            StatTotalSkippedTurns = 0;
            StatTotalWallCollisions = 0L;
            StatTotalBulletsHit = 0;
            StatTotalBulletsMissed = 0;
            StatTotalEnemyCollisions = 0L;
            StatTotalExceptions = 0L;
            BattleFieldHeight = this.getBattleFieldHeight();
            BattleFieldWidth = this.getBattleFieldWidth();
            PeaceTime = this.GetCoolingDownTurns();
            Melee = this.getOthers() != 1;
        } else {
            EC.ResetDeaths();
        }
        this.ScanEvents = new Vector(this.getOthers());
        this.bullettrackers = new Vector(10, 5);
        this.control = new Control(this);
        this.motor = new Motor(this);
        this.gunner = new Gunner(this);
        this.scanner = new Scanner(this);
        this.predictor = new Predictor(this);
        ((Robot)this).out.println();
        while (true) {
            if (this.getTime() == (long)0) {
                this.getInitialValues();
            } else {
                if (this.LastTime != this.getTime() - (long)1) {
                    ++this.StatTimeErrors;
                    ++StatTotalTimeErrors;
                }
                this.LastTime = this.getTime();
            }
            this.X = this.getX();
            this.Y = this.getY();
            try {
                OneOnOne = this.getOthers() == 1;
                this.HandleScanEvents();
                this.HandleBulletTrackers();
                this.motor.Update();
                this.gunner.Update();
                this.scanner.Update();
                this.control.Update();
            }
            catch (Exception ex) {
                ++StatTotalExceptions;
                ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" catched it! : ").append(ex.getMessage()))));
            }
            if (this.won && this.motor.Threats.size() == 0) {
                this.VictoryDance();
            }
            this.LastX = this.X;
            this.LastY = this.Y;
            this.execute();
        }
    }

    public void HandleScanEvents() {
        for (int i = 0; i < this.ScanEvents.size(); ++i) {
            EC.StoreScanEvent((ScannedRobotEvent)this.ScanEvents.elementAt(i));
        }
        this.ScanEvents.clear();
    }

    public void HandleBulletTrackers() {
        if (this.bullettrackers.size() == 0) {
            return;
        }
        Enemy en = null;
        int idx = 0;
        int i = 0;
        while (i < this.bullettrackers.size()) {
            BulletTracker bt = (BulletTracker)this.bullettrackers.elementAt(i);
            if (bt.completed && bt.bulletDead) {
                this.bullettrackers.removeElementAt(i);
                continue;
            }
            bt.Counter -= (long)1;
            if (bt.Counter > (long)0) {
                ++i;
                continue;
            }
            idx = EC.IndexOf(bt.enemy);
            if (idx == -1) {
                this.bullettrackers.removeElementAt(i);
                continue;
            }
            en = (Enemy)Yngwie.EC.Enemies.elementAt(idx);
            if (!bt.completed) {
                bt.completed = en.AddBulletItem(bt, this.getTime());
            }
            ++i;
        }
    }

    public double getTargetField() {
        if (OneOnOne) {
            return 50.0;
        }
        return 150.0;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.motor.Collide = true;
        ++StatTotalEnemyCollisions;
        this.scanner.CheckHeading(event.getBearing());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.scanner.CheckHeading(My.AddDegrees(this.getHeading(), e.getBearing()));
        int Enemyidx = EC.IndexOf(e.getName());
        if (Enemyidx != -1) {
            Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(Enemyidx);
            en.EnergyAdjust += My.getBulletGain(e.getPower());
            en.LastTimeHitMe = this.getTime();
            en.BulletDamage += My.getBulletDamage(e.getPower());
        }
    }

    public void onHitWall(HitWallEvent event) {
        ++StatTotalWallCollisions;
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Bullet bullet = event.getBullet();
        for (int i = 0; i < this.bullettrackers.size(); ++i) {
            BulletTracker bt = (BulletTracker)this.bullettrackers.elementAt(i);
            if (bt.bullet != bullet) continue;
            int idx = EC.IndexOf(bt.enemy);
            if (idx > -1) {
                Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(idx);
                for (int j = 0; j < en.Strategies.size(); ++j) {
                    Strategy strat = (Strategy)en.Strategies.elementAt(j);
                    if (strat.ID != bt.Strategy) continue;
                    strat.Failed(bullet.getPower());
                    break;
                }
            }
            bt.bulletDead = true;
            break;
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.StatBulletsHit;
        ++StatTotalBulletsHit;
        Bullet bullet = event.getBullet();
        for (int i = 0; i < this.bullettrackers.size(); ++i) {
            BulletTracker bt = (BulletTracker)this.bullettrackers.elementAt(i);
            if (bt.bullet != bullet) continue;
            int idx = EC.IndexOf(bt.enemy);
            if (idx > -1) {
                Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(idx);
                en.EnergyAdjust -= My.getBulletDamage(event.getBullet().getPower());
                if (en.Name == bullet.getVictim()) {
                    for (int j = 0; j < en.Strategies.size(); ++j) {
                        Strategy strat = (Strategy)en.Strategies.elementAt(j);
                        if (strat.ID != bt.Strategy) continue;
                        strat.Success(bullet.getPower());
                        break;
                    }
                }
            }
            bt.bulletDead = true;
            break;
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.StatBulletsMissed;
        ++StatTotalBulletsMissed;
        Bullet bullet = event.getBullet();
        for (int i = 0; i < this.bullettrackers.size(); ++i) {
            BulletTracker bt = (BulletTracker)this.bullettrackers.elementAt(i);
            if (bt.bullet != bullet) continue;
            int idx = EC.IndexOf(bt.enemy);
            if (idx > -1) {
                Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(idx);
                for (int j = 0; j < en.Strategies.size(); ++j) {
                    Strategy strat = (Strategy)en.Strategies.elementAt(j);
                    if (strat.ID != bt.Strategy) continue;
                    strat.Failed(bullet.getPower());
                    break;
                }
            }
            bt.bulletDead = true;
            break;
        }
    }

    public double getBulletDamageAimedAt(Enemy en) {
        double result = 0.0;
        double mydist = this.Distance(en) + 30.0;
        for (int i = 0; i < this.bullettrackers.size(); ++i) {
            BulletTracker bt = (BulletTracker)this.bullettrackers.elementAt(i);
            if (bt.bulletDead) continue;
            double bulletdistance = My.Distance(bt.bullet.getX(), bt.bullet.getX(), en.X(), en.Y());
            if (bt.enemy != en.Name || !(bulletdistance < mydist)) continue;
            result += My.getBulletDamage(bt.bullet.getPower());
        }
        return result;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int idx = EC.IndexOf(e.getName());
        if (this.won && idx != -1 && ((Enemy)Yngwie.EC.Enemies.elementAt(idx)).Time() == this.getTime() - (long)1) {
            Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(idx);
            this.LastEnemyX = en.X();
            this.LastEnemyY = en.Y();
        }
        if (idx != -1 && (Enemy)Yngwie.EC.Enemies.elementAt(idx) == this.gunner.Target) {
            this.scanner.ScanRound();
        }
        EC.EnemyDeath(e.getName());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.ScanEvents.add(e);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++this.StatSkippedTurns;
        ++StatTotalSkippedTurns;
    }

    public void onDeath(DeathEvent event) {
        this.EndRound();
    }

    public void onWin(WinEvent event) {
        this.won = true;
        this.EndRound();
    }

    private void VictoryDance() {
        double TargetY;
        double TargetX;
        while (Math.abs(this.getVelocity()) > 0.0) {
            this.setAhead(0.0);
            this.execute();
        }
        if (this.LastEnemyX > (double)-1) {
            TargetX = this.LastEnemyX;
            TargetY = this.LastEnemyY;
        } else {
            TargetX = BattleFieldWidth / 2.0;
            TargetY = BattleFieldHeight / 2.0;
        }
        double angle = My.AngleFromTo(this.getX(), this.getY(), TargetX, TargetY);
        double antiangle = (angle + 180.0) % 360.0;
        while (Math.abs(this.getHeading() - antiangle) > 0.01 || Math.abs(this.getGunHeading() - antiangle) > 0.01 || Math.abs(this.getRadarHeading() - antiangle) > 0.01) {
            this.control.TurnTo(1, 3, antiangle, false);
            this.control.TurnTo(2, 3, antiangle, false);
            this.control.TurnTo(3, 3, antiangle, false);
            this.control.Update();
            this.execute();
        }
        this.execute();
        int i = 1;
        while (Math.abs(this.getHeading() - angle) > 0.01) {
            this.control.TurnTo(1, 3, (antiangle + (double)i * 10.0) % 360.0, false);
            this.control.TurnTo(2, 3, (antiangle + (double)i * 30.0) % 360.0, false);
            this.control.TurnTo(3, 3, (antiangle + (double)i * 71.25) % 360.0, false);
            this.control.Update();
            this.execute();
            ++i;
        }
        double dist = My.Distance(this.getX(), this.getY(), TargetX, TargetY);
        while (dist > 2.0) {
            if (My.isToRightDeg(this.getHeading(), this.getRadarHeading())) {
                this.setTurnRadarLeft(45.0);
            } else {
                this.setTurnRadarRight(45.0);
            }
            this.setAhead(dist);
            this.execute();
            dist = My.Distance(this.getX(), this.getY(), TargetX, TargetY);
        }
        while (this.getHeading() > 0.01 || this.getGunHeading() > 0.01 || this.getRadarHeading() > 0.01) {
            this.control.TurnTo(1, 3, 0.0, false);
            this.control.TurnTo(2, 3, 0.0, false);
            this.control.TurnTo(3, 3, 0.0, false);
            this.control.Update();
            this.execute();
        }
        this.turnLeft(20.0);
        for (i = 0; i < 30; ++i) {
            this.turnRight(40.0);
            this.turnLeft(40.0);
        }
    }

    private void EndRound() {
        StatTotalTime = (int)((long)StatTotalTime + this.getTime());
    }

    private void PrintStats() {
        ((Robot)this).out.println();
        if (Melee) {
            ((Robot)this).out.println("-- Yngwie Melee battle statistics --");
        } else {
            ((Robot)this).out.println("-- Yngwie 1-v-1 battle statistics --");
        }
        ((Robot)this).out.println("Bullets hit           : ".concat(String.valueOf(String.valueOf(this.StatBulletsHit))));
        ((Robot)this).out.println("Bullets hit ratio %   : ".concat(String.valueOf(String.valueOf(100.0f * (float)this.StatBulletsHit / (float)Math.max(1, this.StatBulletsHit + this.StatBulletsMissed)))));
        ((Robot)this).out.println("Current time          : ".concat(String.valueOf(String.valueOf(this.getTime()))));
        ((Robot)this).out.println("Skipped turns         : ".concat(String.valueOf(String.valueOf(this.StatSkippedTurns))));
        ((Robot)this).out.println("Time errors           : ".concat(String.valueOf(String.valueOf(this.StatTimeErrors))));
        ((Robot)this).out.println("Total exceptions      : ".concat(String.valueOf(String.valueOf(StatTotalExceptions))));
        ((Robot)this).out.println("Total time            : ".concat(String.valueOf(String.valueOf(StatTotalTime))));
        ((Robot)this).out.println("Total skipped turns   : ".concat(String.valueOf(String.valueOf(StatTotalSkippedTurns))));
        ((Robot)this).out.println("Total time errors     : ".concat(String.valueOf(String.valueOf(StatTotalTimeErrors))));
        ((Robot)this).out.println("Total Wall collisions : ".concat(String.valueOf(String.valueOf(StatTotalWallCollisions))));
        ((Robot)this).out.println("Total Enemy collisions: ".concat(String.valueOf(String.valueOf(StatTotalEnemyCollisions))));
        ((Robot)this).out.println("Total Bullets hit     : ".concat(String.valueOf(String.valueOf(StatTotalBulletsHit))));
        ((Robot)this).out.println("Total Bullets hit %   : ".concat(String.valueOf(String.valueOf(100.0f * (float)StatTotalBulletsHit / (float)Math.max(1, StatTotalBulletsHit + StatTotalBulletsMissed)))));
    }

    protected void getInitialValues() {
        this.StatBulletsHit = 0;
        this.StatBulletsMissed = 0;
        this.StatSkippedTurns = 0;
        this.StatTimeErrors = 0;
        OneOnOne = false;
        this.LastTime = 0L;
        this.LastEnemyX = -1.0;
        this.LastEnemyY = -1.0;
        this.LastX = this.getX();
        this.LastY = this.getY();
        this.won = false;
    }

    protected void printReport() {
        ((Robot)this).out.println(String.valueOf(String.valueOf(this.getTime())).concat(" REPORT"));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" BattleFieldHeight : ").append(BattleFieldHeight))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" BattleFieldWidth : ").append(BattleFieldWidth))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" Others : ").append(this.getOthers()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" GunCoolingRate : ").append(this.getGunCoolingRate()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" X : ").append(this.getX()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" Y : ").append(this.getY()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" Heading : ").append(this.getHeading()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" Velocity : ").append(this.getVelocity()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" Energy : ").append(this.getEnergy()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" RadarHeading : ").append(this.getRadarHeading()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" GunHeading : ").append(this.getGunHeading()))));
        ((Robot)this).out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getTime()))).append(" GunHeat : ").append(this.getGunHeat()))));
        ((Robot)this).out.println();
    }

    public double Distance(Enemy en) {
        return My.Distance(this.getX(), this.getY(), en.X(), en.Y());
    }

    public double AngleTo(Enemy en) {
        return My.AngleFromTo(this.getX(), this.getY(), en.X(), en.Y());
    }

    public double TurnsCoolingDown(double firePower) {
        return (1.0 + firePower / (double)5) / this.getGunCoolingRate();
    }

    public long GetCoolingDownTurns() {
        return (long)Math.ceil(this.getGunHeat() / this.getGunCoolingRate());
    }

    public double NextTurnAngleTo(Enemy en) {
        if (en == null || en.Death || en.RC == 0 || this.getTime() - en.Time() > (long)9) {
            return -1.0;
        }
        double tijdsverschil = (double)(this.getTime() - en.Time()) + 1.0;
        double vX = en.X() + en.Velocity() * tijdsverschil * My.sinDeg(en.Heading());
        double vY = en.Y() + en.Velocity() * tijdsverschil * My.cosDeg(en.Heading());
        return My.AngleFromTo(this.control.NextXPos(), this.control.NextYPos(), vX, vY);
    }
}

