/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Simulation;
import pa3k.State;
import pa3k.StateMomentumDirectionKeep;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.KeyEvent;
import robocode.Robot;
import robocode.Rules;

public class MonteCarlo
extends RobotModule {
    protected Tracking tracking;
    protected Opponent target;
    protected SelfTracking selfTracking;
    protected static State[] states = null;
    protected static long samples = 0L;
    protected State currentState;
    protected double lastVelocity;
    protected List<Simulation> simulations;

    public MonteCarlo(AdvancedRobot robot, Tracking tracking, SelfTracking st) {
        super(robot);
        this.selfTracking = st;
        this.tracking = tracking;
        this.lastVelocity = 0.0;
        if (states == null) {
            states = new State[16];
            int i = 0;
            while (i < 8) {
                MonteCarlo.states[i] = new StateMomentumDirectionKeep(i, false);
                ++i;
            }
            i = 1;
            while (i <= 8) {
                MonteCarlo.states[7 + i] = new StateMomentumDirectionKeep(i, true);
                ++i;
            }
        }
        this.currentState = states[0];
        this.simulations = new LinkedList<Simulation>();
    }

    @Override
    public void turn() {
        this.target = this.tracking.getLastHitBy();
        long now = this.robot.getTime();
        if (this.target != null && now > 5L) {
            boolean directionChange;
            block12: {
                directionChange = false;
                try {
                    double v = this.target.getLastVelocity();
                    boolean bl = directionChange = this.lastVelocity > 0.0 && v < 0.0 || this.lastVelocity < 0.0 && v > 0.0;
                    if (v != 0.0) {
                        this.lastVelocity = v;
                    }
                    long lastOpponentSpeedChange = this.target.getLastSpeedChange(now - 1L);
                    long lastEnergyDropDelay = this.target.getLastEnergyDrop(now - 1L);
                    long lastOpponentHitDelay = 0L;
                    double lastEnergyDrop = 0.0;
                    Position f = new Position(this.target.getLastPosition());
                    f.modify(1L, 140 * (this.target.getLastVelocity() > 0.0 ? 1 : -1), this.target.getLastHeading());
                    boolean facingWall = !f.isInBattlefield();
                    Change c = this.currentState.amIStillHere(this.robot, this.selfTracking, this.target, now, states, directionChange, lastOpponentSpeedChange, facingWall, lastOpponentHitDelay, lastEnergyDropDelay, lastEnergyDrop);
                    ++samples;
                    if (c != null) {
                        if (!c.checkConsitency(this.currentState)) {
                            Log.log(2, "Inconsistent change: " + c);
                            this.currentState.deleteChange(c);
                        }
                        this.currentState = c.getTargetState();
                        c.increaseLikelihood();
                    } else {
                        assert (false);
                        this.currentState.increaseNoChangeLikelihood(lastOpponentSpeedChange, facingWall, lastOpponentHitDelay, lastEnergyDropDelay, lastEnergyDrop);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            Position my = new Position((Robot)this.robot);
            Iterator<Simulation> i = this.simulations.iterator();
            while (i.hasNext()) {
                Simulation s = i.next();
                if (!s.isStillValid(now, this.currentState, directionChange)) {
                    i.remove();
                    continue;
                }
                Position p = s.expectedPosition(states, now, Rules.getBulletSpeed((double)1.8), my, this.target);
                Log.paintFilledCircle(3, p, 9, new Color(0, 255, 0, 30), 0);
            }
            int k = this.simulations.size();
            int m = 0;
            while (k < 15 && m < 4) {
                Simulation sim = new Simulation(states, this.currentState, now, Rules.getBulletSpeed((double)1.8), my, this.target);
                this.simulations.add(sim);
                ++k;
                ++m;
            }
            if (now % 20L == 0L) {
                this.dumpData();
            }
        }
    }

    public Position[] simulatePosition(double bulletSpeed, Position my) {
        Position[] result = new Position[this.simulations.size()];
        long now = this.robot.getTime();
        Iterator<Simulation> it = this.simulations.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = it.next().expectedPosition(states, now + 1L, bulletSpeed, my, this.target);
            ++i;
        }
        return result;
    }

    @Override
    public void init() {
    }

    public void dumpData() {
        State[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            Log.log(4, s + ":");
            Log.log(4, "  stay: " + s.getLikelihood());
            s.dumpChanges();
            ++n2;
        }
    }

    public void onOkey(KeyEvent e) {
        this.dumpData();
    }

    public long getSamples() {
        return samples;
    }
}

