/*
 * Decompiled with CFR 0.152.
 */
package az;

import az.enemy;
import az.meleeBestFiringAngleSearcher;
import az.targetingStatistics;
import az.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Ololobot
extends AdvancedRobot {
    double x;
    double y;
    double headingRadians;
    double velocity;
    double radarTurnRemaining;
    double height;
    double width;
    double offset;
    double getAngleDanger_maxDist;
    double prev_positions_xSum = 0.0;
    double prev_positions_ySum = 0.0;
    double prev_positions_sqrSum = 0.0;
    double pi = Math.PI;
    int direction = 1;
    int target = -1;
    int n = 0;
    int prev_positions_pointer = 0;
    int PREV_POSITIONS_CNT = 20;
    int NEAREST_ROBOT_TO_COUNT_CNT = 6;
    long fireAtTime;
    long time;
    int skippedCount = 0;
    static String placesHeader;
    static int skippedSum;
    static int robotsInBattle;
    static int[] places;
    enemy[] targets;
    static targetingStatistics[] stats;
    static meleeBestFiringAngleSearcher meleeStats;
    double[] prev_positions_x = new double[this.PREV_POSITIONS_CNT];
    double[] prev_positions_y = new double[this.PREV_POSITIONS_CNT];

    static {
        skippedSum = 0;
        stats = new targetingStatistics[99];
        meleeStats = new meleeBestFiringAngleSearcher();
    }

    public void run() {
        if (this.getRoundNum() == 0) {
            robotsInBattle = this.getOthers();
            places = new int[robotsInBattle + 1];
            placesHeader = "";
            int i = 0;
            while (i <= robotsInBattle) {
                if (i + 1 < 10) {
                    placesHeader = String.valueOf(placesHeader) + " ";
                }
                placesHeader = String.valueOf(placesHeader) + (i + 1) + "  ";
                Ololobot.places[i] = 0;
                ++i;
            }
        }
        this.targets = new enemy[robotsInBattle + 4];
        this.height = this.getBattleFieldHeight();
        this.width = this.getBattleFieldWidth();
        this.offset = Math.max(this.getHeight(), this.getWidth());
        double GUN_COOLING_RATE = this.getGunCoolingRate();
        int i = 0;
        while (i < 4) {
            this.targets[i] = new enemy(this, "corner");
            this.targets[i].scanX = i < 2 ? this.offset : this.width - this.offset;
            this.targets[i].scanY = i % 2 == 0 ? this.offset : this.height - this.offset;
            this.targets[i].scanTime = 0L;
            this.targets[i].vx = 0.0;
            this.targets[i].vy = 0.0;
            ++i;
        }
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRight(360.0);
        String placesCounts = this.generatePlacesCounts();
        while (this.getOthers() > 0) {
            this.x = this.getX();
            this.y = this.getY();
            this.headingRadians = this.getHeadingRadians();
            this.time = this.getTime();
            this.velocity = this.getVelocity();
            this.radarTurnRemaining = this.getRadarTurnRemaining();
            double gunHeat = this.getGunHeat();
            double gunHeadingRadians = this.getGunHeadingRadians();
            double radarHeadingRadians = this.getRadarHeadingRadians();
            this.setDebugProperty("1 Round", "" + (this.getRoundNum() + 1));
            this.setDebugProperty("6 Time ", "" + this.time);
            this.setDebugProperty("4 Skipped turns", "" + this.skippedCount);
            this.setDebugProperty("1 Skipped   sum", "" + skippedSum);
            this.setDebugProperty("6 Place", placesHeader);
            this.setDebugProperty("5 Count", placesCounts);
            this.prev_positions_sqrSum += Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0);
            this.prev_positions_sqrSum -= Math.pow(this.prev_positions_x[this.prev_positions_pointer], 2.0) + Math.pow(this.prev_positions_y[this.prev_positions_pointer], 2.0);
            this.prev_positions_xSum += this.x - this.prev_positions_x[this.prev_positions_pointer];
            this.prev_positions_ySum += this.y - this.prev_positions_y[this.prev_positions_pointer];
            this.prev_positions_x[this.prev_positions_pointer] = this.x;
            this.prev_positions_y[this.prev_positions_pointer] = this.y;
            this.prev_positions_pointer = (this.prev_positions_pointer + 1) % this.PREV_POSITIONS_CNT;
            this.updateColor();
            this.prepareForGetAngleDanger();
            double bestAngle = 0.0;
            double bestAngleDanger = this.getAngleDanger(0.0, 1);
            int bestDir = 1;
            double alpha = -Rules.MAX_TURN_RATE_RADIANS;
            while (alpha <= Rules.MAX_TURN_RATE_RADIANS) {
                int dir = -1;
                while (dir <= 1) {
                    double danger = this.getAngleDanger(alpha, dir);
                    if (danger < bestAngleDanger) {
                        bestAngle = alpha;
                        bestDir = dir;
                        bestAngleDanger = danger;
                    }
                    dir += 2;
                }
                alpha += Rules.MAX_TURN_RATE_RADIANS / 30.0;
            }
            this.setTurnRightRadians(bestAngle);
            this.setAhead((double)(3 * bestDir) * 8.0);
            this.direction = bestDir;
            if (this.radarTurnRemaining == 0.0 && this.target == -1) {
                this.recalculateTargets(0, this.n);
                this.target = 0;
                int i2 = 1;
                while (i2 < this.n) {
                    if (this.targets[i2].getShootPriority() > this.targets[this.target].getShootPriority()) {
                        this.target = i2;
                    }
                    ++i2;
                }
            }
            if (this.target != -1) {
                this.recalculateTargets(this.target, this.target + 1);
                double targetBearing = this.targets[this.target].enemyStats.getBestFiringAngle(this.targets[this.target].scanTime, this.targets[this.target].scanX, this.targets[this.target].scanY, Math.atan2(this.targets[this.target].vx, this.targets[this.target].vy), Math.hypot(this.targets[this.target].vx, this.targets[this.target].vy), this.n, this.x, this.y, this.headingRadians, this.velocity, this.time, this.fireAtTime, Rules.getBulletSpeed((double)this.targets[this.target].power));
                targetBearing = robocode.util.Utils.normalRelativeAngle((double)(targetBearing - gunHeadingRadians));
                this.fireAtTime = this.time + (long)((int)Math.max(Math.abs(targetBearing) / Rules.GUN_TURN_RATE_RADIANS + 0.99, gunHeat / GUN_COOLING_RATE + 0.99));
                if (gunHeat == 0.0 && this.getEnergy() > 5.0) {
                    if (Math.abs(targetBearing) > 1.0E-4) {
                        this.turnGunRightRadians(targetBearing);
                    }
                    if (this.target != -1) {
                        this.fire(this.targets[this.target].power);
                    }
                    this.target = -1;
                    this.fireAtTime = this.getTime() + (long)((int)Math.max(8.0, this.getGunHeat() / GUN_COOLING_RATE + 0.99));
                    this.setTurnRadarRight(360.0);
                } else {
                    this.setTurnGunRightRadians(targetBearing);
                    double angle = robocode.util.Utils.normalRelativeAngle((double)(Math.atan2(this.targets[this.target].radarX - this.x, this.targets[this.target].radarY - this.y) - radarHeadingRadians));
                    this.setTurnRadarRightRadians(angle + (double)(angle > 0.0 ? 1 : -1) * this.pi / 8.0);
                }
            }
            this.execute();
        }
    }

    void prepareForGetAngleDanger() {
        int i = 0;
        while (i < this.n + 4) {
            double x1 = this.targets[i].scanX;
            double y1 = this.targets[i].scanY;
            double x2 = x1 + (double)(this.time - this.targets[i].scanTime) * this.targets[i].vx;
            double y2 = y1 + (double)(this.time - this.targets[i].scanTime) * this.targets[i].vy;
            double beta = robocode.util.Utils.normalAbsoluteAngle((double)Math.atan2(x1 - this.x, y1 - this.y));
            double gamma = robocode.util.Utils.normalAbsoluteAngle((double)Math.atan2(x2 - this.x, y2 - this.y));
            this.targets[i].getAngleDanger_beta = Math.min(beta, gamma);
            this.targets[i].getAngleDanger_gamma = Math.max(beta, gamma);
            this.targets[i].getAngleDanger_dist = Math.sqrt(Math.min(Math.pow(this.x - x1, 2.0) + Math.pow(this.y - y1, 2.0), Math.pow(this.x - x2, 2.0) + Math.pow(this.y - y2, 2.0)));
            ++i;
        }
        if (this.n <= this.NEAREST_ROBOT_TO_COUNT_CNT) {
            this.getAngleDanger_maxDist = Double.POSITIVE_INFINITY;
            return;
        }
        double[] d = new double[this.NEAREST_ROBOT_TO_COUNT_CNT];
        int i2 = 0;
        while (i2 < this.NEAREST_ROBOT_TO_COUNT_CNT) {
            d[i2] = Double.POSITIVE_INFINITY;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.n) {
            if (!(this.targets[i2].getAngleDanger_dist > d[this.NEAREST_ROBOT_TO_COUNT_CNT - 1])) {
                int j = 0;
                while (d[j] < this.targets[i2].getAngleDanger_dist) {
                    ++j;
                }
                int k = this.NEAREST_ROBOT_TO_COUNT_CNT - 1;
                while (k > j) {
                    d[k] = d[k - 1];
                    --k;
                }
                d[j] = this.targets[i2].getAngleDanger_dist;
            }
            ++i2;
        }
        this.getAngleDanger_maxDist = d[this.NEAREST_ROBOT_TO_COUNT_CNT - 1];
    }

    double getAngleDanger(double alpha, int dir) {
        alpha = robocode.util.Utils.normalAbsoluteAngle((double)(alpha + this.headingRadians));
        if (dir == -1) {
            alpha = robocode.util.Utils.normalAbsoluteAngle((double)(alpha + this.pi));
        }
        double minusAlpha = robocode.util.Utils.normalAbsoluteAngle((double)(alpha + this.pi));
        double xx = this.x + 40.0 * Math.sin(alpha);
        double yy = this.y + 40.0 * Math.cos(alpha);
        if (xx > this.width - this.offset || xx < this.offset || yy > this.height - this.offset || yy < this.offset) {
            return 1.0E15;
        }
        double res = (double)(Math.min(this.n, this.NEAREST_ROBOT_TO_COUNT_CNT) * 300) / (xx * xx + yy * yy + (this.prev_positions_sqrSum - 2.0 * (this.prev_positions_xSum * xx + this.prev_positions_ySum * yy)) / (double)this.PREV_POSITIONS_CNT);
        int i = 0;
        while (i < this.n + 4) {
            double beta = this.targets[i].getAngleDanger_beta;
            double gamma = this.targets[i].getAngleDanger_gamma;
            double dist = this.targets[i].getAngleDanger_dist;
            if (!(dist > this.getAngleDanger_maxDist)) {
                double fromEnemy;
                double toEnemy = Math.min(Math.abs(robocode.util.Utils.normalRelativeAngle((double)(alpha - beta))), Math.abs(robocode.util.Utils.normalRelativeAngle((double)(alpha - gamma))));
                double coef = 1.0 + (double)(toEnemy < (fromEnemy = Math.min(Math.abs(robocode.util.Utils.normalRelativeAngle((double)(minusAlpha - beta))), Math.abs(robocode.util.Utils.normalRelativeAngle((double)(minusAlpha - gamma))))) ? 1 : -1) / Math.pow(dist, 0.3);
                if (i >= this.n) {
                    coef /= 4.0;
                }
                res = gamma - beta <= this.pi && (alpha >= beta - 0.25 && alpha <= gamma + 0.25 || minusAlpha >= beta - 0.25 && minusAlpha <= gamma + 0.25) || gamma - beta >= this.pi && (alpha >= gamma - 0.25 || alpha <= beta + 0.25 || minusAlpha >= gamma - 0.25 || minusAlpha <= beta + 0.25) ? (res += 2.0 * coef) : (res += coef / Math.sqrt(Math.min(toEnemy, fromEnemy)));
            }
            ++i;
        }
        if (dir != this.direction) {
            res += Math.random() * (double)Math.min(this.n, this.NEAREST_ROBOT_TO_COUNT_CNT);
        }
        return res * (0.9 + 0.2 * Math.random());
    }

    double getPower(double dist, double energy) {
        double res = dist < 150.0 ? 3.0 : (dist < 300.0 ? 3.0 - (dist - 150.0) / 150.0 : (dist < 500.0 ? 2.0 - (dist - 300.0) / 200.0 : 100.0 / (dist - 400.0)));
        if (this.n > 4) {
            res = Math.min(3.0, res * (double)this.n / 4.5);
        }
        return Math.max(0.1, Math.min(res, energy / 3.0));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int x = 0;
        while (x < this.n && e.getName() != this.targets[x].name) {
            ++x;
        }
        if (x == this.n) {
            this.targets[this.n + 4] = this.targets[this.n];
            this.targets[this.n++] = new enemy(this, e.getName());
        }
        double angle = this.getHeadingRadians() + e.getBearingRadians();
        this.targets[x].scanTime = this.getTime();
        this.targets[x].scanX = this.getX() + e.getDistance() * Math.sin(angle);
        this.targets[x].scanY = this.getY() + e.getDistance() * Math.cos(angle);
        this.targets[x].vx = e.getVelocity() * Math.sin(e.getHeadingRadians());
        this.targets[x].vy = e.getVelocity() * Math.cos(e.getHeadingRadians());
        this.targets[x].power = this.getPower(e.getDistance(), e.getEnergy());
        this.targets[x].energy = e.getEnergy();
        this.targets[x].enemyStats.add(this.targets[x].scanTime, this.targets[x].scanX, this.targets[x].scanY, e.getHeadingRadians(), e.getVelocity(), this.n);
    }

    void recalculateTargets(int l, int r) {
        double dist = (double)(this.fireAtTime - this.time) * this.velocity;
        double deltaX = this.x + dist * Math.sin(this.headingRadians);
        double deltaY = this.y + dist * Math.cos(this.headingRadians);
        int i = l;
        while (i < r) {
            double vx = this.targets[i].vx;
            double vy = this.targets[i].vy;
            double timeTillFire = this.fireAtTime - this.targets[i].scanTime;
            double dx = this.targets[i].scanX + timeTillFire * vx - deltaX;
            double dy = this.targets[i].scanY + timeTillFire * vy - deltaY;
            double vb = Rules.getBulletSpeed((double)this.targets[i].power);
            double t = Utils.intersectWaveWithLinearMovement(dx, dy, vx, vy, vb, 0.0);
            double radarTimeDelta = this.radarTurnRemaining / 45.0 - timeTillFire;
            this.targets[i].radarX = deltaX + dx + vx * radarTimeDelta;
            this.targets[i].radarY = deltaY + dy + vy * radarTimeDelta;
            this.targets[i].x = deltaX + dx + vx * t;
            this.targets[i].y = deltaY + dy + vy * t;
            this.targets[i].t = t;
            ++i;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        --this.n;
        int i = 0;
        while (i <= this.n) {
            if (e.getName() == this.targets[i].name) {
                this.targets[i] = this.targets[this.n];
                if (this.target == i) {
                    this.target = -1;
                } else if (this.target == this.n) {
                    this.target = i;
                }
            }
            ++i;
        }
        this.targets[this.n] = this.targets[this.n + 4];
    }

    public void onRoundEnded(RoundEndedEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    void updateColor() {
        int energy = (int)this.getEnergy();
        Color c = energy >= 100 ? new Color(0, Math.max(455 - 2 * energy, 128), 0) : (energy >= 65 ? new Color(0, 255, 255 * (100 - energy) / 35) : (energy >= 25 ? new Color(255 * (65 - energy) / 40, 255, 255 * (energy - 25) / 40) : (energy >= 5 ? new Color(255, 255 * (energy - 5) / 20, 0) : new Color(255 * energy / 5, 0, 0))));
        this.setAllColors(c);
    }

    String generatePlacesCounts() {
        String counts = "";
        int i = 0;
        while (i <= robotsInBattle) {
            if (places[i] < 10) {
                counts = String.valueOf(counts) + " ";
            }
            counts = String.valueOf(counts) + places[i] + "  ";
            ++i;
        }
        return counts;
    }

    public void onDeath(DeathEvent e) {
        int n = this.getOthers();
        places[n] = places[n] + 1;
        String placesCounts = this.generatePlacesCounts();
        this.out.println("Place: " + placesHeader);
        this.out.println("Count: " + placesCounts);
    }

    public void onWin(WinEvent e) {
        places[0] = places[0] + 1;
        String placesCounts = this.generatePlacesCounts();
        this.out.println("Place: " + placesHeader);
        this.out.println("Count: " + placesCounts);
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, new Color(128, 0, 128)};
        this.stop();
        int i = 0;
        while (i < 6) {
            int k = 0;
            while (k < 5 + i % 2) {
                this.setAllColors(new Color(colors[i].getRed() + (colors[i + 1].getRed() - colors[i].getRed()) * k / 5, colors[i].getGreen() + (colors[i + 1].getGreen() - colors[i].getGreen()) * k / 5, colors[i].getBlue() + (colors[i + 1].getBlue() - colors[i].getBlue()) * k / 5));
                this.doNothing();
                ++k;
            }
            ++i;
        }
        this.n = 0;
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++this.skippedCount;
        ++skippedSum;
    }

    public void onPaint(Graphics2D g) {
        if (this.target == -1) {
            return;
        }
        g.setColor(Color.blue);
        g.drawLine((int)this.x, (int)this.y, (int)this.targets[this.target].x, (int)this.targets[this.target].y);
        this.targets[this.target].enemyStats.onPaint(g, this.targets[this.target].scanTime, this.targets[this.target].scanX, this.targets[this.target].scanY, Math.atan2(this.targets[this.target].vx, this.targets[this.target].vy), Math.hypot(this.targets[this.target].vx, this.targets[this.target].vy), this.n, this.x, this.y, this.headingRadians, this.velocity, this.time, this.fireAtTime, Rules.getBulletSpeed((double)this.targets[this.target].power));
    }
}

