/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnemyRobot
implements Comparable<EnemyRobot> {
    private String name;
    private Point2D position;
    private double heading;
    private double bearing;
    private double relative_bearing;
    private double heading_change;
    private double velocity;
    private double acceleration;
    private double distance;
    private double energy;
    private double old_energy;
    private long scanned;
    private long lastScanned;

    EnemyRobot(ScannedRobotEvent robot, double angle, Point2D reference_position) {
        this.name = robot.getName();
        this.old_energy = 100.0;
        this.energy = 100.0;
        this.heading = robot.getHeadingRadians();
        this.heading_change = 0.0;
        this.acceleration = 0.0;
        this.scanned = robot.getTime();
        this.lastScanned = 0L;
        this.position = new Point2D.Double();
        this.update(robot, angle, reference_position);
    }

    EnemyRobot(String name_in) {
        this.name = name_in;
    }

    public void update(ScannedRobotEvent robot, double angle, Point2D reference_position) {
        this.bearing = robot.getBearingRadians();
        this.relative_bearing = Utils.normalRelativeAngle((double)(angle + this.bearing));
        this.lastScanned = this.scanned;
        this.scanned = robot.getTime();
        this.heading_change = CustFunct.normaliseRelative(robot.getHeadingRadians() - this.heading) / (double)(this.scanned - this.lastScanned);
        this.heading = robot.getHeadingRadians();
        this.acceleration = (robot.getVelocity() - this.velocity) / (double)(this.scanned - this.lastScanned);
        this.distance = robot.getDistance();
        this.velocity = robot.getVelocity();
        this.old_energy = this.energy;
        this.energy = robot.getEnergy();
        this.position.setLocation(reference_position.getX() + Math.sin(this.relative_bearing) * this.distance, reference_position.getY() + Math.cos(this.relative_bearing) * this.distance);
    }

    @Override
    public int compareTo(EnemyRobot obj) throws ClassCastException {
        EnemyRobot robot_in = obj;
        return this.name.compareTo(robot_in.getName());
    }

    public boolean equals(EnemyRobot obj) throws ClassCastException {
        EnemyRobot robot_in = obj;
        return this.name.equals(robot_in.getName());
    }

    public Point2D getFuturePosition(long t) {
        if (Math.abs(this.getHeadingChange()) > 1.0E-5) {
            return this.getFutureCirc(t);
        }
        return this.getFutureLin(t);
    }

    public Point2D getFutureCirc(long t) {
        double arc_length = this.velocity / this.heading_change;
        double theta = (double)t * this.heading_change;
        double x = this.position.getX() + Math.cos(this.heading) * arc_length - Math.cos(this.heading + theta) * arc_length;
        double y = this.position.getY() + Math.sin(this.heading + theta) * arc_length - Math.sin(this.heading) * arc_length;
        return new Point2D.Double(x, y);
    }

    public Point2D getFutureLin(long t) {
        double x = this.position.getX() + Math.sin(this.heading) * this.velocity * (double)t;
        double y = this.position.getY() + Math.cos(this.heading) * this.velocity * (double)t;
        return new Point2D.Double(x, y);
    }

    public long getLastScan() {
        return this.scanned;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingChange() {
        return this.heading_change;
    }

    public long getScanDiff() {
        return this.scanned - this.lastScanned;
    }

    public boolean equals(ScannedRobotEvent enemy) {
        return enemy.getName().equals(this.name);
    }

    public Point2D getPosition() {
        return this.position;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double input) {
        this.energy = this.old_energy = input;
    }

    public double getEnergyChange() {
        return this.old_energy - this.energy;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getRelativeBearing() {
        return this.relative_bearing;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getScanned() {
        return this.lastScanned;
    }

    public String getName() {
        return this.name;
    }
}

