/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns;

import rdt.AgentSmith.Guns.Gun;
import rdt.AgentSmith.Guns.IClassifiedBulletListener;
import rdt.AgentSmith.Utils.MathUtils;
import rdt.AgentSmith.Waves.WaveData;
import robocode.Rules;
import robocode.util.Utils;

public final class BulletClassifier {
    private final Gun[] _guns;
    private final int _numGuns;

    public BulletClassifier(Gun[] guns) {
        this._guns = guns;
        this._numGuns = guns.length;
    }

    public void Classify(double hitX, double hitY, WaveData waveThatHit, IClassifiedBulletListener listener, double angleMatchRadians) {
        double sourceX = waveThatHit.OriginX;
        double sourceY = waveThatHit.OriginY;
        double bulletVelocity = Rules.getBulletSpeed((double)waveThatHit.Firepower);
        double actualBulletAngle = MathUtils.GetAngle(sourceX, sourceY, hitX, hitY);
        boolean anyGunClassified = false;
        for (int gunIndex = 0; gunIndex < this._numGuns; ++gunIndex) {
            Gun gun = this._guns[gunIndex];
            double gunAngle = gun.GetFiringAngle(sourceX, sourceY, waveThatHit.ActivationTick, bulletVelocity);
            double angleDiff = Math.abs(Utils.normalRelativeAngle((double)(gunAngle - actualBulletAngle)));
            boolean hit = angleDiff < angleMatchRadians;
            listener.OnBulletClassified(gun, gunIndex, hit, angleDiff);
            anyGunClassified |= hit;
        }
        if (!anyGunClassified) {
            listener.NoClassificationAvailable();
        }
    }
}

