/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import taqho.GameInfo;
import taqho.Logger;
import taqho.MathUtils;
import taqho.RobotData;

public class ScanManager {
    private int FULLSWEEP = 420;
    private final int SCAN_FULLSWEEP = 0;
    private final int SCAN_UNKNOWN = 1;
    private final int SCAN_ALLBOTS = 2;
    private final int SCAN_TARGET = 3;
    private final int SCAN_EXTENSION = 22;
    private final int AGE_INVALID_TARGET = 16;
    protected int direction = 1;
    protected AdvancedRobot robot = null;
    protected HashMap otherBots = new HashMap();
    protected RobotData currentTarget = null;
    protected RobotData lastTarget = null;
    protected double headingRadar;
    protected int scanMode = 0;
    protected int nextScanMode = 0;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public void log(String msg) {
        Logger.log("SM: " + msg);
    }

    public ScanManager() {
        this.robot = GameInfo.getRobot();
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
        this.log("Initialized");
    }

    public void updateTick() {
        this.headingRadar = this.robot.getRadarHeading();
    }

    public void scan() {
        this.scanMode = this.nextScanMode;
        switch (this.scanMode) {
            case 2: {
                if (Math.random() < 0.97) {
                    double toTurn;
                    Iterator robotIter = this.otherBots.values().iterator();
                    double maxBearing = 0.0;
                    double minBearing = this.FULLSWEEP;
                    double radarOffset = this.headingRadar - this.robot.getHeading();
                    while (robotIter.hasNext()) {
                        RobotData aRobot = (RobotData)robotIter.next();
                        if (!aRobot.isAlive) continue;
                        toTurn = MathUtils.reduceTo0to360(aRobot.bearingToMe.Get() - radarOffset);
                        if (toTurn > maxBearing) {
                            maxBearing = toTurn;
                        }
                        if (!(toTurn < minBearing)) continue;
                        minBearing = toTurn;
                    }
                    toTurn = 360.0 - maxBearing < minBearing ? minBearing - 360.0 - 22.0 : maxBearing + 22.0;
                    this.robot.setTurnRadarRight(toTurn);
                    break;
                }
            }
            case 0: {
                this.robot.setTurnRadarRight((double)(this.FULLSWEEP * this.toggleDirection()));
                break;
            }
            default: {
                this.nextScanMode = 0;
                this.robot.setTurnRadarRight((double)(this.FULLSWEEP * this.toggleDirection()));
            }
        }
        this.selectNextScanMode();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String robName = e.getName();
        if (this.otherBots.containsKey(robName)) {
            RobotData aRobot = (RobotData)this.otherBots.get(robName);
            aRobot.onScannedRobotEvent(e);
        } else {
            this.otherBots.put(robName, new RobotData(e));
            this.log("onScannedRobot: new robot >> " + robName);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.currentTarget != null && this.currentTarget.name == e.getName()) {
            this.currentTarget.isAlive = false;
        }
        this.currentTarget = null;
        this.log("RobotDeath: " + e.getName());
    }

    public void selectNextScanMode() {
        if (this.nextScanMode != 2 && this.getRobotsScanned() == GameInfo.getNumCompetitors()) {
            this.nextScanMode = 2;
        }
    }

    public void setNextScanMode(int nextMode) {
        this.nextScanMode = nextMode;
    }

    protected RobotData[] getTargetsLeft() {
        ArrayList<RobotData> list = new ArrayList<RobotData>();
        Iterator iter = this.otherBots.values().iterator();
        while (iter.hasNext()) {
            RobotData enemy = (RobotData)iter.next();
            if (!enemy.isAlive) continue;
            list.add(enemy);
        }
        RobotData[] enemies = new RobotData[list.size()];
        int i = 0;
        while (i < list.size()) {
            enemies[i] = (RobotData)list.get(i);
            ++i;
        }
        return enemies;
    }

    protected RobotData getNearestRobot() {
        RobotData nearestEnemy = null;
        Iterator iter = this.otherBots.values().iterator();
        double distance = 99999.0;
        double now = GameInfo.getRobot().getTime();
        while (iter.hasNext()) {
            double targetDistance;
            RobotData enemy = (RobotData)iter.next();
            if (!enemy.isAlive || now - enemy.getTimeUpdated() > 16.0 || !((targetDistance = enemy.distance) < distance)) continue;
            distance = targetDistance;
            nearestEnemy = enemy;
        }
        return nearestEnemy;
    }

    public int getRobotsScanned() {
        return this.otherBots.size();
    }

    public HashMap getOtherBots() {
        return this.otherBots;
    }

    protected RobotData getCurrentTarget() {
        if (this.currentTarget == null) {
            this.currentTarget = this.getATarget();
        }
        return this.currentTarget;
    }

    protected RobotData getATarget() {
        int numTargets = GameInfo.getOthers();
        RobotData mainThreat = this.getNearestRobot();
        if (mainThreat != null) {
            double nearestDistance = mainThreat.distance;
            double now = GameInfo.getRobot().getTime();
            if (nearestDistance > 30.0) {
                RobotData[] enemies = this.getTargetsLeft();
                double minDistance = 99999.0;
                int i = 0;
                while (i < enemies.length) {
                    RobotData target = enemies[i];
                    double distance = target.distance;
                    if (!(now - target.getTimeUpdated() > 16.0) && !(target.energy > 8.0) && distance < minDistance) {
                        mainThreat = target;
                        minDistance = distance;
                    }
                    ++i;
                }
            }
            if (this.currentTarget == null || !this.currentTarget.equals(mainThreat)) {
                this.currentTarget = mainThreat;
            }
        }
        if (mainThreat == null) {
            this.nextScanMode = 0;
        }
        this.currentTarget = mainThreat;
        return mainThreat;
    }

    private int toggleDirection() {
        this.direction = -this.direction;
        return this.direction;
    }
}

