/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.ConstantBotStats;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.DistanceLast15StatisticsA;
import Krabb.sliNk.DistanceLast15StatisticsB;
import Krabb.sliNk.DrawingBot;
import Krabb.sliNk.Garm;
import Krabb.sliNk.GunStatistics;
import Krabb.sliNk.KomariousMovementStatistics;
import Krabb.sliNk.MovementStatistics;
import Krabb.sliNk.MyBullet;
import Krabb.sliNk.MyWave;
import Krabb.sliNk.NormalDeptGunStatisticsA;
import Krabb.sliNk.NormalDeptGunStatisticsB;
import Krabb.sliNk.NormalGunStatisticsA;
import Krabb.sliNk.NormalGunStatisticsB;
import Krabb.sliNk.Stats;
import Krabb.sliNk.TimeSinceChangeGunStatisticsA;
import Krabb.sliNk.TimeSinceChangeGunStatisticsB;
import Krabb.sliNk.UnsegmentedGunStatistics;
import Krabb.sliNk.VelocityGunStatisticsA;
import Krabb.sliNk.VelocityGunStatisticsB;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Bot
extends ConstantBotStats {
    String name;
    int arrayindex = 0;
    static final int stats_dept = 30;
    int stats_pointer = -1;
    int stats_number = 0;
    Stats[] stats = new Stats[30];
    boolean death = false;
    boolean enemy = true;
    public LinkedList<MyWave> waves = new LinkedList();
    public LinkedList<MyWave> waves_display = new LinkedList();
    MyWave w0;
    MyWave w1;
    MyWave w2;
    MyWave w3;
    double hitrating = 0.0;
    ArrayList<MovementStatistics> statistics_movement = new ArrayList();
    ArrayList<GunStatistics> statistics_gun = new ArrayList();

    Bot(String name, Data robot) {
        this.enemy = !robot.isTeammate(name);
        this.name = name;
        if (!this.enemy) {
            return;
        }
        int gf_type_movestats = 0;
        MovementStatistics.statistics_n = 0;
        if (Garm.meleegame) {
            this.statistics_movement.add(new KomariousMovementStatistics(gf_type_movestats, 10.0));
        } else {
            this.statistics_movement.add(new KomariousMovementStatistics(gf_type_movestats, 1.0));
            this.statistics_movement.add(new KomariousMovementStatistics(gf_type_movestats, 200.0));
        }
        int gf_type_gunstats = 0;
        GunStatistics.statistics_n = 0;
        if (Garm.meleegame) {
            this.statistics_gun.add(new UnsegmentedGunStatistics(gf_type_gunstats, 1.0));
            this.statistics_gun.add(new NormalGunStatisticsA(gf_type_gunstats, 3.0));
            this.statistics_gun.add(new DistanceLast15StatisticsA(gf_type_gunstats, 8.0));
        } else {
            this.statistics_gun.add(new UnsegmentedGunStatistics(gf_type_gunstats, 1.0));
            this.statistics_gun.add(new VelocityGunStatisticsA(gf_type_gunstats, 99999.0));
            this.statistics_gun.add(new VelocityGunStatisticsB(gf_type_gunstats, 99999.0));
            this.statistics_gun.add(new NormalGunStatisticsA(gf_type_gunstats, 3.0));
            this.statistics_gun.add(new NormalGunStatisticsB(gf_type_gunstats, 3.0));
            this.statistics_gun.add(new NormalDeptGunStatisticsA(gf_type_gunstats, 10.0));
            this.statistics_gun.add(new NormalDeptGunStatisticsB(gf_type_gunstats, 10.0));
            this.statistics_gun.add(new TimeSinceChangeGunStatisticsA(gf_type_gunstats, 10.0));
            this.statistics_gun.add(new TimeSinceChangeGunStatisticsB(gf_type_gunstats, 10.0));
            this.statistics_gun.add(new DistanceLast15StatisticsA(gf_type_gunstats, 8.0));
            this.statistics_gun.add(new DistanceLast15StatisticsB(gf_type_gunstats, 15.0));
        }
        System.out.println("INFO: Movement buffers = " + GunStatistics.statistics_n);
        System.out.println("INFO: Gun buffers      = " + MovementStatistics.statistics_n);
    }

    public void newRound() {
        this.waves.clear();
        this.waves_display.clear();
        this.w3 = null;
        this.w2 = null;
        this.w1 = null;
        this.w0 = null;
        this.stats = new Stats[30];
        this.stats_pointer = -1;
        this.stats_number = 0;
        this.death = false;
        if (!this.enemy) {
            return;
        }
        System.out.println("INFO: Rating Gun1 = " + this.statistics_movement.get((int)0).buffer_rating * 100.0);
        if (this.statistics_movement.size() > 1) {
            System.out.println("INFO: Rating Gun2 = " + this.statistics_movement.get((int)1).buffer_rating * 100.0);
        }
        System.out.println("INFO: Shots       = " + this.statistics_movement.get((int)0).shots);
    }

    public void newStats(Stats stats_new, Stats stats_victim) {
        if (!stats_new.name.equals(this.name) || this.getNewestStats() != null && stats_new.time <= this.getNewestStats().time) {
            return;
        }
        stats_new.update(this.getNewestStats());
        this.stats_pointer = (this.stats_pointer + 1) % 30;
        this.stats[this.stats_pointer] = stats_new;
        ++this.stats_number;
        this.checkWallCollision();
        this.handleWaves(stats_victim);
        if (!Garm.meleegame && this.getStatsAtPos(1) != null && this.getNewestStats().time - this.getStatsAtPos((int)1).time > 1L) {
            System.out.println(String.valueOf(this.getNewestStats().time) + ": Missed Scan (" + (this.getNewestStats().time - this.getStatsAtPos((int)1).time) + ")");
        }
    }

    public void newBullet(MyBullet b) {
        int w = 0;
        while (w < this.waves.size()) {
            this.waves.get(w).createNewCollisionArea(b);
            ++w;
        }
    }

    private void checkWallCollision() {
        if (this.getNewestStats() == null || this.getStatsAtPos(1) == null) {
            return;
        }
        if (Math.abs(this.getNewestStats().velocity - this.getStatsAtPos((int)1).velocity) / (double)(this.getNewestStats().time - this.getStatsAtPos((int)1).time) > 2.0 && DataHandling.wallDistance(this.getNewestStats().location) <= 0.1) {
            this.newEnergyChange(-Math.max(Math.abs(this.getStatsAtPos((int)1).velocity) * 0.5 - 1.0, 0.0), this.getNewestStats().time);
        }
    }

    private void handleWaves(Stats victim_stats) {
        if (this.w0 == null) {
            this.w0 = new MyWave();
        }
        this.w0.setSegmentationStats(this.getNewestStats(), victim_stats);
        if (this.w1 != null) {
            this.w1.setStartStats(this.getNewestStats(), victim_stats);
        }
        if (this.w2 != null) {
            this.w2.setEndStats(this.getNewestStats(), victim_stats);
        }
        if (this.w2 != null) {
            this.releaseWave(this.w2, victim_stats.time);
        }
    }

    private void releaseWave(MyWave wave, long time) {
        wave.calculatePower();
        if (wave.power >= 0.0999 && wave.power <= 3.0) {
            wave.calculateSegmentation();
            int gun = 0;
            while (gun < this.statistics_gun.size()) {
                this.statistics_gun.get(gun).refreshBins(wave);
                ++gun;
            }
            this.newWave(wave);
            long time_delta = wave.source_stats_end.time - wave.source_stats_start.time;
            int STEP = 2;
            ArrayList<MyWave> waves_linked = new ArrayList<MyWave>();
            if (time_delta > (long)STEP) {
                double distance_source = wave.source_stats_start.location.distance(wave.source_stats_end.location);
                double distance_victim = wave.victim_stats_start[0].location.distance(wave.victim_stats_end[0].location);
                double angle = DataHandling.absoluteAngle(wave.source_stats_start.location, wave.source_stats_end.location);
                int wavenum = (int)((time_delta - 1L) / (long)STEP) + 1;
                wave.probability = 1.0 / (double)wavenum;
                int i = 1;
                while (i < wavenum) {
                    MyWave wave_new = wave.cloneMe();
                    wave_new.source_stats_start.location = DataHandling.project(wave.source_stats_start.location, angle, distance_source * (double)(i * STEP) / (double)time_delta);
                    wave_new.source_stats_start.time = wave.source_stats_start.time + (long)(i * STEP);
                    wave_new.source_stats_end.location = DataHandling.project(wave.source_stats_start.location, angle, distance_source * (double)(i * STEP + 1) / (double)time_delta);
                    wave_new.source_stats_end.time = wave.source_stats_start.time + (long)(i * STEP) + 1L;
                    wave_new.victim_stats_start[0].location = DataHandling.project(wave.victim_stats_start[0].location, angle, distance_victim * (double)(i * STEP) / (double)time_delta);
                    wave_new.victim_stats_start[0].time = wave.victim_stats_start[0].time + (long)(i * STEP);
                    wave_new.victim_stats_end[0].location = DataHandling.project(wave.victim_stats_start[0].location, angle, distance_victim * (double)(i * STEP + 1) / (double)time_delta);
                    wave_new.victim_stats_end[0].time = wave.victim_stats_start[0].time + (long)(i * STEP) + 1L;
                    DrawingBot.drawBigPoint(wave.source_stats_start.location, Color.RED);
                    DrawingBot.drawBigPoint(wave.source_stats_end.location, Color.RED);
                    DrawingBot.drawBigPoint(wave_new.source_stats_start.location, Color.CYAN);
                    wave_new.last = i == wavenum - 1;
                    wave_new.waves_linked = waves_linked;
                    waves_linked.add(wave_new);
                    this.newWave(wave_new);
                    ++i;
                }
                wave.last = false;
                wave.source_stats_end.location = DataHandling.project(wave.source_stats_start.location, angle, distance_source / (double)time_delta);
                wave.source_stats_end.time = wave.source_stats_start.time + 1L;
                wave.waves_linked = waves_linked;
                waves_linked.add(wave);
            }
        } else if (wave.power > 0.0 && !Garm.meleegame) {
            System.out.println("new wave with power = " + wave.power);
            System.out.println("Energy0 = " + wave.source_stats_start.energy + " energy1 = " + wave.source_stats_end.energy);
        }
    }

    public void updateWave(long time_current, Data data) {
        this.updateOldWaves(time_current, data);
        this.shiftNewWaves();
    }

    private void updateOldWaves(long time_current, Data data) {
        int i = 0;
        while (i < this.waves.size()) {
            MyWave wave = this.waves.get(i);
            wave.updateBulletCollisionArea(time_current);
            long time_delta = time_current - wave.source_stats_start.time;
            double distance_flight = wave.velocity * (double)time_delta;
            double distance_source = wave.source_stats_start.location.distance(Data.stats_my.location);
            double distance_delta = distance_source - distance_flight;
            if (distance_delta < -25.5 - wave.velocity) {
                this.waves.remove(i--);
            }
            ++i;
        }
    }

    private void shiftNewWaves() {
        if (this.w0 == null) {
            return;
        }
        this.w3 = this.w2;
        this.w2 = this.w1;
        this.w1 = this.w0;
        this.w0 = null;
    }

    private void newWave(MyWave wave) {
        this.waves.add(wave);
        int b = 0;
        while (b < Data._bullets.size()) {
            wave.createNewCollisionArea(Data._bullets.get(b));
            ++b;
        }
    }

    public void hitRobot(HitByBulletEvent event) {
        this.newEnergyChange(event.getPower() * 3.0, event.getTime());
        MyWave wave = this.getWave(event.getBullet(), event.getTime());
        if (wave == null) {
            System.out.println("  In hitRobot");
        } else {
            wave.newHit(event);
            this.newGunStatistics(wave);
            this.removeWave(wave);
        }
        this.refreshWaveBins();
    }

    private void refreshWaveBins() {
        int gun = 0;
        while (gun < this.statistics_gun.size()) {
            int w = 0;
            while (w < this.waves.size()) {
                this.statistics_gun.get(gun).refreshBins(this.waves.get(w));
                ++w;
            }
            ++gun;
        }
    }

    public void hitByBullet(BulletHitEvent event) {
        this.newEnergy(event.getEnergy(), DataHandling.getDamage(event.getBullet().getPower()), event.getTime());
    }

    public void bulletHitBullet(BulletHitBulletEvent event) {
        MyWave wave = this.getWave(event.getHitBullet(), event.getTime());
        if (wave == null) {
            System.out.println("  In bulletHitBullet");
        } else {
            wave.newBulletHitBullet(event);
            this.newGunStatistics(wave);
            for (MyWave w : this.waves) {
                w.removeCollisionArea(event.getBullet());
            }
        }
        this.refreshWaveBins();
    }

    public double getRisc(MyWave wave, Point2D.Double location, long time, double[][] gf_hit, boolean debug) {
        double risc = 0.0;
        if (wave.hitbullet) {
            return 0.0;
        }
        if (gf_hit == null) {
            return 0.0;
        }
        double risc_new = 0.0;
        double damage = DataHandling.getDamage(wave.power) + DataHandling.getEnergyGain(wave.power);
        int s = 0;
        while (s < GunStatistics.statistics_n) {
            GunStatistics statistics = this.statistics_gun.get(s);
            double ristc_current = statistics.getDanger(wave, gf_hit, debug);
            risc_new = ristc_current + risc_new * (1.0 - ristc_current);
            ++s;
        }
        return risc += risc_new * damage * wave.probability;
    }

    public ArrayList<MyWave> getFirstWaves() {
        ArrayList<MyWave> waves_first = new ArrayList<MyWave>();
        waves_first.addAll(this.waves);
        Collections.sort(waves_first);
        int w = 0;
        while (w < waves_first.size()) {
            MyWave wave = waves_first.get(w);
            if (wave.hitbullet || wave.hit[0]) {
                waves_first.remove(wave);
                --w;
            }
            ++w;
        }
        return waves_first;
    }

    private MyWave getWave(Bullet b, long event_time) {
        MyWave wave_best = null;
        double best = 9.9999999E7;
        int i = 0;
        while (i < this.waves.size()) {
            double current;
            MyWave wave_current = this.waves.get(i);
            long time = event_time - wave_current.source_stats_start.time;
            double distance_flight = wave_current.velocity * (double)time;
            double distance_source = wave_current.source_stats_start.location.distance(b.getX(), b.getY());
            double power_diff = b.getPower() - wave_current.power;
            double distance_diff = distance_flight - distance_source;
            if (!(Math.abs(power_diff) > 0.1) && !(Math.abs(distance_diff) > 30.0) && (current = Math.pow(power_diff * 100.0, 2.0) + Math.pow(distance_diff, 2.0)) < best) {
                best = current;
                wave_best = wave_current;
            }
            ++i;
        }
        if (wave_best == null) {
            System.out.println("ERROR:  No matching wave found!! size=" + this.waves.size() + " power= " + b.getPower() + " velocity= " + b.getVelocity());
        }
        return wave_best;
    }

    private void removeWave(MyWave w) {
        if (w.waves_linked != null) {
            int i = 0;
            while (i < w.waves_linked.size()) {
                this.waves.remove(w.waves_linked.get(i));
                ++i;
            }
            w.waves_linked.clear();
        } else {
            this.waves.remove(w);
        }
    }

    public void newEnergyChange(double energy_change, long time) {
        if (this.w2 != null && this.w2.source_stats_start != null && time > this.w2.source_stats_start.time) {
            this.w2.newEnergyChange(energy_change, time);
        }
    }

    public void newEnergy(double energy, double damage, long time) {
        if (this.w2 != null && this.w2.source_stats_start != null && time > this.w2.source_stats_start.time) {
            this.w2.newEnergy(energy, damage, time);
        }
    }

    public Stats getNewestStats() {
        if (this.stats_pointer < 0) {
            return null;
        }
        return this.stats[this.stats_pointer % 30];
    }

    public Stats getStatsAtPos(int i) {
        if (this.stats_pointer < 0) {
            return null;
        }
        return this.stats[(this.stats_pointer - i + 30) % 30];
    }

    public Stats getTimeStats(long time) {
        if (this.stats_pointer < 0 || this.stats[this.stats_pointer].time - time > 30L) {
            return null;
        }
        return this.stats[(int)((time - this.stats[this.stats_pointer].time + 30L) % 30L)];
    }

    public void onPaint(Graphics2D g, Color color, Garm robot) {
        g.setColor(color);
        Stats s = this.getNewestStats();
        if (s == null || this.death) {
            return;
        }
        g.draw3DRect((int)s.location.x - 18, (int)s.location.y - 18, 36, 36, false);
        if (!this.enemy) {
            return;
        }
        int i = 0;
        while (i < this.waves.size()) {
            this.waves.get(i).onPaint(g, robot.getTime());
            ++i;
        }
        i = 0;
        while (i < this.waves_display.size()) {
            this.waves_display.get(i).onPaint(g, robot.getTime());
            ++i;
        }
        this.statistics_movement.get(MovementStatistics.statistics_draw).onPaint(g, robot);
    }

    public void newMovementStatisticsHit(MyBullet bullet, int enemy) {
        int i = 0;
        while (i < this.statistics_movement.size()) {
            this.statistics_movement.get(i).newHit(bullet, enemy);
            ++i;
        }
    }

    public void newMovementStatisticsUpdate(MyBullet bullet, int enemy) {
        int i = 0;
        while (i < this.statistics_movement.size()) {
            this.statistics_movement.get(i).newHitareaUpdate(bullet, enemy);
            ++i;
        }
    }

    private void newGunStatistics(MyWave wave) {
        int i = 0;
        while (i < GunStatistics.statistics_n) {
            this.statistics_gun.get(i).newHit(wave);
            ++i;
        }
    }
}

