/*
 * Decompiled with CFR 0.152.
 */
package ntc;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Swim
extends AdvancedRobot {
    private static final double INF = Double.POSITIVE_INFINITY;
    private static final double HALF_PI = 1.5707963267948966;
    static final int BINS = 31;
    private static final double[] wsdata = new double[31];
    private static final ArrayList<Wave> waves = new ArrayList();
    private static final Rectangle2D.Double field = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    private static double myLatVel = 1.0;
    private static double myVel = 1.0;
    private static double enemyEnergy;
    private static double WSForce;
    private static Wave curWave;
    static final Random r;

    static {
        r = new Random();
    }

    public void run() {
        waves.clear();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double turn;
        double d;
        double d2;
        Wave w = new Wave();
        double x = this.getX();
        double y = this.getY();
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        if (this.getVelocity() == 0.0) {
            d2 = myLatVel;
        } else {
            myVel = this.getVelocity();
            d2 = myLatVel = myVel * Math.sin(e.getBearingRadians());
        }
        double wdir = w.dir = Math.signum(d2);
        double d3 = enemyEnergy;
        enemyEnergy = e.getEnergy();
        double delta = d3 - enemyEnergy;
        if (d > 0.09 && delta < 3.01) {
            this.addCustomEvent(w);
            waves.add(w);
            w.bDist = w.bulletSpeed = Rules.getBulletSpeed((double)delta);
            w.absBearing = absBearing + wdir * 0.03 + Math.PI;
            w.firePos = Swim.project(absBearing, e.getDistance(), x, y);
        }
        double diveAngle = turn = absBearing + 1.5707963267948966 - 0.5 * wdir;
        while (!field.contains(Swim.project(turn += 0.01 * wdir, 35.0 * myVel, x, y))) {
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(turn - this.getHeadingRadians())));
        WSForce += (diveAngle - turn) * 0.5;
        int sw = waves.size();
        while (--sw >= 0) {
            curWave = waves.get(sw);
            int b = 30;
            while (b >= 0) {
                int GFdiff = Swim.curWave.curIndex - b;
                if (GFdiff != 0) {
                    WSForce += wsdata[b] / (double)GFdiff * Swim.curWave.dir / (double)(sw + 1);
                }
                --b;
            }
        }
        WSForce = Math.signum(WSForce) * 0.4;
        this.setAhead(WSForce * wdir * myVel * Double.POSITIVE_INFINITY);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + r.nextGaussian() * 0.3 - this.getGunHeadingRadians())));
        this.setFire(1.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        int index = Swim.curWave.curIndex;
        int i = 30;
        while (i >= 0) {
            Swim.wsdata[i] = wsdata[i] * 0.98 + Math.exp(-Math.abs(index - i));
            --i;
        }
        Swim.curWave.bDist = Double.POSITIVE_INFINITY;
        enemyEnergy += e.getPower() * 3.0;
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy = e.getEnergy();
    }

    private static final Point2D.Double project(double angle, double dist, double x, double y) {
        return new Point2D.Double(x + Math.sin(angle) * dist, y + Math.cos(angle) * dist);
    }

    class Wave
    extends Condition {
        Point2D.Double firePos;
        double absBearing;
        double bDist;
        double dir;
        double bulletSpeed;
        int curIndex;

        public boolean test() {
            double x = Swim.this.getX();
            Point2D.Double fPos = this.firePos;
            double y = Swim.this.getY();
            this.curIndex = (int)(Utils.normalRelativeAngle((double)(Math.atan2(x - fPos.x, y - fPos.y) - this.absBearing)) * this.dir / Math.asin(8.0 / this.bulletSpeed) * 15.0) + 15;
            if ((int)((this.bDist += this.bulletSpeed) - fPos.distance(x, y)) > 48) {
                Swim.this.removeCustomEvent(this);
                waves.remove((Object)this);
            }
            return false;
        }
    }
}

