/*
 * Decompiled with CFR 0.152.
 */
package ethdsy;

import ethdsy.CircularFire;
import ethdsy.FireStat;
import ethdsy.FireStrategy;
import ethdsy.FireStrategyMessage;
import ethdsy.MessageBase;
import ethdsy.MessageLocation;
import ethdsy.MoveStrategy;
import ethdsy.OldSpeedDiffFireStrategy;
import ethdsy.PredictiveFireStrategy;
import ethdsy.RandomOffsetAJ;
import ethdsy.RobotInfo;
import ethdsy.SectorMessage;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class Malacka
extends TeamRobot {
    public static final boolean DEBUG = false;
    public static final boolean teamPlay = false;
    public static final int WALL_DISTANCE = 50;
    HashMap map;
    RobotInfo target;
    final double PI = Math.PI;
    double firePower;
    RobotInfo[] access;
    boolean hasDied;
    static Random random = new Random();
    public static final int CLOSE = 50;
    public static final int MEDIUM = 250;
    int dIndex;
    static Vector moves;
    static MoveStrategy currentMove;
    static double totalChance;
    static Vector fires;
    static FireStrategy currentFire;
    HashMap deadBots = new HashMap();
    static HashMap store;
    HashMap bullets = new HashMap();
    Vector messages = new Vector(30);
    long lastMsg = 0L;
    int teamNumber = 0;
    boolean sectorConflict = false;

    public Malacka() {
        int n = 0;
        while (n < moves.size()) {
            ((MoveStrategy)moves.get(n)).setup(this);
            ++n;
        }
        int n2 = 0;
        while (n2 < fires.size()) {
            ((FireStrategy)fires.get(n2)).setup(this);
            ++n2;
        }
    }

    public void run() {
        this.setColors(Color.blue, Color.gray, Color.cyan);
        this.map = new HashMap(this.getOthers());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent(new Condition("closeToWall"){

            public boolean test() {
                return Malacka.this.getVelocity() > 0.0 && (Malacka.this.getX() < 50.0 && Malacka.this.getHeading() > 180.0 || Malacka.this.getY() < 50.0 && Malacka.this.getHeading() > 90.0 && Malacka.this.getHeading() < 270.0 || Malacka.this.getX() > Malacka.this.getBattleFieldWidth() - 50.0 && Malacka.this.getHeading() < 180.0 || Malacka.this.getY() > Malacka.this.getBattleFieldHeight() - 50.0 && (Malacka.this.getHeading() < 90.0 || Malacka.this.getHeading() > 270.0));
            }
        });
        this.turnRadarRight(720.0);
        while (true) {
            this.changeStrategy();
            this.doScan();
            this.chooseTarget();
            this.doMove();
            if (this.target != null) {
                Bullet bullet;
                this.getFirePower();
                this.doGun();
                if (this.getOthers() != 0 && this.angleDiff() && (bullet = this.fireBullet(this.firePower)) != null) {
                    this.target.addBulletTry();
                    this.bullets.put(bullet, this.target.fireStat[this.dIndex][this.target.currentFire[this.dIndex]]);
                }
            }
            this.execute();
            if (!this.hasDied) continue;
            this.target = null;
            this.hasDied = false;
        }
    }

    private boolean angleDiff() {
        if (this.target.ctime - this.getTime() > 5L) {
            return false;
        }
        double d = Math.abs(this.NormaliseBearing(this.target.guessedBearing - this.getGunHeadingRadians()));
        if (this.target.distance < 180.0) {
            return d < 0.25;
        }
        if (this.target.fireX < 0.0 || this.target.fireY < 0.0 || this.target.fireX > this.getBattleFieldWidth() || this.target.fireY > this.getBattleFieldHeight()) {
            return false;
        }
        return d < 0.15;
    }

    public void processMessages() {
        MessageBase[] messageBaseArray = this.messages.toArray(new MessageBase[this.messages.size()]);
        this.messages.clear();
        int n = 0;
        while (n < messageBaseArray.length) {
            RobotInfo robotInfo = this.getRobotInfo(messageBaseArray[n].name);
            if (robotInfo != null) {
                MessageBase messageBase;
                if (messageBaseArray[n] instanceof FireStrategyMessage) {
                    messageBase = (FireStrategyMessage)messageBaseArray[n];
                    ((FireStrategyMessage)messageBase).update(robotInfo.fireStat[this.dIndex][robotInfo.currentFire[this.dIndex]]);
                } else if (messageBaseArray[n] instanceof SectorMessage) {
                    if (this.target != null) {
                        messageBase = (SectorMessage)messageBaseArray[n];
                        if (((SectorMessage)messageBase).from < this.teamNumber && ((SectorMessage)messageBase).sector == this.getSector() && this.target.name.equals(messageBase.name)) {
                            this.sectorConflict = true;
                        }
                    }
                } else {
                    messageBase = (MessageLocation)messageBaseArray[n];
                    if (((MessageLocation)messageBase).ctime - robotInfo.ctime > 0L) {
                        ((MessageLocation)messageBase).updateInfo(robotInfo);
                    }
                }
            }
            ++n;
        }
    }

    public void doScan() {
        if (this.getOthers() == 1 || this.target != null && this.target.distance < 200.0) {
            double d;
            d = this.target == null || this.getTime() - this.target.ctime > 4L ? 360.0 : ((d = this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y)) < 0.0 ? (d -= 0.39269908169872414) : (d += 0.39269908169872414));
            this.setTurnRadarLeftRadians(this.NormaliseBearing(d));
        } else {
            this.setTurnRadarRight(10000.0);
        }
    }

    public void doMove() {
        currentMove.doMove();
    }

    void doGun() {
        this.target.guessedBearing = currentFire.doGun();
        double d = this.getGunHeadingRadians() - this.target.guessedBearing;
        this.setTurnGunLeftRadians(this.NormaliseBearing(d));
    }

    public void chooseTarget() {
        if (this.access == null) {
            this.access = this.map.values().toArray(new RobotInfo[this.map.size()]);
        }
        if (this.access.length == 1) {
            this.target = this.access[0];
            this.newTarget();
            return;
        }
        double d = -1.0;
        RobotInfo robotInfo = null;
        int n = 0;
        while (n < this.access.length) {
            RobotInfo robotInfo2 = this.access[n];
            double d2 = robotInfo2.getValue();
            if (this.target == robotInfo2) {
                d2 += 400.0;
            }
            if (d2 > d) {
                d = d2;
                robotInfo = robotInfo2;
            }
            ++n;
        }
        this.lastMsg = this.getTime();
        this.target = robotInfo == null && this.access.length > 0 ? this.access[0] : robotInfo;
        this.newTarget();
    }

    private void newTarget() {
        if (this.target != null) {
            this.dIndex = 2;
            if (this.target.distance < 50.0) {
                this.dIndex = 0;
            } else if (this.target.distance < 50.0) {
                this.dIndex = 1;
            }
            currentFire = (FireStrategy)fires.get(this.target.currentFire[this.dIndex]);
        }
    }

    private void sendMessage(MessageBase messageBase) {
        try {
            this.broadcastMessage(messageBase);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void getFirePower() {
        this.firePower = this.getEnergy() <= 3.0 ? 0.2 : (this.target.distance > 600.0 ? 0.5 : (this.target.distance < 250.0 ? 3.0 : 1.1));
        if (this.target.energy < 0.4) {
            this.firePower = 0.1;
        } else if (this.target.energy < this.firePower * 4.0) {
            this.firePower = this.target.energy / 4.0;
        }
    }

    public void changeStrategy() {
        if (currentMove.isChangeNeeded()) {
            currentMove.resetDamage();
            totalChance -= Malacka.currentMove.chances;
            Malacka.currentMove.chances = this.calculateChances(Malacka.currentMove.stat, Malacka.currentMove.nb);
            double d = random.nextDouble() * (totalChance += Malacka.currentMove.chances);
            currentMove = (MoveStrategy)moves.get(0);
            int n = 1;
            while (d > Malacka.currentMove.chances) {
                d -= Malacka.currentMove.chances;
                currentMove = (MoveStrategy)moves.get(n);
                ++n;
            }
            ++Malacka.currentMove.nb;
        }
        if (this.target == null) {
            currentFire = (FireStrategy)fires.get(0);
            return;
        }
        FireStat fireStat = this.target.fireStat[this.dIndex][this.target.currentFire[this.dIndex]];
        if (fireStat.isChangeNeeded()) {
            fireStat.resetAccuracy();
            double d = 0.0;
            this.target.currentFire[this.dIndex] = 0;
            int n = 0;
            while (n < fires.size()) {
                fireStat = this.target.fireStat[this.dIndex][n];
                if (fireStat.getAccuracy() > d) {
                    d = fireStat.getAccuracy();
                    this.target.currentFire[this.dIndex] = n;
                }
                ++n;
            }
            ++this.target.fireStat[this.dIndex][this.target.currentFire[this.dIndex]].nb;
            currentFire = (FireStrategy)fires.get(this.target.currentFire[this.dIndex]);
        }
    }

    double NormaliseBearing(double d) {
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    double NormaliseHeading(double d) {
        if (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public double getrange(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        return d7;
    }

    public double absbearing(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = this.getrange(d, d2, d3, d4);
        if (d5 > 0.0 && d6 > 0.0) {
            return Math.asin(d5 / d7);
        }
        if (d5 > 0.0 && d6 < 0.0) {
            return Math.PI - Math.asin(d5 / d7);
        }
        if (d5 < 0.0 && d6 < 0.0) {
            return Math.PI + Math.asin(-d5 / d7);
        }
        if (d5 < 0.0 && d6 > 0.0) {
            return Math.PI * 2 - Math.asin(-d5 / d7);
        }
        return 0.0;
    }

    private RobotInfo getRobotInfo(String string) {
        RobotInfo robotInfo = (RobotInfo)this.map.get(string);
        if (robotInfo == null) {
            robotInfo = (RobotInfo)store.remove(string);
            if (robotInfo != null) {
                robotInfo.me = this;
            } else {
                robotInfo = (RobotInfo)this.deadBots.get(string);
                if (robotInfo == null) {
                    robotInfo = new RobotInfo(string, this);
                } else {
                    return null;
                }
            }
            this.map.put(string, robotInfo);
            this.access = null;
        }
        return robotInfo;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        RobotInfo robotInfo = this.getRobotInfo(scannedRobotEvent.getName());
        if (robotInfo == null) {
            return;
        }
        double d = (this.getHeadingRadians() + scannedRobotEvent.getBearingRadians()) % (Math.PI * 2);
        robotInfo.setPos(this.getX() + Math.sin(d) * scannedRobotEvent.getDistance(), this.getY() + Math.cos(d) * scannedRobotEvent.getDistance());
        robotInfo.setBearing(scannedRobotEvent.getBearingRadians());
        robotInfo.setHead(scannedRobotEvent.getHeadingRadians());
        robotInfo.setTime(this.getTime());
        robotInfo.setSpeed(scannedRobotEvent.getVelocity());
        robotInfo.setDistance(scannedRobotEvent.getDistance());
        robotInfo.setEnergy(scannedRobotEvent.getEnergy());
    }

    public void onMessageReceived(MessageEvent messageEvent) {
        this.messages.add(messageEvent.getMessage());
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.deadBots.put(robotDeathEvent.getName(), this.map.remove(robotDeathEvent.getName()));
        this.access = null;
        if (this.target != null && robotDeathEvent.getName().equals(this.target.name)) {
            this.hasDied = true;
            this.setTurnRadarRight(10000.0);
        }
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        RobotInfo robotInfo;
        if (!hitRobotEvent.isMyFault() && (robotInfo = (RobotInfo)this.map.get(hitRobotEvent.getName())) != null) {
            robotInfo.distance = 1.0;
            robotInfo.guessedBearing = (this.getHeadingRadians() + robotInfo.bearing) % (Math.PI * 2);
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        RobotInfo robotInfo = (RobotInfo)this.map.get(hitByBulletEvent.getName());
        if (robotInfo != null) {
            robotInfo.addBulletHit();
        }
        currentMove.incDamage(hitByBulletEvent.getPower());
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        RobotInfo robotInfo = (RobotInfo)this.map.get(bulletHitEvent.getName());
        if (robotInfo != null) {
            robotInfo.removeBulletHit();
            robotInfo.setEnergy(bulletHitEvent.getEnergy());
            robotInfo.removeBulletTry();
        }
        Bullet bullet = bulletHitEvent.getBullet();
        FireStat fireStat = (FireStat)this.bullets.get(bullet);
        double d = bullet.getPower() * 4.0;
        Malacka.currentMove.stat += d;
        currentMove.decDamage(bullet.getPower());
        if (fireStat == null) {
            return;
        }
        if (fireStat.owner == robotInfo) {
            fireStat.incAccuracy();
        } else {
            fireStat.decAccuracy();
        }
        this.bullets.remove(bullet);
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        Bullet bullet = bulletMissedEvent.getBullet();
        FireStat fireStat = (FireStat)this.bullets.get(bullet);
        fireStat.decAccuracy();
        this.bullets.remove(bullet);
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.bullets.remove(bulletHitBulletEvent.getBullet());
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        if (Math.abs(hitWallEvent.getBearing()) < 90.0) {
            this.setAhead(-300.0);
        } else {
            this.setAhead(300.0);
        }
    }

    public void onCustomEvent(CustomEvent customEvent) {
        this.setAhead(0.0);
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        System.out.println("SKIPPED TURN");
    }

    public void onDeath(DeathEvent deathEvent) {
        this.moveLiveBots();
        this.printStats();
        currentMove.resetDamage();
    }

    public void onWin(WinEvent winEvent) {
        this.moveLiveBots();
        Malacka.currentMove.stat += 50.0;
        this.printStats();
    }

    private void moveLiveBots() {
        store.putAll(this.map);
        store.putAll(this.deadBots);
        this.map.clear();
        Iterator iterator = store.values().iterator();
        while (iterator.hasNext()) {
            RobotInfo robotInfo = (RobotInfo)iterator.next();
            if (robotInfo == null) continue;
            robotInfo.reset();
        }
    }

    public void printStats() {
    }

    private double calculateChances(double d, int n) {
        if (n == 1 && d < 10.0) {
            return 50.0;
        }
        if (this.getOthers() > 1) {
            return d / (double)n;
        }
        double d2 = d / (double)n / 100.0;
        d2 *= d2 * 100.0;
        return d2;
    }

    int getSector() {
        return (int)((this.target.bearing + this.getHeadingRadians()) * 4.0 / Math.PI + 4.0) % 8;
    }

    static {
        store = new HashMap();
        moves = new Vector();
        moves.add(new RandomOffsetAJ());
        totalChance = moves.size() * 100;
        currentMove = (MoveStrategy)moves.get(0);
        ++Malacka.currentMove.nb;
        fires = new Vector();
        fires.add(new CircularFire());
        fires.add(new PredictiveFireStrategy());
        fires.add(new OldSpeedDiffFireStrategy());
    }
}

