/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.ISubsystemMode;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import robocode.util.Utils;

public class FinisherMode
implements ISubsystemMode,
IRoundStartedEventHandler {
    private final IRobot _robot;
    private final ITargeting _targeting;
    private double _nextFirePower;
    private long _nextFireTurn;
    private final double[] _bulletAngle = new double[1];

    public FinisherMode(IRobot robot, ITargeting targeting) {
        this._robot = robot;
        this._targeting = targeting;
        this._robot.RegisterForEventHandling(this);
    }

    @Override
    public void UpdateHighestPriority() {
        if (!this._targeting.HasValidTarget()) {
            return;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return;
        }
        if (this._robot.getEnergy() <= 0.0) {
            return;
        }
        if (this._robot.getTime() - target.LastUpdatedTick > 3L) {
            return;
        }
        if (this._robot.getTime() <= 3L) {
            return;
        }
        this._nextFirePower = 0.1;
        if (this._nextFirePower <= 0.0) {
            return;
        }
        if (this._nextFireTurn == this._robot.getTime() && this._robot.getGunTurnRemaining() == 0.0 && this._robot.getGunHeat() <= 0.0) {
            this._robot.setFire(this._nextFirePower);
            return;
        }
        long safePredictedTick = target.GetSafePredictedTick(this._robot.getTime() + 1L);
        RobotSnapshot targetSnapshot = target.RobotSnapshots.Read(safePredictedTick);
        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetSnapshot.AbsoluteAngleFromOpponent - this._robot.getGunHeadingRadians())));
        this._nextFireTurn = this._robot.getTime() + 1L;
    }

    @Override
    public float GetPriority() {
        if (!this._targeting.HasValidTarget()) {
            return 0.0f;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return 0.0f;
        }
        if (this._robot.getEnergy() <= 0.0) {
            return 0.0f;
        }
        if (this._robot.getTime() - target.LastUpdatedTick > 3L) {
            return 0.0f;
        }
        if (this._robot.getTime() <= 3L) {
            return 0.0f;
        }
        if (!target.Disabled) {
            return 0.0f;
        }
        return 100.0f;
    }

    @Override
    public void Update() {
    }

    @Override
    public void OnRoundStartedEvent() {
        this._nextFireTurn = -1L;
    }
}

