/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.bothandling.Gunner;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.Move;
import alk.lap.strategy.ScanRecord;
import alk.lap.strategy.StatisticBullet;
import alk.lap.strategy.StatisticWave;
import alk.lap.strategy.VirtualBattleField;
import alk.lap.strategy.VirtualBullet;
import alk.lap.strategy.analysis.EnemyFireAnalyst;
import alk.lap.strategy.analysis.TargetStrategyStatistic;
import alk.lap.strategy.targetting.BearingTargeting;
import alk.lap.strategy.targetting.BulletBeam;
import alk.lap.strategy.targetting.LinearTargeting;
import alk.lap.strategy.targetting.OccurenceTargeting;
import alk.lap.strategy.targetting.StatBasedLinTargeting;
import alk.lap.strategy.targetting.StatBearingTargeting;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.VirtualCanvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TacticalLead {
    public static final boolean DRAW_BEAM = true;
    private static final double MINIMAL_DISTANCE = 250.0;
    private static final double RATE_AT_ECENTER = 170.0;
    public static final int RESPECTED_TARGETSTRATS = 2;
    private LoudAndProud proud;
    private ScanRecord lastScan = null;
    private ScanRecord currentScan = null;
    private Vector<FireWave> fireWaves = new Vector();
    private Vector<VirtualBullet> virtualBullets = new Vector();
    private VirtualBattleField vBattlefield;
    private EnemyFireAnalyst enemyFireAnalyst;
    private double enemysLastFirePower;
    private TargetStrategy[] enemyTargetStrategies;
    private BearingTargeting bt;
    private boolean hitThisRound = false;

    public TacticalLead(LoudAndProud proud) {
        this.proud = proud;
        this.lastScan = null;
        this.hitThisRound = false;
        this.vBattlefield = new VirtualBattleField(proud);
        this.enemysLastFirePower = 3.0;
        this.enemyFireAnalyst = new EnemyFireAnalyst(proud);
        this.enemyTargetStrategies = new TargetStrategy[]{new BearingTargeting(), new LinearTargeting(), new StatBasedLinTargeting(), new OccurenceTargeting(), new StatBearingTargeting(StatisticBullet.BulletType.WAVE), new StatBearingTargeting(StatisticBullet.BulletType.CONTINOUS)};
        int i = 0;
        while (i < this.enemyTargetStrategies.length) {
            TargetStrategy t = this.enemyTargetStrategies[i];
            t.newRound(proud);
            ++i;
        }
        this.bt = new BearingTargeting().setName("              stat_bearing");
        this.bt.newRound(proud);
    }

    public void prepareTurn() {
        this.vBattlefield.clearTurnRates();
        this.vBattlefield.ageEnemyOccurences();
        this.vBattlefield.ageProudOccurences();
        ScanRecord currentScan = new ScanRecord(this.proud.getName(), this.proud.getTime());
        currentScan.pos = this.proud.getPosition();
        currentScan.atomicMove.heading = this.proud.getHeading();
        currentScan.atomicMove.velocity = this.proud.getVelocity();
        currentScan.power = this.proud.getEnergy();
        ScanRecord lastScan = this.proud.getStrategicLead().getAnalystsDB().getScanBase().getLastProudState();
        if (lastScan != null) {
            double deltaT = currentScan.getScanTime() - lastScan.getScanTime();
            currentScan.atomicMove.turnRate = (currentScan.atomicMove.heading - lastScan.atomicMove.heading) / deltaT;
            currentScan.atomicMove.accelerationRate = (currentScan.atomicMove.velocity - lastScan.atomicMove.velocity) / deltaT;
        }
        this.proud.getStrategicLead().getAnalystsDB().getScanBase().addProudState(currentScan);
    }

    public void processTurn() {
        this.prepareTurn();
        if (this.isEnemySpotted()) {
            this.vBattlefield.getCellAt(this.currentScan.pos).incEnemyOccurences();
            if (this.proud.getEnergy() > 0.1 && this.proud.getOthers() > 0) {
                this.virtualBullets.add(new StatisticBullet(this.proud, this.bt, StatisticBullet.BulletType.CONTINOUS));
                this.fireWaves.add(new StatisticWave(this.enemysLastFirePower, this.proud));
            }
        }
        Vector<FireWave> toBeRemoved = null;
        for (FireWave currentWave : this.fireWaves) {
            currentWave.increment();
            if (currentWave.isValid()) continue;
            if (toBeRemoved == null) {
                toBeRemoved = new Vector<FireWave>();
            }
            toBeRemoved.add(currentWave);
        }
        if (toBeRemoved != null) {
            this.fireWaves.removeAll(toBeRemoved);
        }
        DVektor proudsPosition = this.proud.getPosition();
        this.vBattlefield.getCellAt(proudsPosition).incProudsOccurences();
        double v = 6.4;
        double r = 360.0 / (10.0 - 0.75 * v) * v / (Math.PI * 2);
        DVektor p1 = DVektor.add(proudsPosition, new DVektor(r, 0.0));
        DVektor p2 = DVektor.add(proudsPosition, new DVektor(-r, 0.0));
        p1.rotate(proudsPosition, -this.proud.getHeading());
        p2.rotate(proudsPosition, -this.proud.getHeading());
        Vector<VirtualBullet> toBeRemovedVBullets = null;
        for (VirtualBullet bullet : this.virtualBullets) {
            bullet.increment();
            if (bullet.isValid()) {
                bullet.checkForHit(this.currentScan.pos);
                continue;
            }
            if (toBeRemovedVBullets == null) {
                toBeRemovedVBullets = new Vector<VirtualBullet>();
            }
            toBeRemovedVBullets.add(bullet);
        }
        if (toBeRemovedVBullets != null) {
            this.virtualBullets.removeAll(toBeRemovedVBullets);
        }
    }

    public void processHitByBullet(HitByBulletEvent event) {
        this.enemysLastFirePower = event.getPower();
        this.proud.getDriver().reset();
        this.hitThisRound = true;
        Bullet b = event.getBullet();
        this.enemyFireAnalyst.analyseHit(new DVektor(b.getX(), b.getY()), this.enemysLastFirePower);
    }

    public void processBulletHitBullet(BulletHitBulletEvent event) {
        this.enemysLastFirePower = event.getHitBullet().getPower();
        Bullet b = event.getBullet();
        this.enemyFireAnalyst.analyseHit(new DVektor(b.getX(), b.getY()), this.enemysLastFirePower);
    }

    public void collectDataFrom(BulletHitEvent event) {
        double power;
        double currentPower = event.getEnergy();
        double damageToBe = 4.0 * power + ((power = event.getBullet().getPower()) > 1.0 ? 2.0 * (power - 1.0) : 0.0);
        if (!Utils.isNear((double)damageToBe, (double)(this.currentScan.power - currentPower))) {
            this.enemysLastFirePower = this.currentScan.power - currentPower - damageToBe;
            this.fireWaves.add(new FireWave(this.enemysLastFirePower, this.proud));
        }
        this.currentScan.power = currentPower;
    }

    public void collectDataFrom(ScannedRobotEvent e) {
        this.lastScan = this.currentScan;
        this.currentScan = new ScanRecord(e.getName(), e.getTime());
        this.currentScan.bearingToScanner = LoudAndProud.normalRelativeAngle(this.proud.getHeading() + e.getBearing());
        this.currentScan.distanceToScanner = e.getDistance();
        this.currentScan.pos = new DVektor(this.proud.getX() + this.currentScan.distanceToScanner * Math.sin(Math.toRadians(this.currentScan.bearingToScanner)), this.proud.getY() + this.currentScan.distanceToScanner * Math.cos(Math.toRadians(this.currentScan.bearingToScanner)));
        this.currentScan.atomicMove.heading = e.getHeading();
        this.currentScan.atomicMove.velocity = e.getVelocity();
        this.currentScan.power = e.getEnergy();
        if (this.lastScan != null) {
            double deltaT = this.currentScan.getScanTime() - this.lastScan.getScanTime();
            this.currentScan.atomicMove.turnRate = (this.currentScan.atomicMove.heading - this.lastScan.atomicMove.heading) / deltaT;
            this.currentScan.atomicMove.accelerationRate = (this.currentScan.atomicMove.velocity - this.lastScan.atomicMove.velocity) / deltaT;
            if (this.lastScan.power > this.currentScan.power) {
                this.fireWaves.add(new FireWave(this.lastScan.power - this.currentScan.power, this.proud));
            }
        }
        if (this.lastScan != null && !this.lastScan.move.isClosed()) {
            if (this.lastScan.move.hasSameDirection(this.currentScan.atomicMove.velocity)) {
                this.currentScan.move = this.lastScan.move;
                this.currentScan.move.updateFrom(this.currentScan);
            } else if (this.currentScan.atomicMove.velocity == 0.0) {
                this.lastScan.move.closeMove(this.currentScan.getScanTime(), this.currentScan.pos);
                this.currentScan.move = this.lastScan.move;
            } else {
                this.lastScan.move.closeMove(this.lastScan.getScanTime(), this.lastScan.pos);
                this.currentScan.move = new Move(this.currentScan.getScanTime(), this.currentScan.getBotName(), this.currentScan.atomicMove.velocity, this.currentScan.pos);
                this.proud.getStrategicLead().getAnalystsDB().getScanBase().addEnemyMove(this.currentScan.move);
            }
        } else {
            this.currentScan.move = new Move(this.currentScan.getScanTime(), this.currentScan.getBotName(), this.currentScan.atomicMove.velocity, this.currentScan.pos);
            this.proud.getStrategicLead().getAnalystsDB().getScanBase().addEnemyMove(this.currentScan.move);
        }
        this.proud.getStrategicLead().getAnalystsDB().getScanBase().addEnemyScan(this.currentScan);
    }

    public boolean isEnemySpotted() {
        if (this.proud.getTime() - this.getSpotTime() > 14L) {
            this.lastScan = this.currentScan;
            this.currentScan = null;
            return false;
        }
        return true;
    }

    public void notifyFire() {
        for (Gunner gunner : this.proud.getStrategicLead().allGunners()) {
            this.virtualBullets.add(new VirtualBullet(this.proud, gunner.getTargetStrategy()));
        }
        this.virtualBullets.add(new StatisticBullet(this.proud, this.bt, StatisticBullet.BulletType.WAVE));
    }

    public DVektor getNextTarget() {
        return this.getNextTarget(0L, null);
    }

    public DVektor getNextTarget(long offset, DVektor positionAtOffset) {
        double[] anglesOfV = new double[]{50.0, 30.0, 30.0, 27.0, 21.0, 19.0, 16.0, 15.0, 13.0};
        DVektor proudsPos = positionAtOffset == null ? this.proud.getPosition() : positionAtOffset;
        Target bestTarget = new Target(proudsPos, 0.0, 0.0);
        bestTarget.rate = this.getVBattleField().getCellAt(bestTarget.pos).getRate() + this.getRateIn(bestTarget.pos, 10L + offset, true);
        bestTarget.arrivalTime = 0L;
        if (bestTarget.rate == 0.0) {
            return null;
        }
        double maxAngle = anglesOfV[(int)Math.abs(this.proud.getVelocity())];
        double dist = 52.1 + 0.9249999999999998 * Math.abs(this.proud.getVelocity());
        ArrayList<Target> targets = new ArrayList<Target>();
        if (this.proud.getVelocity() >= 0.0) {
            targets.add(new Target(proudsPos, 0.0, dist));
            targets.add(new Target(proudsPos, maxAngle, dist));
            targets.add(new Target(proudsPos, -maxAngle, dist));
            targets.add(new Target(proudsPos, maxAngle / 2.0, dist));
            targets.add(new Target(proudsPos, maxAngle / 2.0, dist));
        }
        if (this.proud.getVelocity() <= 0.0) {
            targets.add(new Target(proudsPos, 0.0, -dist));
            targets.add(new Target(proudsPos, maxAngle, -dist));
            targets.add(new Target(proudsPos, -maxAngle, -dist));
            targets.add(new Target(proudsPos, maxAngle / 2.0, -dist));
            targets.add(new Target(proudsPos, maxAngle / 2.0, -dist));
        }
        for (Target target : targets) {
            if (!this.proud.isInBorder(target.pos, this.proud.getProudsRadius())) continue;
            target.arrivalTime = this.proud.timeToReach(target.pos) + offset;
            target.rate = this.getVBattleField().getCellAt(target.pos).getRate() + this.getRateIn(target.pos, target.arrivalTime, false);
            this.proud.getVc().drawLine(target.pos, proudsPos, target.id, Color.white);
            if (!(target.rate < bestTarget.rate) && (target.rate != bestTarget.rate || !(target.deltaToOptimalEnemyAngle < bestTarget.deltaToOptimalEnemyAngle))) continue;
            bestTarget = target;
        }
        return bestTarget.pos;
    }

    private double getRateIn(DVektor position, long time, boolean draw) {
        double enemyDistance;
        double rate = 0.0;
        boolean hit = false;
        TargetStrategyStatistic.StrategyCount[] maxStrats = this.proud.getStrategicLead().getAnalystsDB().getEnemyMostProbableTargetStrat();
        if (this.isEnemySpotted() && (enemyDistance = position.getDistanceTo(this.getEnemyPos())) < 250.0) {
            rate += 170.0 * (1.0 - enemyDistance / 250.0);
        }
        for (FireWave currentWave : this.fireWaves) {
            int i = 0;
            while (i < currentWave.getPossibleBulletVelocities().length) {
                BulletBeam bulletbeam = currentWave.getPossibleBulletVelocities()[i];
                if (this.isProbableTargetStrat(bulletbeam.source.describe(), maxStrats)) {
                    double distanceToTarget;
                    hit = false;
                    DVektor pBulletT = null;
                    DVektor pBulletT1 = null;
                    for (DVektor bulletV : bulletbeam) {
                        pBulletT = currentWave.bulletPosAt(-2L, bulletV);
                        if (!this.bulletHitsBot(pBulletT, pBulletT1 = currentWave.bulletPosAt(time + 1L, bulletV), position)) continue;
                        hit = true;
                    }
                    double angleWaveToPos = currentWave.emittingPosition.getDirectionTo(position);
                    double delta = Math.abs(bulletbeam.vDirect.getDirection() - angleWaveToPos);
                    if (delta < bulletbeam.beamAngle && (distanceToTarget = currentWave.emittingPosition.getDistanceTo(position)) > currentWave.getCurrentRadius() && distanceToTarget < pBulletT1.getDistanceTo(currentWave.emittingPosition)) {
                        hit = true;
                    }
                    if (hit) {
                        rate += 3.0 + Math.max(0.0, (bulletbeam.beamAngle - delta) * 2.0);
                    }
                }
                ++i;
            }
        }
        this.drawBeams(time);
        return rate;
    }

    public boolean bulletHitsBot(DVektor pBulletT, DVektor pBulletT1, DVektor position) {
        double cosAlpha;
        double radius = this.proud.getProudsRadius();
        double bulletWay = pBulletT.getDistanceTo(pBulletT1);
        double distancePBulletToBot = pBulletT.getDistanceTo(position);
        double radix = Math.pow(distancePBulletToBot * (cosAlpha = Math.cos(Math.toRadians(pBulletT.getDirectionTo(pBulletT1) - pBulletT.getDirectionTo(position)))), 2.0) + (radius * radius - distancePBulletToBot * distancePBulletToBot);
        if (radix == 0.0) {
            return true;
        }
        if (radix > 0.0) {
            double c1 = distancePBulletToBot * cosAlpha + Math.sqrt(radix);
            double c2 = distancePBulletToBot * cosAlpha - Math.sqrt(radix);
            if (c1 > 0.0 && c1 < bulletWay) {
                return true;
            }
            return c2 > 0.0 && c2 < bulletWay;
        }
        return false;
    }

    private boolean isProbableTargetStrat(String stratName, TargetStrategyStatistic.StrategyCount[] maxStrat) {
        int i = 0;
        while (i < Math.min(maxStrat.length, 2)) {
            if (maxStrat[i] != null && maxStrat[i].strat.describe().equals(stratName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double getEnemyDistance() {
        return this.currentScan == null ? Double.POSITIVE_INFINITY : this.currentScan.distanceToScanner;
    }

    public long getSpotTime() {
        return this.currentScan == null ? -1000L : this.currentScan.getScanTime();
    }

    public double getEnemyVelocitiy() {
        return this.currentScan == null ? 0.0 : this.currentScan.atomicMove.velocity;
    }

    public String getEnemyName() {
        return this.currentScan == null ? "<unbekannt>" : this.currentScan.getBotName();
    }

    public double getEnemyHeading() {
        return this.currentScan == null ? 0.0 : this.currentScan.atomicMove.heading;
    }

    public DVektor getEnemyPos() {
        return this.currentScan == null ? null : this.currentScan.pos;
    }

    public double getEnemyTurnRate() {
        return this.currentScan == null ? 0.0 : this.currentScan.atomicMove.turnRate;
    }

    public double getEnemyAccRate() {
        return this.currentScan == null ? 0.0 : this.currentScan.atomicMove.accelerationRate;
    }

    public double getEnemyBearing() {
        return this.currentScan == null ? 0.0 : this.currentScan.bearingToScanner;
    }

    public double getEnemyPower() {
        return this.currentScan == null ? 0.0 : this.currentScan.power;
    }

    public double getEnemysLastPower() {
        return this.enemysLastFirePower;
    }

    public VirtualBattleField getVBattleField() {
        return this.vBattlefield;
    }

    public TargetStrategy[] getEnemyTargetStrategies() {
        return this.enemyTargetStrategies;
    }

    public EnemyFireAnalyst getEnemyFireAnalyst() {
        return this.enemyFireAnalyst;
    }

    public Vector<FireWave> getFireWaves() {
        return this.fireWaves;
    }

    public void paint(Graphics2D g) {
        this.vBattlefield.paint(g);
        this.proud.getStrategicLead().getAnalystsDB().paint(this.proud);
    }

    public void drawBeams(long time) {
        TargetStrategyStatistic.StrategyCount[] maxStrats = this.proud.getStrategicLead().getAnalystsDB().getEnemyMostProbableTargetStrat();
        for (FireWave currentWave : this.fireWaves) {
            int i = 0;
            while (i < currentWave.getPossibleBulletVelocities().length) {
                BulletBeam bulletbeam = currentWave.getPossibleBulletVelocities()[i];
                DVektor startL = null;
                DVektor startM = null;
                DVektor startR = null;
                DVektor endL = null;
                DVektor endM = null;
                DVektor endR = null;
                int j = 0;
                for (DVektor bulletV : bulletbeam) {
                    DVektor pBulletT = currentWave.bulletPosAt(-2L, bulletV);
                    DVektor pBulletT1 = currentWave.bulletPosAt(time, bulletV);
                    if (j == 0) {
                        startM = pBulletT;
                        endM = pBulletT1;
                    }
                    if (j == 1) {
                        startR = pBulletT;
                        endR = pBulletT1;
                    }
                    if (j == 2) {
                        startL = pBulletT;
                        endL = pBulletT1;
                    }
                    ++j;
                }
                Color color = VirtualCanvas.dimColor(bulletbeam.source.getColorCode(), this.isProbableTargetStrat(bulletbeam.source.describe(), maxStrats) ? 1.0 : 0.2);
                this.proud.getVc().drawLine(startM, endM, String.valueOf(currentWave.label) + " strat=" + bulletbeam.source.describe(), color);
                this.proud.getVc().drawLine(startR, endR, "", color);
                this.proud.getVc().drawLine(startL, endL, "", color);
                this.proud.getVc().drawLine(startM, startR, "", color);
                this.proud.getVc().drawLine(startM, startL, "", color);
                this.proud.getVc().drawLine(endM, endR, "", color);
                this.proud.getVc().drawLine(endM, endL, "", color);
                ++i;
            }
        }
    }

    public void beforeTurn() {
        this.hitThisRound = false;
    }

    public boolean isHitThisRound() {
        return this.hitThisRound;
    }

    public class Target {
        DVektor pos = null;
        double rate = 0.0;
        double deltaToOptimalEnemyAngle = 0.0;
        long arrivalTime = 0L;
        String id = "";

        Target(DVektor position, double angle, double distance) {
            this.id = angle + "/" + distance;
            this.pos = DVektor.add(position, DVektor.fromPolarCoord(TacticalLead.this.proud.getHeading() + angle, distance));
            if (TacticalLead.this.proud.getTacticLead().isEnemySpotted()) {
                double targetBearing = this.pos.getDirectionTo(TacticalLead.this.proud.getTacticLead().getEnemyPos());
                this.deltaToOptimalEnemyAngle = LoudAndProud.normalRelativeAngle(targetBearing + 90.0 - (TacticalLead.this.proud.getHeading() + angle));
                if (this.deltaToOptimalEnemyAngle > 90.0) {
                    this.deltaToOptimalEnemyAngle -= 180.0;
                }
                if (this.deltaToOptimalEnemyAngle < -90.0) {
                    this.deltaToOptimalEnemyAngle += 180.0;
                }
                this.deltaToOptimalEnemyAngle = Math.abs(this.deltaToOptimalEnemyAngle);
            }
        }
    }
}

