/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.utils.DVektor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Iterator;

public class VirtualBattleField {
    private static final int CELLSIZE = 40;
    private static final double CORNER_SIZE = 2.0;
    private static boolean FILL = true;
    public static final double AGING_PER_TURN = 0.3;
    private int sizeX;
    private int sizeY;
    private LoudAndProud proud;
    private Cell[][] cells;
    private double currentAgingPerTurn = 0.3;

    public VirtualBattleField(LoudAndProud proud) {
        this.proud = proud;
        this.sizeX = new Double(this.proud.getBattleFieldWidth() / 40.0).intValue();
        this.sizeY = new Double(this.proud.getBattleFieldHeight() / 40.0).intValue();
        this.cells = new Cell[this.sizeX][this.sizeY];
        int x = 0;
        while (x < this.sizeX) {
            int y = 0;
            while (y < this.sizeY) {
                this.cells[x][y] = new Cell(x, y);
                if (x != 0 && y != 0 && x != this.sizeX - 1 && y != this.sizeY - 1) {
                    this.cells[x][y].staticRate = 0.0;
                }
                if (x == 0 || y == 0 || x == this.sizeX - 1 || y == this.sizeY - 1) {
                    this.cells[x][y].staticRate = 20.0;
                }
                ++y;
            }
            ++x;
        }
        Iterator circle = this.getCellCircle(0, 0, 2, true);
        while (circle.hasNext()) {
            ((Cell)circle.next()).staticRate = 100.0;
        }
        circle = this.getCellCircle(this.sizeX - 1, 0, 2, true);
        while (circle.hasNext()) {
            ((Cell)circle.next()).staticRate = 100.0;
        }
        circle = this.getCellCircle(0, this.sizeY - 1, 2, true);
        while (circle.hasNext()) {
            ((Cell)circle.next()).staticRate = 100.0;
        }
        circle = this.getCellCircle(this.sizeX - 1, this.sizeY - 1, 2, true);
        while (circle.hasNext()) {
            ((Cell)circle.next()).staticRate = 100.0;
        }
    }

    public void paint(Graphics2D g) {
        g.setColor(Color.blue);
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            ((Cell)allCells.next()).paint(g);
        }
    }

    public void clearTurnRates() {
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            Cell cell = (Cell)allCells.next();
            cell.clearTurnRate();
        }
    }

    public void ageEnemyOccurences() {
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            Cell cell = (Cell)allCells.next();
            if (!(cell.enemyOccurences > 0.0)) continue;
            cell.enemyOccurences -= this.currentAgingPerTurn;
        }
    }

    public void ageProudOccurences() {
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            Cell cell = (Cell)allCells.next();
            if (!(cell.proudOccurences > 0.0)) continue;
            Cell cell2 = cell;
            cell2.proudOccurences = cell2.proudOccurences - 0.1;
        }
    }

    public Cell getCellAt(double x, double y) {
        return this.saveGetCell((int)x / 40, (int)y / 40);
    }

    private Iterator cellIterator() {
        return new CellIterator();
    }

    public Iterator getCellCircle(DVektor middle, int radius, boolean fill) {
        return this.getCellCircle(middle, radius, fill, null);
    }

    public Iterator getCellCircle(DVektor middle, int radius, boolean fill, CellFilter aFilter) {
        Cell eCell = this.getCellAt(middle);
        if (eCell == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public void remove() {
                }
            };
        }
        return this.getCellCircle(eCell.x, eCell.y, radius, fill, aFilter);
    }

    private Iterator getCellCircle(int centerX, int centerY, int radius, boolean fill) {
        return this.getCellCircle(centerX, centerY, radius, fill, null);
    }

    private Iterator getCellCircle(int centerX, int centerY, int radius, boolean fill, CellFilter aFilter) {
        HashSet<Cell> foundCells = new HashSet<Cell>();
        int d = -radius;
        int x = radius;
        int y = 0;
        while (y <= x) {
            foundCells.add(this.filteredSaveGetCell(centerX + x, centerY + y, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX - x, centerY + y, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX + x, centerY - y, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX - x, centerY - y, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX + y, centerY + x, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX - y, centerY + x, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX + y, centerY - x, aFilter));
            foundCells.add(this.filteredSaveGetCell(centerX - y, centerY - x, aFilter));
            if (fill) {
                int i = centerX - x;
                while (i < centerX + x) {
                    foundCells.add(this.filteredSaveGetCell(i, centerY + y, aFilter));
                    foundCells.add(this.filteredSaveGetCell(i, centerY - y, aFilter));
                    ++i;
                }
            }
            d = d + 2 * y + 1;
            ++y;
            if (d <= 0) continue;
            d = d - 2 * x + 2;
            --x;
        }
        foundCells.remove(null);
        return foundCells.iterator();
    }

    public Cell saveGetCell(int x, int y) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY) {
            return null;
        }
        return this.cells[x][y];
    }

    public Cell filteredSaveGetCell(int x, int y, CellFilter aFilter) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY) {
            return null;
        }
        if (aFilter != null) {
            if (aFilter.isValid(this.cells[x][y], this.proud)) {
                return this.cells[x][y];
            }
            return null;
        }
        return this.cells[x][y];
    }

    public Cell getCellAt(DVektor vec) {
        return this.getCellAt(vec.x, vec.y);
    }

    public Iterator getRechableCells(DVektor vec, int radiusInCells) {
        return this.getCellCircle(vec, radiusInCells, FILL, new CellFilter(){

            public boolean isValid(Cell aCell, LoudAndProud proud) {
                boolean isReachable = proud.isDirectlyReachable(aCell.getCenter());
                return isReachable;
            }
        });
    }

    public Cell getMostFrequentedCell() {
        Cell frequencyMax = this.getCellAt(0.0, 0.0);
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            Cell cell = (Cell)allCells.next();
            if (!(cell.enemyOccurences > frequencyMax.enemyOccurences)) continue;
            frequencyMax = cell;
        }
        return frequencyMax;
    }

    public int getDistanceInCells(double d) {
        return (int)d / 40;
    }

    public double getCellSize() {
        return 40.0;
    }

    public void setCurrentAgingPerTurn(double aging) {
        this.currentAgingPerTurn = aging;
    }

    public Cell getProudsMostFrequentedCell() {
        Cell frequencyMax = this.getCellAt(0.0, 0.0);
        Iterator allCells = this.cellIterator();
        while (allCells.hasNext()) {
            Cell cell = (Cell)allCells.next();
            if (!(cell.proudOccurences > frequencyMax.proudOccurences)) continue;
            frequencyMax = cell;
        }
        return frequencyMax;
    }

    public class CellIterator
    implements Iterator {
        int curX = 0;
        int curY = 0;

        public boolean hasNext() {
            return this.curX < VirtualBattleField.this.sizeX && this.curY < VirtualBattleField.this.sizeY;
        }

        public Object next() {
            Cell result = VirtualBattleField.this.cells[this.curX][this.curY];
            ++this.curX;
            if (this.curX >= VirtualBattleField.this.sizeX) {
                this.curX = 0;
                ++this.curY;
            }
            return result;
        }

        public void remove() {
        }
    }

    public static interface CellFilter {
        public boolean isValid(Cell var1, LoudAndProud var2);
    }

    public class Cell {
        public int x;
        public int y;
        public double staticRate;
        private double turnRate;
        private String markNote;
        private String markNote2;
        public double enemyOccurences;
        private double proudOccurences;
        public DVektor lowerLeft;
        public DVektor upperRight;

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
            this.lowerLeft = new DVektor(x * 40, y * 40);
            this.upperRight = new DVektor(x * 41, y * 41);
            this.markNote = null;
            this.markNote2 = null;
            this.enemyOccurences = 0.0;
            this.proudOccurences = 0.0;
        }

        public void clearTurnRate() {
            this.turnRate = 0.0;
            this.markNote = null;
            this.markNote2 = null;
        }

        public void paint(Graphics2D g) {
            if (this.enemyOccurences > 0.0) {
                g.setColor(Color.cyan);
                g.drawRect(this.lowerLeft.getIntX() + 2, this.lowerLeft.getIntY() + 2, 36, 36);
                g.drawString("eO:" + VirtualBattleField.this.proud.printDouble(this.enemyOccurences), this.lowerLeft.getIntX() + 6, this.lowerLeft.getIntY() + 20 + 15);
            }
            if (this.markNote != null) {
                g.setColor(Color.yellow);
                g.drawRect(this.lowerLeft.getIntX() + 1, this.lowerLeft.getIntY() + 1, 38, 38);
                g.drawString(this.markNote, this.lowerLeft.getIntX() + 6, this.lowerLeft.getIntY() + 20 + 9);
            }
            if (this.markNote2 != null) {
                g.setColor(Color.yellow);
                g.drawRect(this.lowerLeft.getIntX() + 1, this.lowerLeft.getIntY() + 1, 38, 38);
                g.drawString(this.markNote2, this.lowerLeft.getIntX() + 6, this.lowerLeft.getIntY() + 20 - 16);
            }
        }

        public void paintCenter(Graphics2D g) {
            g.setColor(Color.green);
            g.fillRect(this.lowerLeft.getIntX() + 20, this.lowerLeft.getIntY() + 20, 4, 4);
        }

        public DVektor getCenter() {
            return new DVektor(this.x * 40 + 20, this.y * 40 + 20);
        }

        public double getRate() {
            return this.staticRate + this.turnRate;
        }

        public void incTurnRate(double rate) {
            this.turnRate += rate;
        }

        public boolean beenHereRecently() {
            return this.proudOccurences > 0.1;
        }

        public String toString() {
            return "(x=" + this.x + ",y=" + this.y + ") center=" + this.getCenter().toString() + " rate=" + LoudAndProud.printStaticDouble(this.getRate()) + " turnrate=" + LoudAndProud.printStaticDouble(this.turnRate) + " statrate=" + LoudAndProud.printStaticDouble(this.staticRate);
        }

        public void mark(String markNote) {
            this.markNote = markNote;
        }

        public void mark2(String mark) {
            this.markNote2 = mark;
        }

        public void incEnemyOccurences() {
            if (this.enemyOccurences <= 10.0) {
                this.enemyOccurences += 1.0;
            }
        }

        public void incProudsOccurences() {
            if (this.proudOccurences <= 10.0) {
                this.proudOccurences += 1.0;
            }
        }
    }
}

