/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulletBeam
implements Iterable<DVektor> {
    public DVektor vDirect;
    public double beamAngle;
    public DVektor vRigthBorder;
    public DVektor vLeftBorder;
    public TargetStrategy source;

    public BulletBeam(DVektor vDirect, double beamAngle, TargetStrategy source) {
        this.vDirect = vDirect;
        this.beamAngle = beamAngle;
        this.source = source;
        this.vRigthBorder = vDirect.copy();
        this.vLeftBorder = vDirect.copy();
        if (beamAngle >= 0.0) {
            this.vRigthBorder.rotate(beamAngle);
            this.vLeftBorder.rotate(-beamAngle);
        }
    }

    @Override
    public Iterator<DVektor> iterator() {
        return new LineIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LineIterator
    implements Iterator<DVektor> {
        int state = 0;

        @Override
        public boolean hasNext() {
            if (BulletBeam.this.beamAngle >= 0.0) {
                return this.state <= 2;
            }
            return this.state <= 0;
        }

        @Override
        public DVektor next() {
            DVektor result = null;
            if (this.state == 0) {
                result = BulletBeam.this.vDirect;
            }
            if (this.state == 1) {
                result = BulletBeam.this.vRigthBorder;
            }
            if (this.state == 2) {
                result = BulletBeam.this.vLeftBorder;
            }
            ++this.state;
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

